/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale;

import java.net.SocketException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.kingdoms.commands.KingdomsCommandHandler;
import org.kingdoms.config.managers.ConfigWatcher;
import org.kingdoms.gui.GUIConfig;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.Language;
import org.kingdoms.locale.LanguageManager;
import org.kingdoms.locale.SupportedLanguage;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.network.CommitDifference;
import org.kingdoms.utils.network.JSONRequester;

public final class LanguagePackDownloader {
    private final @NonNull SupportedLanguage lang;
    private @Nullable Consumer<Downloader> onFileStateChange;
    private final Map<DownloadState, List<Downloader>> downloads = new ConcurrentHashMap<DownloadState, List<Downloader>>(150);
    private final List<CompletableFuture<Void>> concurrentlyDownloadingFiles = new ArrayList<CompletableFuture<Void>>(150);
    private @Nullable CommitDifference difference;

    public LanguagePackDownloader(@NonNull SupportedLanguage lang) {
        this.lang = lang;
        for (DownloadState state : DownloadState.values()) {
            this.downloads.put(state, new ArrayList());
        }
    }

    public LanguagePackDownloader onFileStateChange(@Nullable Consumer<Downloader> onFileStateChange) {
        this.onFileStateChange = onFileStateChange;
        return this;
    }

    public void update(CommitDifference difference) {
        this.difference = difference;
    }

    public Map<DownloadState, List<Downloader>> getDownloads() {
        return this.downloads;
    }

    public boolean isUpdating() {
        return this.difference != null;
    }

    public CompletableFuture<Void> downloadAsync() {
        CompletableFuture<Void> main = new CompletableFuture<Void>();
        Kingdoms.taskScheduler().async().execute(() -> this.download().thenRun(() -> main.complete(null)));
        return main;
    }

    public int getTotalFiles() {
        return this.isUpdating() ? this.difference.getFiles().size() : 1 + Language.getDefault().getGUIs().size();
    }

    public CompletableFuture<Void> download() {
        LanguageManager.setCommitSHA(this.lang, this.isUpdating() ? "UPDATING" : "INSTALLING");
        String name = this.lang.getLowerCaseName();
        Path repoFolder = LanguageManager.REPO_FOLDER.resolve("languages").resolve(name);
        Path mainGUIDir = repoFolder.resolve("guis");
        if (this.isUpdating()) {
            for (String fileName : this.difference.getFiles()) {
                new Downloader(FileType.UPDATING, "resources/languages/" + name + '/' + fileName, repoFolder.resolve(fileName)).download();
            }
        } else {
            new Downloader(FileType.LANGUAGE, "resources/languages/" + name + '/' + name + ".yml", repoFolder.resolve(name + ".yml")).download();
            for (String gui : Language.getDefault().getGUIs().keySet()) {
                new Downloader(FileType.GUI, "resources/languages/" + name + "/guis/" + gui + ".yml", mainGUIDir.resolve(gui + ".yml")).download();
            }
        }
        CompletableFuture<Void> all = CompletableFuture.allOf(this.concurrentlyDownloadingFiles.toArray(new CompletableFuture[0]));
        return all.thenRun(() -> {
            LanguageManager.setCommitSHA(this.lang, JSONRequester.getMasterSHA());
            this.lang.initialize();
            LanguageManager.load(this.lang);
            GUIConfig.registerGUIsFor(this.lang);
            ConfigWatcher.registerGUIWatchers(this.lang);
            KingdomsCommandHandler.reload();
        });
    }

    public static enum DownloadState {
        FAILED_CRITICAL,
        FAILED_RETRYING,
        RETRYING,
        DONE,
        NOT_FOUND;

    }

    public final class Downloader {
        private static final int MAX_ATTEMPTS = 5;
        public final FileType fileType;
        public final String downloadURL;
        public final Path savePath;
        public DownloadState state;
        public int attempts = 0;
        public Throwable lastError;

        public Downloader(FileType fileType, String downloadURL, Path savePath) {
            this.fileType = fileType;
            this.downloadURL = downloadURL;
            this.savePath = savePath;
        }

        public boolean allAttemptsFailed() {
            return this.attempts >= 5;
        }

        public CompletableFuture<Void> download() {
            CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
            Kingdoms.taskScheduler().async().execute(() -> {
                while (this.attempts++ < 5) {
                    try {
                        URL found = JSONRequester.downloadGitHubFile(this.downloadURL, this.savePath);
                        if (found != null) {
                            this.state = DownloadState.DONE;
                            break;
                        }
                        this.state = DownloadState.NOT_FOUND;
                        break;
                    }
                    catch (Throwable ex) {
                        this.lastError = ex;
                        if (!ex.getMessage().contains("timed out") && !(ex instanceof SocketException)) {
                            this.state = DownloadState.FAILED_CRITICAL;
                            break;
                        }
                        this.state = DownloadState.RETRYING;
                        if (LanguagePackDownloader.this.onFileStateChange == null) continue;
                        LanguagePackDownloader.this.onFileStateChange.accept(this);
                    }
                }
                if (this.allAttemptsFailed()) {
                    this.state = DownloadState.FAILED_RETRYING;
                }
                Objects.requireNonNull(this.state, () -> "Unknown state " + this.attempts + " - " + this.lastError.getMessage());
                ((List)LanguagePackDownloader.this.downloads.get((Object)this.state)).add(this);
                if (LanguagePackDownloader.this.onFileStateChange != null) {
                    LanguagePackDownloader.this.onFileStateChange.accept(this);
                }
                completableFuture.complete(null);
            });
            LanguagePackDownloader.this.concurrentlyDownloadingFiles.add(completableFuture);
            return completableFuture;
        }
    }

    public static enum FileType {
        LANGUAGE,
        GUI,
        UPDATING;

    }
}

