/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale;

import com.google.common.base.Enums;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.annotations.AdvancedMessage;
import org.kingdoms.config.annotations.Comment;
import org.kingdoms.config.managers.ConfigManager;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.snakeyaml.markers.Mark;
import org.kingdoms.libs.snakeyaml.nodes.MappingNode;
import org.kingdoms.libs.snakeyaml.nodes.Node;
import org.kingdoms.libs.snakeyaml.nodes.NodePair;
import org.kingdoms.libs.snakeyaml.nodes.NodeType;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.libs.xseries.messages.Titles;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.Language;
import org.kingdoms.locale.LanguageEntry;
import org.kingdoms.locale.SupportedLanguage;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.messenger.DefinedMessenger;
import org.kingdoms.locale.provider.AdvancedMessageProvider;
import org.kingdoms.locale.provider.MessageProvider;
import org.kingdoms.locale.provider.NullMessageProvider;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.config.NodeInterpreter;
import org.kingdoms.utils.config.adapters.YamlWithDefaults;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;
import org.kingdoms.utils.fs.FSUtil;
import org.kingdoms.utils.internal.arrays.ArrayUtils;
import org.kingdoms.utils.network.JSONRequester;

public final class LanguageManager {
    protected static final String LANG_FOLDER_NAME = "languages";
    protected static final String REPO_NAME = "repository";
    private static Language DEFAULT_LANGUAGE = Language.getDefault();
    public static final Path LANG_FOLDER = Kingdoms.getPath("languages");
    public static final Path REPO_FOLDER = Kingdoms.getPath("repository");
    public static final Path LANGUAGES_REPO_FOLDER = REPO_FOLDER.resolve("languages");
    protected static final String INSTALLING_STATE = "INSTALLING";
    protected static final String UPDATING_STATE = "UPDATING";
    private static final Map<Class<? extends DefinedMessenger>, DefinedMessenger[]> MESSENGERS = new LinkedHashMap<Class<? extends DefinedMessenger>, DefinedMessenger[]>(1);
    final YamlWithDefaults adapter;
    final SupportedLanguage lang;

    public static <T extends DefinedMessenger> void registerMessenger(Class<T> clazz, T[] values) {
        Objects.requireNonNull(clazz, "Messenger class cannot be null");
        Objects.requireNonNull(values, "Messenger values cannot be null");
        MESSENGERS.put((Class<? extends DefinedMessenger>)clazz, (DefinedMessenger[])values);
    }

    public static <T extends Enum<?>> void registerMessenger(Class<T> clazz) {
        Objects.requireNonNull(clazz, "Messenger class cannot be null");
        Enum[] constants = Objects.requireNonNull((Enum[])clazz.getEnumConstants(), "The provided class is not an enum. Consider using registerMessenger(Class, T[]) instead.");
        MESSENGERS.put(clazz, (DefinedMessenger[])constants);
    }

    public static void uninstall(SupportedLanguage lang) {
        KLogger.info("Uninstalling " + lang);
        lang.uninitialize();
        LanguageManager.removeFolders(lang);
    }

    public static void setCommitSHA(SupportedLanguage lang, String commitSHA) {
        lang.setInstalledCommitSHA(commitSHA);
        ConfigManager.getGlobals().set(new String[]{"updates", LANG_FOLDER_NAME, lang.getLowerCaseName()}, (Object)commitSHA);
        ConfigManager.getGlobalsAdapter().saveConfig();
    }

    private LanguageManager(SupportedLanguage lang) {
        this.lang = Objects.requireNonNull(lang, "Cannot load null language");
        if (!lang.isInstalled()) {
            throw new IllegalArgumentException("Cannot load a language that's not installed: " + lang);
        }
        this.adapter = Objects.requireNonNull(lang.getAdapter(), () -> "Null adapter for language: " + lang);
    }

    public static void removeFolders(SupportedLanguage lang) {
        try {
            FSUtil.deleteFolder(lang.getGUIFolder());
            FSUtil.deleteFolder(lang.getRepoPath());
            Files.deleteIfExists(lang.getMainLanguageFile());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean shouldLoad(SupportedLanguage lang) {
        ConfigSection commitShaConfigs = ConfigManager.getGlobals().createSection("updates", LANG_FOLDER_NAME);
        String commitSHA = commitShaConfigs.getString(lang.getLowerCaseName());
        if (INSTALLING_STATE.equals(commitSHA) || UPDATING_STATE.equals(commitSHA)) {
            KLogger.warn("The installation for " + lang.getLowerCaseName() + " has ended abruptly previously, removing it...");
            commitShaConfigs.set(lang.getLowerCaseName(), null);
            ConfigManager.getGlobalsAdapter().saveConfig();
            return false;
        }
        Path langRepoPath = lang.getRepoPath();
        if (lang == Language.getDefault() || Files.exists(langRepoPath, new LinkOption[0]) && !FSUtil.isFolderEmpty(langRepoPath)) {
            if (lang != Language.getDefault() && !commitShaConfigs.isSet(lang.getLowerCaseName())) {
                KLogger.warn("Couldn't find the language version for " + lang.getLowerCaseName() + " but it's in the repository folder.\nThis means that you manually installed the language yourself, modified globals.yml file, or the installation did not complete successfully.\nThe plugin will automatically fix this for you.");
                commitShaConfigs.set(lang.getLowerCaseName(), (Object)JSONRequester.getMasterSHA());
                ConfigManager.getGlobalsAdapter().saveConfig();
            }
            lang.initialize();
            if (lang != Language.getDefault()) {
                lang.setInstalledCommitSHA(commitShaConfigs.getString(lang.getLowerCaseName()));
            }
            KLogger.info("Loading language: " + lang + " (version " + lang.getInstalledCommitSHA() + ')');
            return true;
        }
        if (commitShaConfigs.isSet(lang.getLowerCaseName())) {
            KLogger.warn("The plugin found version information about " + lang.getLowerCaseName() + " installed language, however the files couldn't be found.\nThis means that you manually uninstalled it by removing folders from 'repository' folder of the plugin.\nThe plugin will automatically fix this for you.");
            commitShaConfigs.set(lang.getLowerCaseName(), null);
            ConfigManager.getGlobalsAdapter().saveConfig();
            return false;
        }
        return false;
    }

    public static Language getDefaultLanguage() {
        return DEFAULT_LANGUAGE;
    }

    public static Language localeOf(UUID player) {
        return KingdomPlayer.getKingdomPlayer(player).getLanguage();
    }

    public static Language localeOf(CommandSender sender) {
        return sender instanceof Player ? LanguageManager.localeOf((Player)sender) : LanguageManager.getDefaultLanguage();
    }

    public static Language localeOf(OfflinePlayer sender) {
        return sender == null ? LanguageManager.getDefaultLanguage() : KingdomPlayer.getKingdomPlayer(sender).getLanguage();
    }

    public static Language localeOf(Player sender) {
        return LanguageManager.localeOf((OfflinePlayer)sender);
    }

    public void load() {
        try {
            Files.createDirectories(LANG_FOLDER, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!this.adapter.getFile().exists()) {
            if (this.lang == Language.getDefault()) {
                this.adapter.createEmptyConfigIfNull();
                this.loadEnglishDefaults();
                this.adapter.saveConfig();
            } else {
                this.adapter.saveDefaultConfig();
            }
            this.adapter.reload();
        } else {
            this.adapter.load();
        }
        if (this.adapter.getConfig() != null) {
            new EntryLoader();
        }
    }

    public static void load(SupportedLanguage lang) {
        try {
            if (LanguageManager.shouldLoad(lang)) {
                new LanguageManager(lang).load();
            } else {
                LanguageManager.removeFolders(lang);
            }
        }
        catch (Exception ex) {
            KLogger.error("An exception has occurred while loading main language file for: " + lang.name());
            ex.printStackTrace();
        }
    }

    private static void loadDefaultLanguage() {
        Language lang = SupportedLanguage.fromName(KingdomsConfig.LANG.getString());
        if (lang == null) {
            KLogger.error("Unknown language '" + KingdomsConfig.LANG.getString() + "' switching to English.");
            lang = Language.getDefault();
        }
        if (!lang.isInstalled()) {
            KLogger.error("You cannot use " + lang + " language as the default language because it's not installed.");
            lang = Language.getDefault();
        }
        DEFAULT_LANGUAGE = lang;
        KLogger.info("Default language: " + lang.getLowerCaseName() + " (" + lang.getNativeName() + ')');
    }

    public static void loadAll() {
        try {
            LanguageManager.loadAll0();
        }
        catch (IOException e) {
            KLogger.error("Failed to load language files:");
            e.printStackTrace();
        }
        LanguageManager.addRepositoryInfo();
        LanguageManager.loadDefaultLanguage();
    }

    static void addRepositoryInfo() {
        if (!Files.exists(REPO_FOLDER, new LinkOption[0])) {
            return;
        }
        try {
            Files.write(REPO_FOLDER.resolve("README.txt"), Arrays.asList("The repository folder is a reference folder meant for read-only purposes.", "You shouldn't add, delete or modify any of the files.", "This is the folder used to generate back language files if they", "are deleted without having to redownload them. If you want to uninstall a certain", "language, simply do it from '/k admin languagepacks' command in-game instead."), StandardCharsets.US_ASCII, new OpenOption[0]);
        }
        catch (IOException e) {
            KLogger.error("Failed to add info file to libs folder:");
            e.printStackTrace();
        }
    }

    static void loadAll0() throws IOException {
        if (Files.exists(LANG_FOLDER, new LinkOption[0])) {
            try (Stream<Path> walker = Files.walk(LANG_FOLDER, new FileVisitOption[0]);){
                walker.forEach(langName -> {
                    if (langName.equals(LANG_FOLDER)) {
                        return;
                    }
                    String name = langName.getFileName().toString();
                    if (!name.endsWith(".yml")) {
                        throw new IllegalStateException("Not a language file: " + langName);
                    }
                    name = name.substring(0, name.length() - 4);
                    LanguageManager.getLanguageOrWarn(name);
                });
            }
        }
        for (SupportedLanguage lang : SupportedLanguage.VALUES) {
            LanguageManager.load(lang);
        }
    }

    public static SupportedLanguage getLanguageOrWarn(String name) {
        SupportedLanguage lang = (SupportedLanguage)Enums.getIfPresent(SupportedLanguage.class, (String)name.toUpperCase(Locale.ENGLISH)).orNull();
        if (lang == null) {
            KLogger.error("Unknown language found in 'languages' folder: " + name);
            KLogger.error("It's either named incorrectly or not built into the plugin. In order to add a new language to the plugin you need to contact the developer with the necessary files.");
        }
        return lang;
    }

    private void putDefault(DefinedMessenger lang) {
        try {
            String errors;
            MessageObject obj;
            String def = lang.getDefaultValue();
            MessageCompiler compiler = def == null ? null : new MessageCompiler(def);
            MessageObject messageObject = obj = compiler == null ? null : compiler.compileObject();
            if (compiler != null && compiler.hasErrors() && !(errors = compiler.joinExceptions()).contains("macro")) {
                throw new AssertionError((Object)("Default message contains error for " + lang.name() + '\n' + errors));
            }
            AdvancedMessage data = lang.getAdvancedData();
            MessageProvider defaultProvider = data == null ? new MessageProvider(obj) : LanguageManager.getAdvancedMessageProvider(data, obj);
            this.lang.addMessage(lang, defaultProvider);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error while parsing default language entry for " + lang, ex);
        }
    }

    @NotNull
    private static AdvancedMessageProvider getAdvancedMessageProvider(AdvancedMessage data, MessageObject obj) {
        MessageObject actionbar;
        MessageObject messageObject = actionbar = data.actionbar().isEmpty() ? null : new MessageCompiler(data.actionbar()).compileObject();
        Titles titles = !data.title().isEmpty() || !data.subtitle().isEmpty() ? new Titles(data.title().isEmpty() ? null : data.title(), data.subtitle().isEmpty() ? null : data.subtitle(), 10, 40, 10) : null;
        AdvancedMessageProvider extra = new AdvancedMessageProvider(obj, actionbar, titles);
        if (!data.sound().isEmpty()) {
            extra.withSound(((XSound)XSound.matchXSound((String)data.sound()).orElse(null)).record());
        }
        return extra;
    }

    private void saveDefault(DefinedMessenger lang) {
        Node keyNode;
        ConfigSection config = this.adapter.getConfig();
        String def = lang.getDefaultValue();
        Comment comments = lang.getComment();
        AdvancedMessage data = lang.getAdvancedData();
        if (data != null) {
            ConfigSection section = config.createSection(lang.getLanguageEntry().getPath());
            keyNode = section.getNode();
            if (def != null) {
                section.set("message", (Object)def);
            }
            if (!data.sound().isEmpty()) {
                section.set("sound", (Object)data.sound());
            }
            if (!data.actionbar().isEmpty()) {
                section.set("actionbar", (Object)data.actionbar());
            }
            if (!data.title().isEmpty() || !data.subtitle().isEmpty()) {
                if (!data.title().isEmpty()) {
                    section.set(new String[]{"titles", "title"}, (Object)data.title());
                }
                if (!data.subtitle().isEmpty()) {
                    section.set(new String[]{"titles", "subtitle"}, (Object)data.subtitle());
                }
            }
        } else {
            Pair<ConfigSection, NodePair> section = config.createSection(lang.getLanguageEntry().getPath(), (Object)def);
            keyNode = comments != null && comments.forParent() ? section.getKey().getKey() : section.getValue().getKey();
        }
        if (comments != null) {
            keyNode.setSimpleComments(comments.value());
        }
    }

    private MessageObject parseMessage(String msg, Node node, String[] path) {
        MessageCompiler compiler = new MessageCompiler(msg);
        MessageObject obj = compiler.compileObject();
        if (compiler.hasErrors()) {
            Mark mark = node.getWholeMark();
            KLogger.warn("An error occurred while parsing message for '" + String.join((CharSequence)".", path) + "' in " + this.adapter.getFile() + " at line " + mark.getLine() + ":\n" + mark.createSnippet(0, Integer.MAX_VALUE, "", null).trim() + '\n' + compiler.joinExceptions());
        }
        return obj;
    }

    private void loadEnglishDefaults() {
        for (DefinedMessenger[] vals : MESSENGERS.values()) {
            for (DefinedMessenger lang : vals) {
                this.putDefault(lang);
                this.saveDefault(lang);
            }
        }
    }

    public static String getRawMessage(DefinedMessenger lang, SupportedLanguage locale) {
        ConfigSection config = locale.getAdapter().getConfig();
        Node foundSection = config.findNode(lang.getLanguageEntry().getPath());
        if (foundSection == null) {
            return null;
        }
        if (foundSection.getNodeType() == NodeType.MAPPING) {
            ConfigSection section = new ConfigSection(null, (MappingNode)foundSection);
            return section.getString("message");
        }
        return NodeInterpreter.STRING.parse(foundSection);
    }

    static {
        LanguageManager.registerMessenger(KingdomsLang.class, (DefinedMessenger[])KingdomsLang.VALUES);
    }

    private final class EntryLoader {
        final ConfigSection config;
        final Set<DefinedMessenger> remainingEntries;
        final Map<LanguageEntry, DefinedMessenger> definedEntries;

        private EntryLoader() {
            this.config = LanguageManager.this.adapter.getConfig();
            this.remainingEntries = Collections.newSetFromMap(new IdentityHashMap(KingdomsLang.VALUES.length + 300));
            this.definedEntries = new HashMap<LanguageEntry, DefinedMessenger>(KingdomsLang.VALUES.length + 300);
            Iterator iterator = MESSENGERS.values().iterator();
            while (iterator.hasNext()) {
                DefinedMessenger[] vals;
                for (DefinedMessenger lang : vals = (DefinedMessenger[])iterator.next()) {
                    this.definedEntries.put(lang.getLanguageEntry(), lang);
                    this.remainingEntries.add(lang);
                }
            }
            ConfigSection variablesSection = this.config.getSection("variables");
            if (variablesSection != null) {
                this.loadEntries(new String[]{"variables"}, variablesSection);
            }
            this.loadEntries(null, this.config);
            if (!this.remainingEntries.isEmpty()) {
                for (DefinedMessenger remainingEntry : this.remainingEntries) {
                    String[] path = remainingEntry.getLanguageEntry().getPath();
                    Node foundSection = this.config.findNode(path);
                    if (foundSection != null) continue;
                    LanguageManager.this.saveDefault(remainingEntry);
                    LanguageManager.this.putDefault(remainingEntry);
                }
                KLogger.debug((DebugNS)KingdomsDebug.LANGUAGE_MISSING$ENTRIES, () -> "Added missing enteries to " + LanguageManager.this.lang.name() + ": " + this.remainingEntries.stream().map(x -> String.join((CharSequence)" -> ", x.getLanguageEntry().getPath())).collect(Collectors.joining(" | ")));
                LanguageManager.this.adapter.saveConfig();
            }
        }

        private void loadEntries(String[] currentEntryRoot, ConfigSection root) {
            Objects.requireNonNull(root, "Root cannot be null");
            for (String key : root.getKeys()) {
                MessageProvider provider;
                if (root == this.config && key.equals("variables")) continue;
                String[] currentEntry = currentEntryRoot;
                currentEntry = currentEntry == null ? new String[]{key} : ArrayUtils.merge(currentEntry, new String[]{key});
                LanguageEntry entry = new LanguageEntry(currentEntry);
                DefinedMessenger defined = this.definedEntries.get(entry);
                Node node = root.getNode(key);
                if (defined == null) {
                    if (node.getNodeType() == NodeType.MAPPING) {
                        MappingNode mapping = (MappingNode)node;
                        this.loadEntries(currentEntry, new ConfigSection(mapping));
                        continue;
                    }
                } else {
                    this.remainingEntries.remove(defined);
                }
                if (node.getNodeType() == NodeType.MAPPING) {
                    ConfigSection section = new ConfigSection(null, (MappingNode)node);
                    provider = new AdvancedMessageProvider(section);
                } else {
                    String msg = NodeInterpreter.STRING.parse(node);
                    if (msg != null) {
                        MessageObject obj = LanguageManager.this.parseMessage(msg, node, currentEntry);
                        provider = new MessageProvider(obj);
                    } else {
                        provider = NullMessageProvider.getInstance();
                    }
                }
                LanguageManager.this.lang.getMessages().put(entry, provider);
            }
        }
    }
}

