/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.libs.snakeyaml.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.kingdoms.libs.snakeyaml.validation.NodeValidator;
import org.kingdoms.libs.snakeyaml.validation.ValidationContext;
import org.kingdoms.libs.snakeyaml.validation.ValidationFailure;

public class UnionValidator
implements NodeValidator {
    private final NodeValidator[] union;

    public UnionValidator(NodeValidator[] union) {
        this.union = union;
    }

    @Override
    public ValidationFailure validate(ValidationContext context) {
        ArrayList<ValidationFailure> allFails = new ArrayList<ValidationFailure>();
        for (NodeValidator validator : this.union) {
            ValidationContext innerContext = new ValidationContext(context.getRelatedKey(), context.getNode(), context.getValidatorMap(), new ArrayList<ValidationFailure>());
            ValidationFailure innerResult = validator.validate(innerContext);
            if (innerResult == null || innerResult.getSeverity() == ValidationFailure.Severity.WARNING) {
                StringBuilder error = new StringBuilder();
                boolean hasErrored = false;
                for (ValidationFailure exception : innerContext.getExceptions()) {
                    if (exception.getSeverity() != ValidationFailure.Severity.ERROR) continue;
                    hasErrored = true;
                    error.append("    * ");
                    error.append(exception.getMessage());
                    error.append('\n');
                    error.append(exception.getMarker().createSnippet());
                    error.append("\n------------\n");
                }
                if (hasErrored) {
                    allFails.add(new ValidationFailure(ValidationFailure.Severity.ERROR, context.getNode(), context.getNode().getStartMark(), error.toString()));
                    continue;
                }
                context.getExceptions().addAll(innerContext.getExceptions());
                return null;
            }
            allFails.addAll(innerContext.getExceptions());
        }
        return context.fail(new ValidationFailure(ValidationFailure.Severity.ERROR, context.getNode(), null, "None of the types matched: \n  - " + allFails.stream().map(ValidationFailure::getMessage).collect(Collectors.joining("\n  - "))));
    }

    @Override
    public String getName() {
        return "one of " + Arrays.toString(this.union);
    }

    public String toString() {
        return "UnionValidator{" + Arrays.toString(this.union) + '}';
    }
}

