/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.libs.snakeyaml.tokens;

import java.util.Objects;
import org.kingdoms.libs.snakeyaml.comments.CommentType;
import org.kingdoms.libs.snakeyaml.markers.Mark;
import org.kingdoms.libs.snakeyaml.tokens.Token;

public final class CommentToken
extends Token {
    private final CommentType type;
    private final String value;
    private final int spacesBefore;

    public CommentToken(CommentType type, String value, int spacesBefore, Mark startMark, Mark endMark) {
        super(startMark, endMark);
        this.type = Objects.requireNonNull(type);
        this.value = Objects.requireNonNull(value);
        this.spacesBefore = spacesBefore;
    }

    public CommentType getCommentType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public int getSpacesBefore() {
        return this.spacesBefore;
    }

    @Override
    public Token.ID getTokenId() {
        return Token.ID.Comment;
    }

    @Override
    public String toString() {
        return this.getTokenId().toString() + '(' + (Object)((Object)this.type) + " - '" + this.value + "')";
    }
}

