/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.libs.snakeyaml.nodes;

import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.snakeyaml.common.Anchor;
import org.kingdoms.libs.snakeyaml.common.reference.AnciasNodeReference;
import org.kingdoms.libs.snakeyaml.common.reference.NodeReference;
import org.kingdoms.libs.snakeyaml.markers.Mark;
import org.kingdoms.libs.snakeyaml.nodes.Node;
import org.kingdoms.libs.snakeyaml.nodes.NodeType;
import org.kingdoms.libs.snakeyaml.nodes.SequenceNode;
import org.kingdoms.libs.snakeyaml.nodes.Tag;

public class AliasNode
extends Node {
    private final SequenceNode parameters;
    private Object cached;

    public AliasNode(Anchor anchor, SequenceNode parameters, Mark startMark, Mark endMark) {
        super(Tag.ALIAS, startMark, endMark);
        this.setReference(new AnciasNodeReference(AnciasNodeReference.Type.ALIAS, new Anchor(anchor.getIdentifier(), null)));
        this.parameters = parameters;
    }

    @Override
    public void setReference(NodeReference reference) {
        if (!(reference instanceof AnciasNodeReference)) {
            throw new IllegalArgumentException("Cannot set reference for alias node: " + reference + " for " + this);
        }
        super.setReference(reference);
    }

    @Override
    public @NonNull AnciasNodeReference getReference() {
        return (AnciasNodeReference)super.getReference();
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ALIAS;
    }

    @Override
    public void cacheConstructed(Object obj) {
        this.cached = obj;
    }

    @Override
    public Object getParsed() {
        return this.cached;
    }

    public SequenceNode getParameters() {
        return this.parameters;
    }

    @Override
    public AliasNode clone() {
        AliasNode scalarNode = new AliasNode(this.getReference().getReference(), this.parameters, this.getStartMark(), this.getEndMark());
        scalarNode.copyPropertiesOf(this);
        return scalarNode;
    }

    public String toString() {
        return '<' + this.getClass().getName() + " (tag=" + this.getTag() + ", anchor=" + this.getReference() + ", parameters=" + this.parameters + ")>";
    }
}

