/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.libs.snakeyaml.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.kingdoms.libs.snakeyaml.common.Anchor;
import org.kingdoms.libs.snakeyaml.common.reference.AnciasNodeReference;
import org.kingdoms.libs.snakeyaml.common.reference.NodeReference;
import org.kingdoms.libs.snakeyaml.nodes.MappingNode;
import org.kingdoms.libs.snakeyaml.nodes.Node;
import org.kingdoms.libs.snakeyaml.nodes.NodePair;
import org.kingdoms.libs.snakeyaml.nodes.ScalarNode;
import org.kingdoms.libs.snakeyaml.nodes.SequenceNode;

public final class NodeReplacer {
    private final Node node;
    private Node newNode;
    private final Map<String, Node> variables;
    private final Map<String, Anchor> anchors;
    private Predicate<ReplacementDetails> ignorePredicate;
    private boolean changed = false;
    private boolean replaced = false;
    private boolean allowRootReplacement;
    private final String path;
    private final boolean isRoot;

    private NodeReplacer(Node node, Map<String, Node> variables, Map<String, Anchor> anchors, String path, boolean isRoot) {
        this.node = Objects.requireNonNull(node);
        this.variables = variables;
        this.anchors = anchors;
        this.isRoot = isRoot;
        this.path = path;
    }

    public NodeReplacer(Node node, Map<String, Node> variables, Map<String, Anchor> anchors) {
        this(node, variables, anchors, null, true);
    }

    public NodeReplacer replaceAll() {
        boolean emptyAnchors;
        boolean emptyVars = this.variables == null || this.variables.isEmpty();
        boolean bl = emptyAnchors = this.anchors == null || this.anchors.isEmpty();
        if (emptyVars && emptyAnchors) {
            this.replaced = true;
            return this;
        }
        this.checkReplaced(false);
        this.replaceAll0();
        if (!this.allowRootReplacement && this.isRoot && this.newNode != null) {
            throw new IllegalStateException("The root node cannot be replaced as a whole: " + this.node + " -> " + this.newNode);
        }
        this.replaced = true;
        return this;
    }

    private void checkReplaced(boolean shouldlBeReplaced) {
        if (shouldlBeReplaced) {
            if (!this.replaced) {
                throw new IllegalStateException("replaceAll() was not called yet: " + this.path);
            }
        } else if (this.replaced) {
            throw new IllegalStateException("This node replacer was already replaced: " + this.path);
        }
    }

    private String newPath(String newPath) {
        if (this.path == null) {
            return newPath;
        }
        return this.path + '.' + newPath;
    }

    public boolean isChanged() {
        this.checkReplaced(true);
        return this.changed;
    }

    public Node getNewNode() {
        return this.newNode;
    }

    public NodeReplacer ignore(Predicate<ReplacementDetails> ignorePredicate) {
        this.checkReplaced(false);
        this.ignorePredicate = ignorePredicate;
        return this;
    }

    public NodeReplacer allowRootReplacement(boolean allowRootReplacement) {
        this.allowRootReplacement = allowRootReplacement;
        return this;
    }

    public Node getFinalNode() {
        this.checkReplaced(true);
        return this.newNode == null ? this.node : this.newNode;
    }

    private boolean isIgnored(ReplacementDetails replacementDetails) {
        return this.ignorePredicate != null && this.ignorePredicate.test(replacementDetails);
    }

    private Node replaceInner(String fullPath, Node target) {
        NodeReplacer replacement = new NodeReplacer(target, this.variables, this.anchors, fullPath, false).ignore(this.ignorePredicate).replaceAll();
        if (!this.changed) {
            this.changed = replacement.changed;
        }
        return replacement.getFinalNode();
    }

    private void replaceAll0() {
        String id;
        Iterator<Map.Entry<String, Anchor>> inheritedAnchor;
        AnciasNodeReference anciasRef;
        NodeReference ref;
        if (this.anchors != null && !this.anchors.isEmpty() && (ref = this.node.getReference()) instanceof AnciasNodeReference && (anciasRef = (AnciasNodeReference)ref).getType() == AnciasNodeReference.Type.ALIAS && (inheritedAnchor = this.anchors.get(id = anciasRef.getReference().getIdentifier())) != null) {
            this.changed = true;
            this.newNode = ((Anchor)((Object)inheritedAnchor)).getReference().clone();
            this.newNode = this.replaceInner(this.path, this.newNode);
            return;
        }
        switch (this.node.getNodeType()) {
            case SCALAR: {
                String str;
                ScalarNode scalarNode = (ScalarNode)this.node;
                String replaced = str = scalarNode.getValue();
                if (str != null && str.length() >= 3) {
                    if (this.variables != null && !this.variables.isEmpty()) {
                        for (Map.Entry<String, Anchor> entry : this.variables.entrySet()) {
                            replaced = this.processScalarReplace(entry.getKey(), (Node)((Object)entry.getValue()), replaced, scalarNode);
                            if (replaced != null) continue;
                            return;
                        }
                    }
                    if (this.anchors != null && !this.anchors.isEmpty()) {
                        for (Map.Entry<String, Anchor> entry : this.anchors.entrySet()) {
                            replaced = this.processScalarReplace("[*" + entry.getKey() + ']', entry.getValue().getReference(), replaced, scalarNode);
                            if (replaced != null) continue;
                            return;
                        }
                    }
                    if (this.changed) {
                        scalarNode.setValue(replaced);
                    }
                }
                return;
            }
            case SEQUENCE: {
                SequenceNode seq = (SequenceNode)this.node;
                ArrayList<Node> arrayList = new ArrayList<Node>(seq.getValue().size());
                Iterator iterator = seq.getValue().iterator();
                while (iterator.hasNext()) {
                    Node element;
                    Node newElement = element = (Node)iterator.next();
                    if (!this.isIgnored(new ReplacementDetails(this.path, element, false, seq))) {
                        String elementVal;
                        Node value;
                        if (this.variables != null && !this.variables.isEmpty() && element instanceof ScalarNode && (value = this.variables.get(elementVal = ((ScalarNode)element).getValue())) instanceof SequenceNode) {
                            SequenceNode mergingValues = (SequenceNode)value;
                            arrayList.addAll(mergingValues.getValue().stream().map(Node::clone).collect(Collectors.toList()));
                            this.changed = true;
                            continue;
                        }
                        newElement = this.replaceInner(this.path, element);
                    }
                    arrayList.add(newElement);
                }
                if (this.changed) {
                    seq.setValue(arrayList);
                }
                return;
            }
            case MAPPING: {
                MappingNode map = (MappingNode)this.node;
                LinkedHashMap<String, NodePair> newPairs = new LinkedHashMap<String, NodePair>(map.getPairs().size());
                for (NodePair pair : map.getValue()) {
                    String newPath = this.newPath(pair.getKey().getValue());
                    ScalarNode completeKey = pair.getKey();
                    if (!this.isIgnored(new ReplacementDetails(newPath, pair.getKey(), true, null))) {
                        Node placedKey = this.replaceInner(this.path, pair.getKey());
                        if (!(placedKey instanceof ScalarNode)) {
                            throw new RuntimeException("Mapping key must be a scalar node at path '" + newPath + "' for " + pair.getKey() + " -> " + placedKey);
                        }
                        completeKey = (ScalarNode)placedKey;
                    }
                    Node competeValue = pair.getValue();
                    if (!this.isIgnored(new ReplacementDetails(newPath, pair.getValue(), false, null))) {
                        competeValue = this.replaceInner(newPath, pair.getValue());
                    }
                    newPairs.put(completeKey.getValue(), new NodePair(completeKey, competeValue));
                }
                if (this.changed) {
                    map.setPairs(newPairs);
                }
                return;
            }
        }
        throw new IllegalArgumentException("Unknown node type to replace: " + this.node);
    }

    private String processScalarReplace(String searchFor, Node replace, String original, ScalarNode targetNode) {
        StringBuilder result = null;
        String evaluatedRep = null;
        int originLength = original.length();
        int index = 0;
        while (index < originLength) {
            int foundIndex = original.indexOf(searchFor, index);
            if (foundIndex == -1) {
                if (result == null) {
                    return original;
                }
                result.append(original, index, originLength);
                break;
            }
            int indexAfterReplace = foundIndex + searchFor.length();
            if (foundIndex == 0 && indexAfterReplace + 1 >= originLength) {
                this.changed = true;
                this.newNode = replace.clone();
                targetNode.setValue(NodeReplacer.getReplacementString(searchFor, replace));
                return null;
            }
            if (result == null) {
                evaluatedRep = NodeReplacer.getReplacementString(searchFor, replace);
                result = new StringBuilder(originLength + evaluatedRep.length());
            }
            result.append(original, index, foundIndex);
            result.append(evaluatedRep);
            index = indexAfterReplace;
        }
        this.changed = true;
        return result.toString();
    }

    private static String getReplacementString(String searchFor, Node replace) {
        String strValue = replace instanceof ScalarNode ? ((ScalarNode)replace).getValue() : "REPLACED[" + searchFor + "=>" + replace.toString() + ']';
        return strValue;
    }

    public static final class ReplacementDetails {
        public final String path;
        public final Node node;
        public final boolean isMapKey;
        public final SequenceNode sequence;

        public ReplacementDetails(String path, Node node, boolean isMapKey, SequenceNode sequence) {
            this.path = path;
            this.node = node;
            this.isMapKey = isMapKey;
            this.sequence = sequence;
        }
    }
}

