/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.libs.snakeyaml.comments;

import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import org.kingdoms.libs.snakeyaml.comments.CommentLine;
import org.kingdoms.libs.snakeyaml.comments.CommentType;
import org.kingdoms.libs.snakeyaml.events.CommentEvent;
import org.kingdoms.libs.snakeyaml.events.Event;
import org.kingdoms.libs.snakeyaml.parser.Parser;

public class CommentEventsCollector {
    private List<CommentLine> comments = new ArrayList<CommentLine>();
    private final Queue<Event> eventSource;
    private final CommentType[] expectedCommentTypes;

    public CommentEventsCollector(final Parser parser, CommentType ... expectedCommentTypes) {
        this.eventSource = new AbstractQueue<Event>(){

            @Override
            public boolean offer(Event e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Event poll() {
                return parser.next();
            }

            @Override
            public Event peek() {
                return parser.peekEvent();
            }

            @Override
            public Iterator<Event> iterator() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                throw new UnsupportedOperationException();
            }
        };
        this.expectedCommentTypes = expectedCommentTypes;
    }

    public CommentEventsCollector(Queue<Event> eventSource, CommentType ... expectedCommentTypes) {
        this.eventSource = eventSource;
        this.expectedCommentTypes = expectedCommentTypes;
    }

    private boolean isEventExpected(Event event) {
        if (event == null || event.getEventId() != Event.ID.Comment) {
            return false;
        }
        CommentEvent commentEvent = (CommentEvent)event;
        for (CommentType type : this.expectedCommentTypes) {
            if (commentEvent.getCommentType() != type) continue;
            return true;
        }
        return false;
    }

    public CommentEventsCollector collectEvents() {
        this.collectEvents(null);
        return this;
    }

    public Event collectEvents(Event event) {
        if (event != null) {
            if (this.isEventExpected(event)) {
                this.comments.add(new CommentLine((CommentEvent)event));
            } else {
                return event;
            }
        }
        while (this.isEventExpected(this.eventSource.peek())) {
            CommentLine line = new CommentLine((CommentEvent)this.eventSource.poll());
            this.comments.add(line);
        }
        return null;
    }

    public Event collectEventsAndPoll(Event event) {
        Event nextEvent = this.collectEvents(event);
        return nextEvent != null ? nextEvent : this.eventSource.poll();
    }

    public List<CommentLine> consume() {
        try {
            List<CommentLine> list = this.comments;
            return list;
        }
        finally {
            this.comments = new ArrayList<CommentLine>();
        }
    }

    public boolean isEmpty() {
        return this.comments.isEmpty();
    }
}

