/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.gui.pagination;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.utils.MathUtils;

public class GUIPagination<T> {
    private final ReusableOptionHandler option;
    private final Collection<T> paginatedElements;

    public GUIPagination(ReusableOptionHandler option, Collection<T> paginatedElements) {
        this.option = option;
        this.paginatedElements = paginatedElements;
    }

    public ReusableOptionHandler getOption() {
        return this.option;
    }

    public Collection<T> getPaginatedElements() {
        return this.paginatedElements;
    }

    public static void paginate(InteractiveGUI gui, int page, int maxPages, Consumer<Integer> openPage) {
        gui.getMessageContext().raw("pages", maxPages);
        gui.getMessageContext().raw("page", page + 1);
        gui.getMessageContext().raw("previous-page", page);
        gui.getMessageContext().raw("next-page", page + 2);
        gui.option("previous-page").onNormalClicks(ctx -> {
            if (page == 0) {
                ctx.sendError(KingdomsLang.GUIS_PAGES_PREVIOUS_PAGE_NOT_AVAILABLE, new Object[0]);
                return;
            }
            openPage.accept(page - 1);
        }).done();
        gui.option("next-page").onNormalClicks(ctx -> {
            if (page + 1 >= maxPages) {
                ctx.sendError(KingdomsLang.GUIS_PAGES_NEXT_PAGE_NOT_AVAILABLE, new Object[0]);
                return;
            }
            openPage.accept(page + 1);
        }).done();
    }

    public static <T> GUIPagination<T> paginate(InteractiveGUI gui, Collection<T> collection, String option, int page, Consumer<Integer> openPage) {
        ReusableOptionHandler holder = Objects.requireNonNull(gui.getReusableOption(option), () -> "Missing '" + option + "' option from '" + gui.getName() + "' GUI");
        int eachPage = holder.slotsCount();
        int maxPages = MathUtils.getPageNumbers(collection.size(), eachPage);
        GUIPagination.paginate(gui, page, maxPages, openPage);
        return new GUIPagination<T>(holder, collection.stream().skip((long)page * (long)eachPage).limit(eachPage).collect(Collectors.toList()));
    }
}

