/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.gui.pagination;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.OptionHandler;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.ranges.RangesKt;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.internal.functional.Fn;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0006\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003:\u0001\u0018B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001c\u0010\u0012\u001a\u0018\u0012\u0014\u0012\u00120\u000fR\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00000\u0013JE\u0010\u0012\u001a\u0014\u0018\u00010\u000fR\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000\"\u0004\b\u0002\u0010\u00012\u0006\u0010\u0014\u001a\u00020\u000e2\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u0002H\u0001\u0018\u00010\u00132\b\u0010\u0016\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010\u0017J6\u0010\u0012\u001a\u0014\u0018\u00010\u000fR\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000\"\u0004\b\u0002\u0010\u00012\u0006\u0010\u0014\u001a\u00020\u000e2\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u0002H\u0001\u0018\u00010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0014\u0012\u00120\u000fR\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/kingdoms/gui/pagination/GUIMultiPagination;", "T", "S", "", "gui", "Lorg/kingdoms/gui/InteractiveGUI;", "page", "", "openPage", "Ljava/util/function/Consumer;", "<init>", "(Lorg/kingdoms/gui/InteractiveGUI;ILjava/util/function/Consumer;)V", "mappedOptions", "", "", "Lorg/kingdoms/gui/pagination/GUIMultiPagination$MappedOption;", "paginated", "", "paginate", "", "option", "collection", "special", "(Ljava/lang/String;Ljava/util/Collection;Ljava/lang/Object;)Lorg/kingdoms/gui/pagination/GUIMultiPagination$MappedOption;", "MappedOption", "core"})
@SourceDebugExtension(value={"SMAP\nGUIMultiPagination.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GUIMultiPagination.kt\norg/kingdoms/gui/pagination/GUIMultiPagination\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
public final class GUIMultiPagination<T, S> {
    @NotNull
    private final InteractiveGUI gui;
    private final int page;
    @NotNull
    private final Consumer<Integer> openPage;
    @NotNull
    private final Map<String, MappedOption> mappedOptions;
    private boolean paginated;

    public GUIMultiPagination(@NotNull InteractiveGUI gui, int page, @NotNull Consumer<Integer> openPage) {
        Intrinsics.checkNotNullParameter((Object)gui, (String)"gui");
        Intrinsics.checkNotNullParameter(openPage, (String)"openPage");
        this.gui = gui;
        this.page = page;
        this.openPage = openPage;
        this.mappedOptions = new HashMap();
    }

    @NotNull
    public final Collection<MappedOption> paginate() {
        MappedOption option;
        if (!(!this.paginated)) {
            boolean $i$a$-check-GUIMultiPagination$paginate$22 = false;
            String $i$a$-check-GUIMultiPagination$paginate$22 = "Already paginated";
            throw new IllegalStateException($i$a$-check-GUIMultiPagination$paginate$22.toString());
        }
        int maxSlotCount = 0;
        int maxItems = 0;
        this.paginated = true;
        Iterator<Map.Entry<String, MappedOption>> iterator = this.mappedOptions.entrySet().iterator();
        while (iterator.hasNext()) {
            option = iterator.next().getValue();
            maxSlotCount = RangesKt.coerceAtLeast((int)maxSlotCount, (int)option.getOption().slotsCount());
            maxItems = RangesKt.coerceAtLeast((int)maxItems, (int)option.getCollection().size());
        }
        iterator = this.mappedOptions.entrySet().iterator();
        while (iterator.hasNext()) {
            option = iterator.next().getValue();
            int slots = option.getOption().slotsCount();
            option.setCollection(CollectionsKt.take((Iterable)CollectionsKt.drop((Iterable)option.getCollection(), (int)(this.page * slots)), (int)slots));
        }
        int maxPages = maxItems == 0 || maxSlotCount == 0 ? 1 : MathUtils.getPageNumbers(maxItems, maxSlotCount);
        this.gui.getMessageContext().raw("pages", maxPages);
        this.gui.getMessageContext().raw("page", this.page + 1);
        this.gui.option("previous-page").onNormalClicks(arg_0 -> GUIMultiPagination.paginate$lambda$1(this, arg_0)).done();
        this.gui.option("next-page").onNormalClicks(arg_0 -> GUIMultiPagination.paginate$lambda$2(this, maxPages, arg_0)).done();
        return this.mappedOptions.values();
    }

    @Nullable
    public final <T> MappedOption paginate(@NotNull String option, @Nullable Collection<? extends T> collection, @Nullable S special) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        ReusableOptionHandler reusableOptionHandler = this.gui.getReusableOption(option);
        if (reusableOptionHandler == null) {
            return null;
        }
        ReusableOptionHandler holder = reusableOptionHandler;
        Collection<T> collection2 = collection;
        if (collection2 == null || collection2.isEmpty()) {
            return null;
        }
        Object t = Fn.cast(collection);
        Intrinsics.checkNotNullExpressionValue(t, (String)"cast(...)");
        MappedOption mapped = new MappedOption(holder, (Collection)t, special);
        this.mappedOptions.put(option, mapped);
        return mapped;
    }

    @Nullable
    public final <T> MappedOption paginate(@NotNull String option, @Nullable Collection<? extends T> collection) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return this.paginate(option, collection, null);
    }

    private static final void paginate$lambda$1(GUIMultiPagination this$0, OptionHandler ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (this$0.page == 0) {
            ctx.sendError(KingdomsLang.GUIS_PAGES_PREVIOUS_PAGE_NOT_AVAILABLE, new Object[0]);
            return;
        }
        this$0.openPage.accept(this$0.page - 1);
    }

    private static final void paginate$lambda$2(GUIMultiPagination this$0, int $maxPages, OptionHandler ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (this$0.page + 1 >= $maxPages) {
            ctx.sendError(KingdomsLang.GUIS_PAGES_NEXT_PAGE_NOT_AVAILABLE, new Object[0]);
            return;
        }
        this$0.openPage.accept(this$0.page + 1);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0014\u001a\u00020\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR \u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u0006\u001a\u0004\u0018\u00018\u0001X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lorg/kingdoms/gui/pagination/GUIMultiPagination$MappedOption;", "", "option", "Lorg/kingdoms/gui/ReusableOptionHandler;", "collection", "", "special", "<init>", "(Lorg/kingdoms/gui/pagination/GUIMultiPagination;Lorg/kingdoms/gui/ReusableOptionHandler;Ljava/util/Collection;Ljava/lang/Object;)V", "getOption", "()Lorg/kingdoms/gui/ReusableOptionHandler;", "getCollection", "()Ljava/util/Collection;", "setCollection", "(Ljava/util/Collection;)V", "getSpecial", "()Ljava/lang/Object;", "setSpecial", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "done", "", "core"})
    public final class MappedOption {
        @NotNull
        private final ReusableOptionHandler option;
        @NotNull
        private Collection<? extends T> collection;
        @Nullable
        private S special;

        public MappedOption(@NotNull ReusableOptionHandler option, @Nullable Collection<? extends T> collection, S special) {
            Intrinsics.checkNotNullParameter((Object)option, (String)"option");
            Intrinsics.checkNotNullParameter(collection, (String)"collection");
            this.option = option;
            this.collection = collection;
            this.special = special;
        }

        @NotNull
        public final ReusableOptionHandler getOption() {
            return this.option;
        }

        @NotNull
        public final Collection<T> getCollection() {
            return this.collection;
        }

        public final void setCollection(@NotNull Collection<? extends T> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"<set-?>");
            this.collection = collection;
        }

        @Nullable
        public final S getSpecial() {
            return this.special;
        }

        public final void setSpecial(@Nullable S s) {
            this.special = s;
        }

        public final void done() {
            this.option.done();
        }
    }
}

