/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.bukkit.event.inventory.InventoryType;
import org.kingdoms.gui.GUIConfig;
import org.kingdoms.gui.bedrock.FormBuilderObject;
import org.kingdoms.gui.objects.GUIObject;
import org.kingdoms.gui.objects.GUIOptionBuilder;
import org.kingdoms.gui.objects.GUIOptionObject;
import org.kingdoms.gui.objects.GUIOptionParser;
import org.kingdoms.gui.objects.inventory.CustomSlotGUI;
import org.kingdoms.gui.objects.inventory.GUIInventoryConstructor;
import org.kingdoms.gui.objects.inventory.PredefinedTypeGUI;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.locale.Language;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.server.platform.Platform;
import org.kingdoms.utils.conditions.ConditionChain;
import org.kingdoms.utils.conditions.ConditionProcessor;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.config.adapters.YamlWithDefaults;
import org.kingdoms.utils.internal.stacktrace.StackTraces;
import org.kingdoms.utils.string.ConfigPrinter;

public final class GUIParser {
    protected static final int ALLOW_INTERACT_WITH_EMPTY = 999;

    public static GUIObject parse(YamlWithDefaults yaml, String name, Language lang) {
        if (yaml.getConfig() == null) {
            return null;
        }
        String path = Kingdoms.getFolder().toAbsolutePath().relativize(yaml.getFile().toPath().toAbsolutePath()).toString();
        try {
            return GUIParser.parse0(yaml, name, lang);
        }
        catch (IllegalArgumentException ex) {
            MessageHandler.sendConsolePluginMessage("&4Error while parsing GUI &e" + path + "&8: &e" + ex.getMessage());
            return new GUIObject(name, yaml, ex.getMessage());
        }
    }

    static GUIObject parse0(YamlWithDefaults yaml, String name, Language lang) {
        ConfigSection openCondsSection;
        FormBuilderObject form;
        XSound.Record parsedSound;
        GUIInventoryConstructor inventoryConstructor;
        int inventorySize;
        ConfigSection config = Objects.requireNonNull(yaml.getConfig());
        String rawTitle = config.getString("title");
        MessageObject title = rawTitle == null ? null : MessageCompiler.compile(rawTitle, MessageCompiler.defaultSettingsWithErroHandler(compiler -> KLogger.warn("Errors while parsing 'title' option of GUI '" + name + "':" + compiler.joinExceptions() + '\n' + config.getNode("title").getStartMark() + "\n----------------------------------")));
        boolean disallowCreative = config.getBoolean("disallow-creative");
        boolean isTypeSet = config.isSet("type");
        boolean isRowsSet = config.isSet("rows");
        if (isTypeSet && isRowsSet) {
            throw new IllegalArgumentException("&4You cannot specify both &erows &4and &etype &4option for GUIs. Only use one of them.");
        }
        if (!isTypeSet && !isRowsSet) {
            throw new IllegalArgumentException("&4You need to specify either &erows &4or &etype &4option for GUIs.");
        }
        String type = config.getString("type");
        if (type == null) {
            inventorySize = config.getInt("rows") * 9;
            if (inventorySize < 1) {
                throw new IllegalArgumentException("&4Invalid rows &e" + inventorySize + " &4must be between &e1-6");
            }
            inventoryConstructor = new CustomSlotGUI(inventorySize);
        } else {
            try {
                type = type.toUpperCase(Locale.ENGLISH);
                InventoryType invType = InventoryType.valueOf((String)type);
                inventorySize = invType.getDefaultSize();
                inventoryConstructor = new PredefinedTypeGUI(invType);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("&4Could not find inventory type '&e" + type);
            }
        }
        String sound = config.getString("sound");
        if (sound == null) {
            parsedSound = null;
        } else {
            try {
                parsedSound = XSound.parse((String)sound);
            }
            catch (Exception ex) {
                parsedSound = null;
            }
        }
        List<String> openCommands = config.getStringList("commands");
        List<Integer> interactable = config.getIntegerList("interactable");
        if (!interactable.isEmpty()) {
            int first = interactable.get(0);
            if (first < 0) {
                interactable.set(0, -interactable.get(0).intValue());
                ArrayList<Integer> exludeInteractable = new ArrayList<Integer>();
                for (int i = 0; i < inventorySize; ++i) {
                    if (interactable.contains(i)) continue;
                    exludeInteractable.add(i);
                }
                interactable = exludeInteractable;
            }
        } else if ("empty".equalsIgnoreCase(config.getString("interactable"))) {
            interactable = Collections.singletonList(999);
        }
        String guiMessage = config.getString("message");
        MessageObject msg = guiMessage == null ? null : MessageCompiler.compile(guiMessage);
        ConfigSection optionsSection = config.getSection("options");
        if (optionsSection == null) {
            throw new IllegalArgumentException("No options are specified for GUI.");
        }
        Map<String, ConfigSection> keys = optionsSection.getSections();
        HashMap<String, GUIOptionBuilder> options = new HashMap<String, GUIOptionBuilder>(keys.size());
        HashMap<Integer, String> nonConditionalOccupiedSlots = new HashMap<Integer, String>(keys.size() * 2);
        for (Map.Entry<String, ConfigSection> optionSection : keys.entrySet()) {
            String optionName = optionSection.getKey();
            try {
                GUIOptionBuilder parsed = new GUIOptionParser(optionName, config, optionSection.getValue(), yaml.getFile() == null ? name : GUIConfig.getFolder().relativize(yaml.getFile().toPath()).toString(), inventoryConstructor, nonConditionalOccupiedSlots, new ArrayList<GUIOptionObject>()).build();
                if (parsed == null) continue;
                options.put(optionName, parsed);
            }
            catch (Throwable ex) {
                MessageHandler.sendConsolePluginMessage("&4Could not parse item for option: &e" + optionName + " &4in GUI &e" + name + " (" + ex.getMessage() + ") &4with properties&8:");
                ConfigPrinter.printConfig(optionSection.getValue());
                ex.printStackTrace();
            }
        }
        if (Platform.BEDROCK.isAvailable() && config.isSet("forms")) {
            try {
                form = FormBuilderObject.parse(config);
            }
            catch (Throwable ex) {
                MessageHandler.sendConsolePluginMessage("&4Could not parse forms for GUI &e" + name + " (" + ex.getMessage() + ") &4with properties&8:");
                ConfigPrinter.printConfig(config);
                StackTraces.printStackTrace(ex);
                form = null;
            }
        } else {
            form = null;
        }
        ConditionChain<Messenger> openConds = (openCondsSection = config.getSection("open-conditions")) != null ? ConditionProcessor.mapConditions(openCondsSection, false) : null;
        return new GUIObject(name, yaml, title, form, inventoryConstructor, options, interactable, openCommands, parsedSound, openConds, disallowCreative, msg);
    }
}

