/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.gui;

import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.GUIPathContainer;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.provider.MessageContextProvider;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0004\u0010\u0007J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\u0010\u001a\u00020\u0000J\u0006\u0010\u0016\u001a\u00020\u0000J\u0014\u0010\u001b\u001a\u00020\u00002\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001dJ\u0017\u0010!\u001a\u0004\u0018\u0001H\"\"\b\b\u0000\u0010\"*\u00020#\u00a2\u0006\u0002\u0010$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u0014\u0010\u001e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006%"}, d2={"Lorg/kingdoms/gui/GUIBuilder;", "Lorg/kingdoms/locale/provider/MessageContextProvider;", "name", "", "<init>", "(Ljava/lang/String;)V", "Lorg/kingdoms/gui/GUIPathContainer;", "(Lorg/kingdoms/gui/GUIPathContainer;)V", "player", "Lorg/bukkit/entity/Player;", "getPlayer", "()Lorg/bukkit/entity/Player;", "setPlayer", "(Lorg/bukkit/entity/Player;)V", "messageSettings", "Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "optional", "", "getOptional", "()Z", "setOptional", "(Z)V", "inventoryGUIOnly", "getInventoryGUIOnly", "setInventoryGUIOnly", "withSettings", "forPlayer", "editMessageContext", "editor", "Ljava/util/function/Consumer;", "messageContext", "getMessageContext", "()Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "build", "T", "Lorg/kingdoms/gui/InteractiveGUI;", "()Lorg/kingdoms/gui/InteractiveGUI;", "core"})
public final class GUIBuilder
implements MessageContextProvider {
    @NotNull
    private final String name;
    public Player player;
    @Nullable
    private MessagePlaceholderProvider messageSettings;
    private boolean optional;
    private boolean inventoryGUIOnly;

    public GUIBuilder(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
    }

    @NotNull
    public final Player getPlayer() {
        Player player = this.player;
        if (player != null) {
            return player;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"player");
        return null;
    }

    public final void setPlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"<set-?>");
        this.player = player;
    }

    public final boolean getOptional() {
        return this.optional;
    }

    public final void setOptional(boolean bl) {
        this.optional = bl;
    }

    public final boolean getInventoryGUIOnly() {
        return this.inventoryGUIOnly;
    }

    public final void setInventoryGUIOnly(boolean bl) {
        this.inventoryGUIOnly = bl;
    }

    public GUIBuilder(@NotNull GUIPathContainer name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = name.getGUIPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGUIPath(...)");
        this(string);
    }

    @NotNull
    public final GUIBuilder withSettings(@NotNull MessagePlaceholderProvider messageSettings) {
        Intrinsics.checkNotNullParameter((Object)messageSettings, (String)"messageSettings");
        this.messageSettings = messageSettings;
        return this;
    }

    @NotNull
    public final GUIBuilder forPlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.setPlayer(player);
        return this;
    }

    @NotNull
    public final GUIBuilder optional() {
        this.optional = true;
        return this;
    }

    @NotNull
    public final GUIBuilder inventoryGUIOnly() {
        this.inventoryGUIOnly = true;
        return this;
    }

    @NotNull
    public final GUIBuilder editMessageContext(@NotNull Consumer<MessagePlaceholderProvider> editor) {
        Intrinsics.checkNotNullParameter(editor, (String)"editor");
        editor.accept(this.getMessageContext());
        return this;
    }

    @Override
    @NotNull
    public MessagePlaceholderProvider getMessageContext() {
        MessagePlaceholderProvider messagePlaceholderProvider;
        if (this.messageSettings == null) {
            MessagePlaceholderProvider messagePlaceholderProvider2 = this.messageSettings = new MessagePlaceholderProvider();
            messagePlaceholderProvider = messagePlaceholderProvider2;
            Intrinsics.checkNotNull((Object)messagePlaceholderProvider2);
        } else {
            MessagePlaceholderProvider messagePlaceholderProvider3 = this.messageSettings;
            messagePlaceholderProvider = messagePlaceholderProvider3;
            Intrinsics.checkNotNull((Object)messagePlaceholderProvider3);
        }
        MessagePlaceholderProvider settings = messagePlaceholderProvider;
        if (settings.getPrimaryTarget() == null) {
            settings.setPrimaryTarget(this.getPlayer());
        }
        return settings;
    }

    @Nullable
    public final <T extends InteractiveGUI> T build() {
        return (T)GUIAccessor.prepare(this.getPlayer(), this.name, this.optional, this.getMessageContext(), this.inventoryGUIOnly);
    }
}

