/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.gui;

import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.admin.CommandAdminOpenFile;
import org.kingdoms.commands.admin.CommandAdminTrack;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.gui.FormInteractiveGUI;
import org.kingdoms.gui.GUIConfig;
import org.kingdoms.gui.GUIParser;
import org.kingdoms.gui.GUIPathContainer;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.InventoryInteractiveGUI;
import org.kingdoms.gui.objects.GUIObject;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.Language;
import org.kingdoms.locale.LanguageManager;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.KLogger;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;
import org.kingdoms.platform.geyser.core.FloodgateHandler;
import org.kingdoms.server.platform.Platform;
import org.kingdoms.utils.config.adapters.YamlResource;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;

public final class GUIAccessor {
    private static final GUIObject NOTIFIER_INVENTORY;

    public static InteractiveGUI prepare(Player player, String name) {
        return GUIAccessor.prepare(player, name, new MessagePlaceholderProvider().withContext(player));
    }

    public static InteractiveGUI prepare(Player player, GUIPathContainer name) {
        return GUIAccessor.prepare(player, name.getGUIPath());
    }

    public static InteractiveGUI prepare(Player player, GUIPathContainer name, MessagePlaceholderProvider settings) {
        return GUIAccessor.prepare(player, name.getGUIPath(), settings);
    }

    public static InteractiveGUI prepare(Player player, OfflinePlayer placeholder, String name, Object ... edits) {
        return GUIAccessor.prepare(player, name, new MessagePlaceholderProvider().raws(edits).withContext(placeholder));
    }

    public static InteractiveGUI prepare(Player player, String name, MessagePlaceholderProvider edits) {
        return GUIAccessor.prepare(player, name, false, edits);
    }

    public static @Nullable InteractiveGUI prepare(Player player, String name, boolean optional, MessagePlaceholderProvider edits) {
        return GUIAccessor.prepare(player, name, optional, edits, false);
    }

    public static @Nullable InteractiveGUI prepare(Player player, String name, boolean optional, MessagePlaceholderProvider edits, boolean inventoryGUIOnly) {
        Language locale = LanguageManager.localeOf(player);
        GUIObject config = GUIConfig.getGUI(name, locale, optional);
        if (config == null) {
            return null;
        }
        if (!(config.hasFormBuilder() && Platform.BEDROCK.isAvailable() && FloodgateHandler.isFloodgatePlayer(player.getUniqueId()))) {
            GUIObject finalConfig = config;
            KLogger.debug((DebugNS)KingdomsDebug.BEDROCK$FLOODGATE, () -> "Inventory GUI Only: hasFormBuilder=" + finalConfig.hasFormBuilder() + ", Bedrock=" + Platform.BEDROCK.isAvailable() + ", isFloodgatePlayer=" + (Platform.BEDROCK.isAvailable() ? Boolean.valueOf(FloodgateHandler.isFloodgatePlayer(player.getUniqueId())) : "no"));
            inventoryGUIOnly = true;
        }
        if (CommandAdminTrack.isTracking((CommandSender)player)) {
            String sanitizedPath = CommandAdminOpenFile.sanitize(config.getConfig().getFile().toPath());
            String guiPath = config.getConfig().getFile().getPath();
            KingdomsLang.COMMAND_ADMIN_TRACK_GUI.sendMessage((CommandSender)player, "path", guiPath.replace("/", "{$sep}/{$s}"), "file", sanitizedPath, "sanitized_path", sanitizedPath);
        }
        KLogger.debug((DebugNS)KingdomsDebug.GUIS_PREPARE, () -> "Preparing GUI '" + name + "' for player " + player.getName() + " and edits " + edits);
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (edits.getPrimaryTarget() == null) {
            edits.withContext(player);
        }
        edits.lang(kp.getLanguage());
        if (config.isBroken()) {
            MessageObject messageObjectBuilder = config.getMessage();
            edits.raw("gui_path", config.getConfig().getFile().toString()).raw("error", messageObjectBuilder.buildPlain(new MessagePlaceholderProvider()));
            config = NOTIFIER_INVENTORY;
            InteractiveGUI gui = inventoryGUIOnly ? new InventoryInteractiveGUI(config, player, config.getConfig().getConfig(), edits) : new FormInteractiveGUI(config, player, config.getConfig().getConfig(), edits);
            gui.open();
            return gui;
        }
        if (!kp.isAdmin()) {
            Messenger openError;
            if (config.isCreativeDisallowed() && player.getGameMode() == GameMode.CREATIVE && !KingdomsDefaultPluginPermission.GUIS_BYPASS_CREATIVE.hasPermission((CommandSender)player, false)) {
                KingdomsLang.GUIS_CREATIVE.sendError((CommandSender)player, new Object[0]);
                return null;
            }
            if (config.getOpenConditions() != null && (openError = config.getOpenConditions().evaluate(edits, true)) != null) {
                openError.sendError((CommandSender)player, edits);
                return null;
            }
        }
        if (inventoryGUIOnly) {
            return new InventoryInteractiveGUI(config, player, config.getConfig().getConfig(), edits);
        }
        return new FormInteractiveGUI(config, player, config.getConfig().getConfig(), edits);
    }

    static {
        YamlResource config = new YamlResource(null, "guis/error.yml").load();
        NOTIFIER_INVENTORY = GUIParser.parse0(config, "<INTERNAL:ERROR>", Language.getDefault());
    }
}

