/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.events.members;

import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.kingdoms.abstraction.KingdomOperator;
import org.kingdoms.abstraction.PlayerOperator;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.KingdomsEvent;
import org.kingdoms.events.members.LeaveReason;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;

public class KingdomLeaveEvent
extends KingdomsEvent
implements Cancellable,
PlayerOperator,
KingdomOperator {
    private static final HandlerList handlers = new HandlerList();
    private final KingdomPlayer player;
    private final LeaveReason reason;
    private boolean cancelled;

    public KingdomLeaveEvent(KingdomPlayer player, LeaveReason reason) {
        this.player = player;
        this.reason = reason;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    @Override
    public void addMessageContextEdits(@NotNull MessagePlaceholderProvider context) {
        super.addMessageContextEdits(context);
        context.withContext(this.player.getOfflinePlayer());
        context.raw("reason", this.reason.name());
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public LeaveReason getReason() {
        return this.reason;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @Override
    public @NonNull KingdomPlayer getPlayer() {
        return this.player;
    }

    @Override
    public @NonNull Kingdom getKingdom() {
        return this.player.getKingdom();
    }
}

