/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.events.members;

import java.util.Objects;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.kingdoms.abstraction.KingdomOperator;
import org.kingdoms.abstraction.PlayerOperator;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.KingdomsEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;

public class KingdomJoinEvent
extends KingdomsEvent
implements Cancellable,
PlayerOperator,
KingdomOperator {
    private static final HandlerList handlers = new HandlerList();
    private final Kingdom kingdom;
    private final KingdomPlayer player;
    private boolean cancelled;

    public KingdomJoinEvent(Kingdom kingdom, KingdomPlayer player) {
        this.kingdom = Objects.requireNonNull(kingdom);
        this.player = Objects.requireNonNull(player);
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    @Override
    public void addMessageContextEdits(@NotNull MessagePlaceholderProvider context) {
        super.addMessageContextEdits(context);
        context.withContext(this.player.getOfflinePlayer()).other(this.kingdom);
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @Override
    public Kingdom getKingdom() {
        return this.kingdom;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @Override
    public @NonNull KingdomPlayer getPlayer() {
        return this.player;
    }
}

