/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.events.lands;

import java.util.Set;
import org.bukkit.event.HandlerList;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.lands.ClaimingEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;

public class UnclaimLandEvent
extends ClaimingEvent {
    private static final HandlerList handlers = new HandlerList();
    private final @NonNull Reason reason;

    public UnclaimLandEvent(@Nullable KingdomPlayer player, @NonNull Kingdom kingdom, @NonNull Set<SimpleChunkLocation> lands, @NonNull Reason reason) {
        super(player, kingdom, lands, false);
        this.reason = reason;
    }

    @Override
    public void addMessageContextEdits(@NotNull MessagePlaceholderProvider context) {
        super.addMessageContextEdits(context);
        context.raw("reason", this.reason.name());
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public @NonNull Reason getReason() {
        return this.reason;
    }

    public static enum Reason {
        UNCLAIMED,
        AUTO_UNCLAIMED,
        CLIPBOARD,
        CONNECTION_ISSUES,
        INVASION,
        ADMIN,
        OVERCLAIM,
        CUSTOM;

    }
}

