/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.events.items.turrets;

import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.kingdoms.abstraction.KingdomBuildingOperator;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.KingdomsEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;

public class TurretActivateEvent
extends KingdomsEvent
implements KingdomBuildingOperator,
Cancellable {
    private static final @NonNull HandlerList handlers = new HandlerList();
    private final @NonNull LivingEntity target;
    private final @NonNull Turret turret;
    private final @NonNull Kingdom kingdom;
    private final @NonNull Land land;
    private final @NonNull Location origin;
    private final @Nullable KingdomPlayer kingdomPlayer;
    private boolean cancelled;
    private final long time = System.currentTimeMillis();
    private final Object extra;

    public TurretActivateEvent(@NonNull LivingEntity target, @NonNull Turret turret, @NonNull Kingdom kingdom, @NonNull Land land, @NonNull Location origin, @Nullable KingdomPlayer kingdomPlayer, @Nullable Object extra) {
        this.target = Objects.requireNonNull(target, "Turret target cannot be null");
        this.turret = Objects.requireNonNull(turret, "Turret cannot be null");
        this.kingdom = Objects.requireNonNull(kingdom, "Turret kingdom cannot be null");
        this.land = Objects.requireNonNull(land, "Turret land cannot be null");
        this.origin = Objects.requireNonNull(origin, "Turret location cannot be null");
        this.kingdomPlayer = kingdomPlayer;
        this.extra = extra;
    }

    public static @NonNull HandlerList getHandlerList() {
        return handlers;
    }

    public long getTime() {
        return this.time;
    }

    public Object getExtra() {
        return this.extra;
    }

    public @NonNull HandlerList getHandlers() {
        return handlers;
    }

    public @NonNull Turret getTurret() {
        return this.turret;
    }

    public @NonNull LivingEntity getTarget() {
        return this.target;
    }

    public @Nullable KingdomPlayer getKingdomPlayer() {
        return this.kingdomPlayer;
    }

    public @NonNull Location getOrigin() {
        return this.origin;
    }

    public @NonNull Land getLand() {
        return this.land;
    }

    public @NonNull Kingdom getKingdom() {
        return this.kingdom;
    }

    @Override
    @org.kingdoms.libs.jetbrains.annotations.Nullable
    public KingdomBuilding<?> getBuilding() {
        return this.turret;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }
}

