/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.events.general.ranks;

import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.events.general.ranks.RankIdentifier;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/kingdoms/events/general/ranks/DirectRankIdentifier;", "Lorg/kingdoms/events/general/ranks/RankIdentifier;", "rank", "Lorg/kingdoms/constants/player/Rank;", "<init>", "(Lorg/kingdoms/constants/player/Rank;)V", "getRank", "()Lorg/kingdoms/constants/player/Rank;", "identify", "group", "Lorg/kingdoms/constants/group/Group;", "player", "Lorg/kingdoms/constants/player/KingdomPlayer;", "core"})
public final class DirectRankIdentifier
implements RankIdentifier {
    @NotNull
    private final Rank rank;

    public DirectRankIdentifier(@NotNull Rank rank) {
        Intrinsics.checkNotNullParameter((Object)rank, (String)"rank");
        this.rank = rank;
    }

    @NotNull
    public final Rank getRank() {
        return this.rank;
    }

    @Override
    @NotNull
    public Rank identify(@NotNull Group group, @NotNull KingdomPlayer player) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Rank actualRank = group.getRanks().get(this.rank.getNode());
        if (actualRank == null) {
            throw new IllegalArgumentException("Unknown rank in group " + group.getId() + " -> " + this.rank);
        }
        if (!Intrinsics.areEqual((Object)actualRank, (Object)this.rank)) {
            throw new IllegalArgumentException("Ranks are probably the same, but different instances: " + this.rank + " | " + actualRank);
        }
        return actualRank;
    }
}

