/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.events.general;

import org.bukkit.event.HandlerList;
import org.kingdoms.abstraction.KingdomOperator;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.events.KingdomsEvent;
import org.kingdoms.events.general.GroupDisband;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;

public class KingdomDisbandEvent
extends KingdomsEvent
implements GroupDisband,
KingdomOperator {
    private static final HandlerList handlers = new HandlerList();
    private boolean cancelled;
    private final GroupDisband.Reason reason;
    private final Kingdom kingdom;

    public KingdomDisbandEvent(Kingdom kingdom, GroupDisband.Reason reason) {
        this.kingdom = kingdom;
        this.reason = reason;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    @Override
    public void addMessageContextEdits(@NotNull MessagePlaceholderProvider context) {
        super.addMessageContextEdits(context);
        context.withContext(this.kingdom).raw("reason", this.reason.name());
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @Override
    public @NonNull Kingdom getKingdom() {
        return this.kingdom;
    }

    @Override
    public GroupDisband.Reason getReason() {
        return this.reason;
    }
}

