/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.events.general;

import java.util.Collection;
import java.util.Collections;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.abstraction.GroupOperator;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.KingdomsEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Unmodifiable;

public class GroupResourcePointConvertEvent
extends KingdomsEvent
implements Cancellable,
GroupOperator {
    private static final HandlerList handlers = new HandlerList();
    private final @Nullable KingdomPlayer kingdomPlayer;
    private final @Nullable Collection<ItemStack> originalItems;
    private final Group group;
    private @Nullable Collection<ItemStack> convertedItems;
    private @Nullable Collection<ItemStack> leftOvers;
    private double amount;
    private boolean cancelled;

    public GroupResourcePointConvertEvent(@NonNull Group group, double amount, @Nullable KingdomPlayer kingdomPlayer, @Nullable Collection<ItemStack> originalItems, @Nullable Collection<ItemStack> convertedItems, @Nullable Collection<ItemStack> leftOvers) {
        this.group = group;
        this.amount = amount;
        this.kingdomPlayer = kingdomPlayer;
        this.originalItems = originalItems;
        this.convertedItems = convertedItems;
        this.leftOvers = leftOvers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public @Nullable KingdomPlayer getKingdomPlayer() {
        return this.kingdomPlayer;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    public @Nullable @Unmodifiable Collection<ItemStack> getOriginalItems() {
        return Collections.unmodifiableCollection(this.originalItems);
    }

    public @Nullable Collection<ItemStack> getLeftOvers() {
        return Collections.unmodifiableCollection(this.leftOvers);
    }

    public @Nullable Collection<ItemStack> getConvertedItems() {
        return Collections.unmodifiableCollection(this.convertedItems);
    }

    @Override
    public Group getGroup() {
        return this.group;
    }
}

