/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.managers.base;

import java.util.Collection;
import java.util.Collections;
import org.kingdoms.constants.base.CompressedSmartObject;
import org.kingdoms.constants.base.KingdomsObject;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.data.centers.KingdomsDataCenter;
import org.kingdoms.data.database.base.SingularKingdomsDatabase;
import org.kingdoms.data.managers.base.DataManager;
import org.kingdoms.main.KLogger;

public abstract class SingularDataManager<T extends KingdomsObject>
extends DataManager<T> {
    private T cached;
    private final SingularKingdomsDatabase<T> database;

    public SingularDataManager(Namespace namespace, SingularKingdomsDatabase<T> database, KingdomsDataCenter dataCenter) {
        super(namespace, dataCenter);
        this.database = database;
    }

    @Override
    public SingularKingdomsDatabase<T> getDatabase() {
        return this.database;
    }

    @Override
    public void deleteAllData() {
        if (this.cached != null) {
            ((CompressedSmartObject)this.cached).invalidateObject();
        }
        this.database.deleteAllData();
    }

    @Override
    public void copyAllDataTo(DataManager<T> dataManager) {
        if (!(dataManager instanceof SingularDataManager)) {
            throw new UnsupportedOperationException("Cannot copy from " + this + " to " + dataManager);
        }
        ((SingularDataManager)dataManager).cached = this.cached;
    }

    public T getOrLoadData() {
        if (this.cached != null) {
            return this.cached;
        }
        this.cached = this.database.load();
        this.cached = this.onLoad(this.cached);
        return this.cached;
    }

    public void setCached(T cached) {
        if (this.cached == cached) {
            return;
        }
        this.clearCache();
        this.cached = cached;
        this.saveObjectState(cached, true);
    }

    @Override
    public void clearCache() {
        if (this.cached == null) {
            return;
        }
        ((CompressedSmartObject)this.cached).invalidateObject();
        this.cached = null;
    }

    @Override
    public int saveAll(boolean smart) {
        if (this.cached == null) {
            return 0;
        }
        if (smart) {
            if (!this.savingState) {
                KLogger.info("Saving state was turned off for " + this + ", skipping saving data...");
                return 0;
            }
            if (this.isSmartSaving() && !((CompressedSmartObject)this.cached).shouldSave()) {
                return 0;
            }
            this.database.save(this.cached);
        } else {
            this.database.save(this.cached);
        }
        return 1;
    }

    @Override
    public int loadedCount() {
        return 1;
    }

    @Override
    public Collection<T> loadAllData(boolean checkIfLoaded) {
        return this.peekAllData();
    }

    @Override
    public Collection<T> getLoadedData() {
        if (this.cached == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.cached);
    }

    @Override
    public Collection<T> peekAllData() {
        return Collections.singletonList(this.getOrLoadData());
    }
}

