/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.managers.base;

import java.util.Collection;
import org.kingdoms.constants.base.CompressedSmartObject;
import org.kingdoms.constants.base.KingdomsObject;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.data.database.base.KingdomsDatabase;
import org.kingdoms.data.managers.BaseDataManager;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.jetbrains.annotations.ApiStatus;
import org.kingdoms.libs.jetbrains.annotations.MustBeInvokedByOverriders;

public abstract class DataManager<T extends KingdomsObject>
extends BaseDataManager {
    private final Namespace namespace;
    protected boolean savingState = true;

    public DataManager(Namespace namespace, BaseDataManager inherit) {
        super(namespace, inherit.getAutoSaveInterval(), inherit.isCacheStatic(), inherit.isTemporary(), inherit.isSmartSaving());
        this.namespace = namespace;
    }

    protected void saveObjectState(T data, boolean forceSave) {
        if (forceSave || data != null && this.isSmartSaving() && !((CompressedSmartObject)data).isObjectStateSaved()) {
            ((CompressedSmartObject)data).saveObjectState(forceSave);
        }
    }

    @ApiStatus.Internal
    public abstract KingdomsDatabase<T> getDatabase();

    public abstract void deleteAllData();

    @ApiStatus.Internal
    public final void setSavingState(boolean savingState) {
        this.savingState = savingState;
    }

    @ApiStatus.Internal
    public abstract void copyAllDataTo(DataManager<T> var1);

    @ApiStatus.Internal
    public abstract void clearCache();

    @ApiStatus.Internal
    public final int autoSave() {
        return this.saveAll(this.isSmartSaving());
    }

    public abstract int saveAll(boolean var1);

    @MustBeInvokedByOverriders
    protected T onLoad(T value) {
        return value;
    }

    @Override
    public void onDisable() {
    }

    @MustBeInvokedByOverriders
    protected void unload(@NonNull T data) {
        ((CompressedSmartObject)data).invalidateObject();
    }

    public abstract int loadedCount();

    public abstract Collection<T> loadAllData(boolean var1);

    public abstract Collection<T> getLoadedData();

    public abstract Collection<T> peekAllData();

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.namespace.asNormalizedString() + " | " + this.loadedCount() + ')';
    }

    @Override
    @ApiStatus.Internal
    public void close() {
        super.close();
        this.getDatabase().close();
    }
}

