/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.managers;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.top.common.GroupTopData;
import org.kingdoms.data.centers.KingdomsDataCenter;
import org.kingdoms.data.centers.KingdomsStartup;
import org.kingdoms.data.database.base.KeyedKingdomsDatabase;
import org.kingdoms.data.managers.base.KeyedDataManager;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.jetbrains.annotations.Unmodifiable;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.scheduler.DelayedRepeatingTask;
import org.kingdoms.utils.internal.string.QuantumString;

public abstract class GroupManager<V extends Group>
extends KeyedDataManager<UUID, V> {
    protected final Map<QuantumString, UUID> names = new HashMap<QuantumString, UUID>();
    protected DelayedRepeatingTask topUpdateTask;
    protected boolean instantTopUpdate;

    public GroupManager(Namespace namespace, KeyedKingdomsDatabase<UUID, V> database, boolean cacheExistence, KingdomsDataCenter dataCenter) {
        super(namespace, database, cacheExistence, dataCenter);
    }

    public abstract void configureTopData();

    protected void createUpdateTask(KingdomsConfig updateIntervalConfig) {
        Duration updateInterval;
        boolean instantTopUpdate = true;
        if (!this.isTemporary() && (updateInterval = updateIntervalConfig.getTime()) != null && !updateInterval.isZero()) {
            instantTopUpdate = false;
            KingdomsStartup.whenReady(_x -> {
                this.updateTop();
                this.topUpdateTask = Kingdoms.taskScheduler().async().repeating(updateInterval, updateInterval, this::updateTop);
            });
        }
        this.instantTopUpdate = instantTopUpdate;
    }

    public void updateTop() {
        Collection allData = this.getLoadedData();
        if (allData.isEmpty()) {
            return;
        }
        MessageHandler.sendConsolePluginMessage("&2Updating top group data for &9" + this.getNamespace().asNormalizedString() + " &2with &9" + allData.size() + " &2data.");
        for (GroupTopData groupTopData : this.getTopData().values()) {
            groupTopData.update(allData);
        }
    }

    @Nullable
    public abstract GroupTopData<V> getTopData(String var1);

    public abstract Map<String, ? extends GroupTopData<V>> getTopData();

    public boolean isInstantTopUpdate() {
        return this.instantTopUpdate;
    }

    public @Unmodifiable @NotNull Map<QuantumString, UUID> getNames() {
        return Collections.unmodifiableMap(this.names);
    }

    protected abstract QuantumString toQuantumName(String var1);

    public V getData(String name) {
        UUID id = this.names.get(this.toQuantumName(name));
        return (V)(id == null ? null : (Group)this.getOrLoadData(id));
    }

    @Override
    public void unload(@NonNull V data) {
        super.unload(data);
        this.remove(data);
    }

    public void rename(V group, String rename) {
        this.remove(group);
        this.names.put(this.toQuantumName(rename), ((Group)group).getId());
    }

    private void remove(V group) {
        this.names.remove(this.toQuantumName(((Group)group).getName()));
    }

    @Override
    protected V onLoad(V value) {
        value = (Group)super.onLoad(value);
        if (!this.isTemporary()) {
            this.names.put(this.toQuantumName(((Group)value).getName()), ((Group)value).getId());
        }
        return (V)value;
    }

    @Override
    public void onDisable() {
        super.onDisable();
        if (this.topUpdateTask != null) {
            this.topUpdateTask.cancel();
        }
    }
}

