/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.history;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.kingdoms.data.centers.KingdomsDataCenter;
import org.kingdoms.data.database.base.KingdomsDatabase;
import org.kingdoms.data.database.sql.base.SQLDatabase;
import org.kingdoms.data.database.sql.statements.SQLColumn;
import org.kingdoms.data.database.sql.statements.SQLColumnAdd;
import org.kingdoms.data.database.sql.statements.SQLColumnChange;
import org.kingdoms.data.database.sql.statements.SQLColumnModify;
import org.kingdoms.data.database.sql.statements.SQLColumnRemove;
import org.kingdoms.data.database.sql.statements.SQLStatement;
import org.kingdoms.data.history.DataStructureChanges;
import org.kingdoms.data.history.DataVersion;
import org.kingdoms.data.history.SQLAssociatedStatement;
import org.kingdoms.data.managers.KingdomPlayerManager;
import org.kingdoms.data.managers.base.DataManager;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Unit;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.functions.Function0;
import org.kingdoms.libs.kotlin.jvm.functions.Function1;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.TempKingdomsFolder;
import org.kingdoms.managers.backup.FolderZipper;
import org.kingdoms.managers.backup.KingdomsBackup;
import org.kingdoms.utils.fs.FSUtil;
import org.kingdoms.utils.internal.enumeration.QuickEnumMap;
import org.kingdoms.utils.time.TimeFormatter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\t0\f\u00a2\u0006\u0002\b\u000eH\u0003J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\tH\u0007R\u001c\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/kingdoms/data/history/DataStructureHistory;", "", "<init>", "()V", "HISTORY", "", "Lorg/kingdoms/data/history/DataVersion;", "Lorg/kingdoms/data/history/DataStructureChanges;", "register", "", "version", "handler", "Lorg/kingdoms/libs/kotlin/Function1;", "Lorg/kingdoms/data/history/DataStructureHistory$VersionHistory;", "Lorg/kingdoms/libs/kotlin/ExtensionFunctionType;", "msg", "", "convertDatabase", "VersionHistory", "core"})
@SourceDebugExtension(value={"SMAP\nDataStructureHistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataStructureHistory.kt\norg/kingdoms/data/history/DataStructureHistory\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,169:1\n11158#2:170\n11493#2,3:171\n11158#2:174\n11493#2,3:175\n*S KotlinDebug\n*F\n+ 1 DataStructureHistory.kt\norg/kingdoms/data/history/DataStructureHistory\n*L\n94#1:170\n94#1:171,3\n75#1:174\n75#1:175,3\n*E\n"})
public final class DataStructureHistory {
    @NotNull
    public static final DataStructureHistory INSTANCE;
    @JvmField
    @NotNull
    public static final Map<DataVersion, DataStructureChanges> HISTORY;

    private DataStructureHistory() {
    }

    @JvmStatic
    private static final void register(DataVersion version, Function1<? super VersionHistory, Unit> handler) {
        VersionHistory history = new VersionHistory();
        handler.invoke((Object)history);
        HISTORY.put(version, new DataStructureChanges(version, history.getChanges()));
    }

    private final void msg(String msg) {
        MessageHandler.sendConsolePluginMessage(msg);
    }

    @JvmStatic
    public static final void convertDatabase() {
        DataVersion version = DataVersion.getCurrentVersion();
        if (version == DataVersion.LATEST) {
            return;
        }
        KingdomsDataCenter dataCenter = Kingdoms.get().getDataCenter();
        INSTANCE.msg("&8----- &2Data Conversion &8-----");
        INSTANCE.msg("&2You're using an old data format &9" + (Object)((Object)version) + "&2, updating to &2" + (Object)((Object)DataVersion.LATEST));
        INSTANCE.msg("&2Taking a backup first...");
        Path from = TempKingdomsFolder.getOrCreateFolder("backup");
        Path zipTo = FSUtil.findSlotForCounterFile(KingdomsBackup.BACKUPS_FOLDER, "data-conversion-" + (Object)((Object)DataVersion.getCurrentVersion()), "zip");
        KingdomsBackup.backupData(from);
        INSTANCE.msg("&2Zipping backup files from &6" + from + " &8-> &6" + zipTo);
        Intrinsics.checkNotNull((Object)from);
        Intrinsics.checkNotNull((Object)zipTo);
        FolderZipper.Companion.zip$default(FolderZipper.Companion, null, from, zipTo, false, 8, null);
        Intrinsics.checkNotNull((Object)((Object)version));
        DataVersion conversionVersion = version;
        do {
            INSTANCE.msg("  &8| &2Beginning the conversion of &7" + (Object)((Object)conversionVersion) + "...");
            Intrinsics.checkNotNull((Object)HISTORY.get((Object)conversionVersion));
            for (DataManager<?> dataManager : dataCenter.getAllDataManagers()) {
                boolean hasHighData;
                DataStructureChanges changes;
                Intrinsics.checkNotNull(dataManager);
                List<SQLAssociatedStatement> managerChanges = changes.findChangesFor(dataManager);
                if (managerChanges.isEmpty()) {
                    INSTANCE.msg("    &8+ &9No changes found for &7" + dataManager + " &9data, skipping...");
                    continue;
                }
                int totalCount = dataManager.getDatabase().count();
                INSTANCE.msg("    &8+ &9Loading &7" + dataManager + " &9data... &8(&2" + totalCount + "&8)");
                String dataETA = TimeFormatter.ofRaw((long)totalCount * 50L);
                boolean bl = hasHighData = totalCount > 5000;
                if (hasHighData) {
                    INSTANCE.msg("      &8- &6High data count, ETA&8: &2" + dataETA);
                }
                dataManager.loadAllData(true);
                INSTANCE.msg("      &8- &6Loaded &7" + dataManager.loadedCount() + " &6data. Converting...");
                KingdomsDatabase<?> kingdomsDatabase = dataManager.getDatabase();
                if ((kingdomsDatabase instanceof SQLDatabase ? (SQLDatabase)kingdomsDatabase : null) != null) {
                    SQLDatabase database;
                    database = database;
                    boolean bl2 = false;
                    for (SQLAssociatedStatement change : managerChanges) {
                        database.executeStatement(change.getStatement());
                    }
                }
                INSTANCE.msg("      &8- &6Conversion complete. Saving all data..." + (hasHighData ? " &8(&6ETA&8: &2" + dataETA + "&8)" : ""));
                dataManager.saveAll(false);
                INSTANCE.msg("      &8- &6Saved.");
            }
        } while (!(conversionVersion = conversionVersion.next()).isLatest());
        DataVersion.setCurrentVersion(DataVersion.LATEST, false);
        INSTANCE.msg("&2Data migration done. New data format&8: &9" + (Object)((Object)DataVersion.getCurrentVersion()));
        INSTANCE.msg("&8----- &2Data Conversion &8-----");
    }

    private static final Object lambda$8$lambda$7$lambda$0() {
        return new SQLColumnAdd(new SQLColumn("statistics", "JSON", true), null, 2, null);
    }

    private static final Object lambda$8$lambda$7$lambda$1() {
        return new SQLColumnAdd(new SQLColumn("flags", "JSON", true), null, 2, null);
    }

    private static final Object lambda$8$lambda$7$lambda$3() {
        new SQLColumnModify(new SQLColumn("totalDonations", "DOUBLE", false));
        return new SQLColumnModify(new SQLColumn("lastDonationAmount", "DOUBLE", false));
    }

    /*
     * WARNING - void declaration
     */
    private static final Object lambda$8$lambda$7$lambda$5() {
        Collection<SQLColumnRemove> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object[] objectArray = new Object[6];
        objectArray[0] = new SQLColumnModify(new SQLColumn("resourcePoints", "DOUBLE", false));
        objectArray[1] = new SQLColumnAdd(new SQLColumn("level", "INT", false), 0);
        objectArray[2] = new SQLColumnAdd(new SQLColumn("taxes", "JSON", true), null, 2, null);
        objectArray[3] = new SQLColumnAdd(new SQLColumn("colors", "JSON", true), null, 2, null);
        objectArray[4] = new SQLColumnAdd(new SQLColumn("banner", "JSON", true), null, 2, null);
        String[] stringArray = new String[]{"requiresInvite", "publicHome", "permanent", "hidden", "publicHomeCost", "tax", "color"};
        int n = 5;
        Object[] objectArray2 = objectArray;
        boolean $i$f$map = false;
        void var3_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n2 = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n2; ++i) {
            void columnName;
            void item$iv$iv;
            void var9_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SQLColumnRemove((String)columnName));
        }
        collection = (List)destination$iv$iv;
        objectArray2[n] = collection;
        return objectArray;
    }

    private static final Object lambda$8$lambda$7$lambda$6() {
        SQLColumnChange[] sQLColumnChangeArray = new SQLColumnChange[]{new SQLColumnRemove("pacifist"), new SQLColumnModify(new SQLColumn("king", "UUID", true))};
        return sQLColumnChangeArray;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit lambda$8$lambda$7(KingdomsDataCenter $this_apply, VersionHistory $this$register) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
        Object[] objectArray = new DataManager[]{$this_apply.getKingdomManager(), $this_apply.getNationManager(), $this_apply.getKingdomPlayerManager(), $this_apply.getLandManager(), $this_apply.getMTG()};
        $this$register.forManagers((DataManager<?>[])objectArray, (Function0<? extends Object>)((Function0)DataStructureHistory::lambda$8$lambda$7$lambda$0));
        objectArray = new DataManager[]{$this_apply.getKingdomManager(), $this_apply.getNationManager(), $this_apply.getKingdomPlayerManager()};
        $this$register.forManagers((DataManager<?>[])objectArray, (Function0<? extends Object>)((Function0)DataStructureHistory::lambda$8$lambda$7$lambda$1));
        objectArray = new String[]{"pvp", "spy", "admin", "sneakMode", "markers"};
        Object[] $this$map$iv = objectArray;
        boolean $i$f$map = false;
        Object[] objectArray2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void columnName;
            void item$iv$iv;
            void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            SQLColumnRemove sQLColumnRemove = new SQLColumnRemove((String)columnName);
            KingdomPlayerManager kingdomPlayerManager = $this_apply.getKingdomPlayerManager();
            Intrinsics.checkNotNullExpressionValue((Object)kingdomPlayerManager, (String)"getKingdomPlayerManager(...)");
            collection.add(sQLColumnRemove.associateTo(kingdomPlayerManager));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        objectArray = new DataManager[]{$this_apply.getKingdomPlayerManager()};
        $this$register.forManagers((DataManager<?>[])objectArray, (Function0<? extends Object>)((Function0)DataStructureHistory::lambda$8$lambda$7$lambda$3));
        objectArray = new DataManager[]{$this_apply.getKingdomManager(), $this_apply.getNationManager()};
        $this$register.forManagers((DataManager<?>[])objectArray, (Function0<? extends Object>)((Function0)DataStructureHistory::lambda$8$lambda$7$lambda$5));
        objectArray = new DataManager[]{$this_apply.getKingdomManager()};
        $this$register.forManagers((DataManager<?>[])objectArray, (Function0<? extends Object>)((Function0)DataStructureHistory::lambda$8$lambda$7$lambda$6));
        return Unit.INSTANCE;
    }

    static {
        KingdomsDataCenter kingdomsDataCenter;
        INSTANCE = new DataStructureHistory();
        HISTORY = new QuickEnumMap((Enum[])DataVersion.values());
        KingdomsDataCenter $this$_init__u24lambda_u248 = kingdomsDataCenter = Kingdoms.get().getDataCenter();
        boolean bl = false;
        DataStructureHistory.register(DataVersion.VERSION_0, (Function1<? super VersionHistory, Unit>)((Function1)arg_0 -> DataStructureHistory.lambda$8$lambda$7($this$_init__u24lambda_u248, arg_0)));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\b\u001a\u00020\t\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\u00012\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\n0\u0005H\u0002J-\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\n0\u000e\"\u0004\b\u0000\u0010\n2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0006\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\u0010J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u000eJ5\u0010\u0012\u001a\u00020\t2\u001a\u0010\u0013\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00140\u0006\"\u0006\u0012\u0002\b\u00030\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u0016\u00a2\u0006\u0002\u0010\u0017R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/kingdoms/data/history/DataStructureHistory$VersionHistory;", "", "<init>", "()V", "changes", "", "", "Lorg/kingdoms/data/history/SQLAssociatedStatement;", "unwrapNestedArray", "", "T", "obj", "merged", "mergeChanges", "", "elements", "([Ljava/lang/Object;)Ljava/util/List;", "getChanges", "forManagers", "managers", "Lorg/kingdoms/data/managers/base/DataManager;", "handler", "Lorg/kingdoms/libs/kotlin/Function0;", "([Lorg/kingdoms/data/managers/base/DataManager;Lkotlin/jvm/functions/Function0;)V", "core"})
    @SourceDebugExtension(value={"SMAP\nDataStructureHistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataStructureHistory.kt\norg/kingdoms/data/history/DataStructureHistory$VersionHistory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,169:1\n1863#2,2:170\n1557#2:177\n1628#2,3:178\n13402#3,2:172\n10065#3:174\n10487#3,2:175\n10489#3,3:181\n37#4:184\n36#4,3:185\n*S KotlinDebug\n*F\n+ 1 DataStructureHistory.kt\norg/kingdoms/data/history/DataStructureHistory$VersionHistory\n*L\n31#1:170,2\n54#1:177\n54#1:178,3\n32#1:172,2\n53#1:174\n53#1:175,2\n53#1:181,3\n57#1:184\n57#1:185,3\n*E\n"})
    private static final class VersionHistory {
        @NotNull
        private final List<SQLAssociatedStatement[]> changes = new ArrayList();

        private final <T> void unwrapNestedArray(Object obj, List<T> merged) {
            Object object = obj;
            if (object instanceof Iterable) {
                Iterable $this$forEach$iv = (Iterable)obj;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator.next();
                    boolean bl = false;
                    Object t = it;
                    Intrinsics.checkNotNull(t);
                    this.unwrapNestedArray(t, merged);
                }
            } else if (object instanceof Object[]) {
                Object[] $this$forEach$iv = (Object[])obj;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    Object element$iv;
                    Object it = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    Object object2 = it;
                    Intrinsics.checkNotNull((Object)object2);
                    this.unwrapNestedArray(object2, merged);
                }
            } else {
                merged.add(obj);
            }
        }

        private final <T> List<T> mergeChanges(Object ... elements) {
            List merged = new ArrayList(elements.length);
            for (Object element : elements) {
                this.unwrapNestedArray(element, merged);
            }
            return merged;
        }

        @NotNull
        public final List<SQLAssociatedStatement> getChanges() {
            Object[] objectArray = new Object[]{this.changes};
            return this.mergeChanges(objectArray);
        }

        /*
         * WARNING - void declaration
         */
        public final void forManagers(@NotNull DataManager<?>[] managers, @NotNull Function0<? extends Object> handler) {
            void $this$toTypedArray$iv;
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter(managers, (String)"managers");
            Intrinsics.checkNotNullParameter(handler, (String)"handler");
            Object $this$flatMap$iv = managers;
            boolean $i$f$flatMap = false;
            DataManager<?>[] dataManagerArray = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            int n = ((void)$this$flatMapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void $this$mapTo$iv$iv;
                void element$iv$iv;
                void manager = element$iv$iv = $this$flatMapTo$iv$iv[i];
                boolean bl = false;
                Object[] objectArray = new Object[]{handler.invoke()};
                Iterable $this$map$iv = this.mergeChanges(objectArray);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void statement;
                    SQLStatement sQLStatement = (SQLStatement)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(statement.associateTo((DataManager<?>)manager));
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            SQLAssociatedStatement[] list = thisCollection$iv.toArray(new SQLAssociatedStatement[0]);
            this.changes.add(list);
        }
    }
}

