/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.handlers;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.kingdoms.constants.DataStringRepresentation;
import org.kingdoms.constants.land.KingdomBlock;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.ProtectionSign;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.KingdomItemBuilder;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureRegistry;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.land.turrets.TurretRegistry;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.land.turrets.TurretType;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.data.database.dataprovider.SQLDataHandlerProperties;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.data.database.dataprovider.StdIdDataType;
import org.kingdoms.data.handlers.DataHandlerKingdomsObject;
import org.kingdoms.data.handlers.abstraction.KeyedDataHandler;
import org.kingdoms.data.history.DataVersion;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.main.KLogger;
import org.kingdoms.managers.fsck.HealthCheckupHandler;
import org.kingdoms.server.location.BlockLocation3;
import org.kingdoms.server.location.BlockVector3;
import org.kingdoms.utils.playerselector.PlayerSelector;
import org.kingdoms.utils.playerselector.PlayerSelectorProvider;
import org.kingdoms.utils.playerselector.PlayerSelectorRegistry;

public final class DataHandlerLand
extends KeyedDataHandler<SimpleChunkLocation, Land> {
    public static final DataHandlerLand INSTANCE = new DataHandlerLand();

    public DataHandlerLand() {
        super(StdIdDataType.SIMPLE_CHUNK_LOCATION, new SQLDataHandlerProperties(new String[0]));
    }

    public static void checkInsideLand(Land land, Collection<? extends KingdomBlock> blocks) {
        Iterator<? extends KingdomBlock> iter = blocks.iterator();
        while (iter.hasNext()) {
            KingdomBlock block = iter.next();
            if (land.getLocation().isInChunk(block.getOrigin())) continue;
            land.saveObjectState(true);
            HealthCheckupHandler.auto("&4Found kingdom block in a land that doesn't belong to its containing land&8: &6Containing Land&8: &9" + land.getLocation() + " &7- &6Block&8: &9" + block.getOrigin() + " &8(&9" + block.getOrigin().toSimpleChunkLocation() + "&8)");
            iter.remove();
        }
    }

    public static void checkInsideLand(Land land) {
        DataHandlerLand.checkInsideLand(land, land.unsafeGetStructures().values());
        DataHandlerLand.checkInsideLand(land, land.unsafeGetTurrets().values());
        DataHandlerLand.checkInsideLand(land, land.unsafeGetProtectedBlocks().values());
    }

    @Override
    public void save(@NotNull SectionableDataSetter provider, @NonNull Land land) {
        provider.setUUID("kingdom", land.getKingdomId());
        provider.setUUID("claimedBy", land.getClaimedBy());
        provider.setLong("since", land.getSince());
        DataHandlerLand.checkInsideLand(land);
        provider.get("structures").setMap(land.getStructures(), (key, keyProvider, structure) -> {
            keyProvider.setString((DataStringRepresentation)key);
            SectionableDataSetter section = keyProvider.getValueProvider().createSection();
            structure.serialize(new SerializationContext<SectionableDataSetter>(section));
            DataHandlerKingdomsObject.save(section, structure);
        });
        provider.get("turrets").setMap(land.getTurrets(), (key, keyProvider, turret) -> {
            keyProvider.setString((DataStringRepresentation)key);
            SectionableDataSetter section = keyProvider.getValueProvider().createSection();
            turret.serialize(new SerializationContext<SectionableDataSetter>(section));
            DataHandlerKingdomsObject.save(section, turret);
        });
        provider.get("protectedBlocks").setMap(land.getProtectedBlocks(), (key, keyProvider, ps) -> {
            keyProvider.setString((DataStringRepresentation)key);
            SectionableDataSetter valueProvider = keyProvider.getValueProvider().createSection();
            valueProvider.setString("password", ps.getPassword());
            valueProvider.get("sign").setString(ps.getSign());
            valueProvider.setUUID("owner", ps.getOwner());
            valueProvider.setLong("since", ps.getSince());
            valueProvider.setString("protectionType", ps.getProtectionType().name());
            if (ps.getAutomaticStateToggle() != null) {
                valueProvider.setLong("automaticStateToggle", ps.getAutomaticStateToggle().toMillis());
            }
            valueProvider.get("accessEntries").setCollection(ps.getAccessEntries(), (pProvider, pVal) -> {
                SectionableDataSetter sec = pProvider.createSection();
                pVal.getSelector().serialize(new SerializationContext<SectionableDataSetter>(sec.createSection("selector")));
                sec.setString("privilege", pVal.getPrivilege().name());
            });
            DataHandlerKingdomsObject.save(valueProvider, ps);
        });
        DataHandlerKingdomsObject.save(provider, land);
    }

    private static BlockVector3 getLocation(String key) {
        if (DataVersion.getCurrentVersion() == DataVersion.VERSION_0) {
            return BlockLocation3.fromString(key).toVector();
        }
        return BlockVector3.fromString(key);
    }

    @Override
    public Land load(@NotNull SectionableDataGetter provider, SimpleChunkLocation id) {
        UUID kingdom = provider.get("kingdom").asUUID();
        UUID claimedBy = provider.get("claimedBy").asUUID();
        long since = provider.getLong("since");
        Land land = new Land(id, kingdom, claimedBy, since);
        provider.get("structures").asMap(land.unsafeGetStructures(), (map, key, structureProvider) -> {
            String styleName = structureProvider.getString("type");
            StructureStyle style = StructureRegistry.get().getStyle(styleName);
            if (style == null) {
                KLogger.warn("Unknown structure style '" + styleName + "' (the file was possibly deleted from Structures folder)");
                return;
            }
            BlockVector3 loc = DataHandlerLand.getLocation(key.asString());
            KingdomBuilding structure = ((StructureType)style.getType()).build(new KingdomItemBuilder(style, SimpleLocation.of(id.getWorld(), loc)));
            ((Structure)structure).deserialize(new DeserializationContext<SectionableDataGetter>((SectionableDataGetter)structureProvider));
            structure.modifyData(land, true);
            DataHandlerKingdomsObject.load(structureProvider, structure);
        });
        provider.get("turrets").asMap(land.unsafeGetTurrets(), (map, key, turretProvider) -> {
            String styleName = turretProvider.getString("type");
            TurretStyle style = TurretRegistry.get().getStyle(styleName);
            if (style == null) {
                KLogger.warn("Unknown turret style '" + styleName + "' (the file was possibly deleted from Turrets folder)");
                return;
            }
            BlockVector3 loc = DataHandlerLand.getLocation(key.asString());
            KingdomBuilding turret = ((TurretType)style.getType()).build(new KingdomItemBuilder(style, SimpleLocation.of(id.getWorld(), loc)));
            turret.deserialize(new DeserializationContext<SectionableDataGetter>((SectionableDataGetter)turretProvider));
            turret.modifyData(land, true);
            DataHandlerKingdomsObject.load(turretProvider, turret);
        });
        provider.get("protectedBlocks").asMap(land.unsafeGetProtectedBlocks(), (map, key, pbProvider) -> {
            BlockVector3 loc = DataHandlerLand.getLocation(key.asString());
            BlockVector3 sign = pbProvider.get("sign").asSimpleLocation().toBlockVector();
            String password = pbProvider.getString("password");
            UUID owner = pbProvider.get("owner").asUUID();
            long sinceProtectionSign = pbProvider.getLong("since");
            long automaticStateToggle = pbProvider.getLong("automaticStateToggle");
            String protectionTypeStr = pbProvider.getString("protectionType");
            ProtectionSign.ProtectionType protectionType = protectionTypeStr == null ? ProtectionSign.ProtectionType.PROTECTED : ProtectionSign.ProtectionType.valueOf(protectionTypeStr);
            List accessEntries = pbProvider.get("accessEntries").asCollection(new ArrayList(), (privs, pProvider) -> {
                ProtectionSign.AccessPrivilege privilege = ProtectionSign.AccessPrivilege.valueOf(pProvider.getString("privilege"));
                SectionableDataGetter selectorSection = pProvider.get("selector").asSection();
                String selectorNs = selectorSection.getString("namespace");
                PlayerSelectorProvider selectorProvider = (PlayerSelectorProvider)((Object)PlayerSelectorRegistry.INSTANCE.getRegistered(Namespace.fromString(selectorNs)));
                Object selector = selectorProvider.construct();
                selector.deserialize(new DeserializationContext<SectionableDataGetter>(selectorSection));
                privs.add(new ProtectionSign.AccessEntry((PlayerSelector)selector, privilege));
            });
            ProtectionSign ps = new ProtectionSign(SimpleLocation.of(id.getWorld(), loc), SimpleLocation.of(id.getWorld(), sign), owner, protectionType, password, sinceProtectionSign, accessEntries, Duration.ofMillis(automaticStateToggle));
            ps.modifyData(land, true);
            DataHandlerKingdomsObject.load(pbProvider, ps);
        });
        DataHandlerKingdomsObject.load(provider, land);
        DataHandlerLand.checkInsideLand(land);
        return land;
    }
}

