/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.handlers;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.economy.Balance;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Shield;
import org.kingdoms.constants.group.flag.GroupBanner;
import org.kingdoms.constants.group.model.BookChapter;
import org.kingdoms.constants.group.model.InviteCode;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.KingdomRelationshipRequest;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.upgradable.KingdomUpgrade;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.namespace.NamespacedFlags;
import org.kingdoms.constants.namespace.NamespacedMap;
import org.kingdoms.constants.player.RankMap;
import org.kingdoms.constants.stats.Statistics;
import org.kingdoms.data.database.dataprovider.DataGetter;
import org.kingdoms.data.database.dataprovider.IdDataTypeHandler;
import org.kingdoms.data.database.dataprovider.MappedIdSetter;
import org.kingdoms.data.database.dataprovider.SQLDataHandlerProperties;
import org.kingdoms.data.database.dataprovider.SectionCreatableDataSetter;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.data.database.dataprovider.StdIdDataType;
import org.kingdoms.data.handlers.DataHandlerGroup;
import org.kingdoms.data.handlers.DataHandlerMetadata;
import org.kingdoms.data.handlers.abstraction.KeyedDataHandler;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Pair;
import org.kingdoms.libs.kotlin.TuplesKt;
import org.kingdoms.libs.kotlin.collections.ArraysKt;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.collections.IndexedValue;
import org.kingdoms.libs.kotlin.collections.MapsKt;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.functions.Function0;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.ranges.RangesKt;
import org.kingdoms.server.location.Location;
import org.kingdoms.utils.compilers.expressions.MathExpression;
import org.kingdoms.utils.internal.arrays.ArrayUtils;
import org.kingdoms.utils.nms.JsonItemStack;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0018\u0010\u000b\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/kingdoms/data/handlers/DataHandlerKingdom;", "Lorg/kingdoms/data/handlers/abstraction/KeyedDataHandler;", "Ljava/util/UUID;", "Lorg/kingdoms/constants/group/Kingdom;", "<init>", "()V", "save", "", "provider", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "data", "load", "Lorg/kingdoms/data/database/dataprovider/SectionableDataGetter;", "id", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nDataHandlerKingdom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataHandlerKingdom.kt\norg/kingdoms/data/handlers/DataHandlerKingdom\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,206:1\n1187#2,2:207\n1261#2,4:209\n535#3:213\n520#3,6:214\n*S KotlinDebug\n*F\n+ 1 DataHandlerKingdom.kt\norg/kingdoms/data/handlers/DataHandlerKingdom\n*L\n60#1:207,2\n60#1:209,4\n61#1:213\n61#1:214,6\n*E\n"})
public final class DataHandlerKingdom
extends KeyedDataHandler<UUID, Kingdom> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final DataHandlerKingdom INSTANCE = new DataHandlerKingdom();

    public DataHandlerKingdom() {
        IdDataTypeHandler idDataTypeHandler = StdIdDataType.UUID;
        Object[] objectArray = new Object[]{SQLDataHandlerProperties.Companion.ofLocation("home"), SQLDataHandlerProperties.Companion.ofSimpleLocation("nexus"), "flag"};
        String[] stringArray = ArrayUtils.mergeObjects(objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"mergeObjects(...)");
        super(idDataTypeHandler, new SQLDataHandlerProperties(stringArray));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void save(@NotNull SectionableDataSetter provider, @NotNull Kingdom data) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$associateTo$iv$iv;
        Map $this$associate$iv;
        Map<Namespace, Object> upgrade;
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        DataHandlerGroup.save(provider, data);
        provider.setUUID("king", data.getKingId());
        provider.setUUID("nation", data.getNationId());
        provider.setString("lore", data.getLore());
        provider.setInt("maxLandsModifier", data.getMaxLandsModifier());
        provider.setLong("lastInvasion", data.getLastInvasion());
        SectionableDataSetter sectionableDataSetter = provider.get("lands");
        Set<SimpleChunkLocation> set = data.getLandLocations();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getLandLocations(...)");
        sectionableDataSetter.setCollection((Collection)set, DataHandlerKingdom::save$lambda$0);
        SectionableDataSetter sectionableDataSetter2 = provider.get("members");
        Set<UUID> set2 = data.getMembers();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"getMembers(...)");
        sectionableDataSetter2.setCollection((Collection)set2, DataHandlerKingdom::save$lambda$1);
        SectionableDataSetter it = provider.createSection("upgrades");
        boolean bl = false;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"misc", data.getMiscUpgrades()), TuplesKt.to((Object)"powerups", data.getPowerups()), TuplesKt.to((Object)"champions", data.getChampionUpgrades())};
        for (Pair pair : pairArray) {
            String name = (String)pair.component1();
            Object object = pair.component2();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"component2(...)");
            upgrade = (NamespacedMap)object;
            it.get(name).setMap((Map)upgrade, DataHandlerKingdom::save$lambda$3$lambda$2);
        }
        SectionableDataSetter sectionableDataSetter3 = provider.get("nexusChest");
        ItemStack[] itemStackArray = data.getNexusChest().getOriginal().getContents();
        Intrinsics.checkNotNullExpressionValue((Object)itemStackArray, (String)"getContents(...)");
        Iterable iterable = ArraysKt.withIndex((Object[])itemStackArray);
        SectionableDataSetter sectionableDataSetter4 = sectionableDataSetter3;
        boolean $i$f$associate = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associate$iv), (int)10)), (int)16);
        void var6_9 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            upgrade = destination$iv$iv;
            IndexedValue indexedValue = (IndexedValue)element$iv$iv;
            boolean bl2 = false;
            int index = indexedValue.component1();
            ItemStack value = (ItemStack)indexedValue.component2();
            indexedValue = TuplesKt.to((Object)index, (Object)value);
            upgrade.put((Namespace)indexedValue.getFirst(), indexedValue.getSecond());
        }
        $this$associate$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        void capacity$iv22 = $this$filter$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl3 = false;
            ItemStack item = (ItemStack)entry.getValue();
            if (!(item != null)) continue;
            destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        sectionableDataSetter4.setMap(destination$iv$iv2, DataHandlerKingdom::save$lambda$6);
        SectionableDataSetter sectionableDataSetter5 = provider.get("book");
        Map<String, BookChapter> map = data.getBook();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getBook(...)");
        sectionableDataSetter5.setMap(map, DataHandlerKingdom::save$lambda$9);
        provider.get("mails").setCollection((Collection)data.getMails().keySet(), DataHandlerKingdom::save$lambda$10);
        SectionableDataSetter sectionableDataSetter6 = provider.get("challenges");
        Map<UUID, Long> map2 = data.getChallenges();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"getChallenges(...)");
        sectionableDataSetter6.setMap(map2, DataHandlerKingdom::save$lambda$11);
        SectionableDataSetter sectionableDataSetter7 = provider.get("inviteCodes");
        Map<String, InviteCode> map3 = data.getInviteCodes();
        Intrinsics.checkNotNullExpressionValue(map3, (String)"getInviteCodes(...)");
        sectionableDataSetter7.setMap(map3, DataHandlerKingdom::save$lambda$14);
    }

    @Override
    @NotNull
    public Kingdom load(@NotNull SectionableDataGetter provider, @NotNull UUID id) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        DataHandlerGroup.GroupDataHolder parent = DataHandlerGroup.load(provider, false);
        UUID king = provider.get("king").asUUID();
        UUID nation = provider.get("nation").asUUID();
        String name = parent.getName();
        String tag = parent.getTag();
        String lore = provider.getString("lore");
        NamespacedMap<MathExpression> tax = parent.getTaxes();
        GroupBanner flag = parent.getFlag();
        NamespacedMap<Color> color = parent.getColors();
        String championType = provider.get("championType").asString((Function0<String>)((Function0)DataHandlerKingdom::load$lambda$15));
        int maxClaimMod = provider.getInt("maxLandsModifier");
        Balance bank = parent.getBank();
        Balance rp = parent.getResourcePoints();
        long lastInvasion = provider.getLong("lastInvasion");
        long since = parent.getSince();
        Location home = parent.getHome();
        SimpleLocation nexus = parent.getNexus();
        RankMap ranks = parent.getRanks();
        NamespacedFlags flags = parent.getFlags();
        Statistics stats = parent.getStats();
        Map<KingdomRelation, Set<RelationAttribute>> attributes = parent.getAttributes();
        Map<UUID, KingdomRelationshipRequest> rlReq = parent.getRelationshipRequests();
        Map<UUID, KingdomRelation> relations = parent.getRelations();
        Set members = provider.get("members").asCollection((Collection)new HashSet(), DataHandlerKingdom::load$lambda$16);
        Set lands = provider.get("lands").asCollection((Collection)new HashSet(), DataHandlerKingdom::load$lambda$17);
        SectionableDataGetter upgrades = provider.get("upgrades").asSection();
        NamespacedMap miscUpgrades = upgrades.get("misc").asMap((Map)new NamespacedMap(), DataHandlerKingdom::load$lambda$18);
        NamespacedMap powerups = upgrades.get("powerups").asMap((Map)new NamespacedMap(), DataHandlerKingdom::load$lambda$19);
        NamespacedMap championUpgrades = upgrades.get("champions").asMap((Map)new NamespacedMap(), DataHandlerKingdom::load$lambda$20);
        HashMap items = provider.get("nexusChest").asMap((Map)new HashMap(), DataHandlerKingdom::load$lambda$21);
        HashMap book = provider.get("book").asMap((Map)new HashMap(), DataHandlerKingdom::load$lambda$23);
        Set mails = provider.get("mails").asCollection((Collection)new HashSet(), DataHandlerKingdom::load$lambda$24);
        HashMap challenges = provider.get("challenges").asMap((Map)new HashMap(), DataHandlerKingdom::load$lambda$25);
        HashMap inviteCodes = provider.get("inviteCodes").asMap((Map)new HashMap(), DataHandlerKingdom::load$lambda$27);
        DataHandlerGroup.GroupDataHolder $this$load_u24lambda_u2428 = parent;
        boolean bl = false;
        Map<UUID, KingdomRelationshipRequest> map = rlReq;
        Intrinsics.checkNotNull(map);
        RankMap rankMap = ranks;
        Intrinsics.checkNotNull((Object)rankMap);
        Map<UUID, KingdomRelation> map2 = relations;
        Intrinsics.checkNotNull(map2);
        String string = championType;
        Intrinsics.checkNotNull((Object)string);
        int n = parent.getLevel();
        GroupBanner groupBanner = $this$load_u24lambda_u2428.getBanner();
        NamespacedFlags namespacedFlags = flags;
        Intrinsics.checkNotNull((Object)namespacedFlags);
        Shield shield = $this$load_u24lambda_u2428.getShield();
        Map<KingdomRelation, Set<RelationAttribute>> map3 = attributes;
        Intrinsics.checkNotNull(map3);
        Kingdom kingdom = new Kingdom(id, map, mails, challenges, inviteCodes, miscUpgrades, powerups, championUpgrades, lands, rankMap, map2, members, lore, string, king, nation, name, tag, n, tax, nexus, home, book, items, flag, groupBanner, color, rp, maxClaimMod, bank, namespacedFlags, stats, lastInvasion, since, shield, map3);
        DataHandlerMetadata.deserializeMetadata(provider, kingdom);
        return kingdom;
    }

    private static final void save$lambda$0(SectionCreatableDataSetter obj, SimpleChunkLocation value) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        SimpleChunkLocation simpleChunkLocation = value;
        Intrinsics.checkNotNull((Object)simpleChunkLocation);
        obj.setSimpleChunkLocation(simpleChunkLocation);
    }

    private static final void save$lambda$1(SectionCreatableDataSetter obj, UUID value) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        obj.setUUID(value);
    }

    private static final void save$lambda$3$lambda$2(Namespace key, MappedIdSetter keyProvider, Integer value) {
        String string;
        Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
        Namespace namespace = key;
        if (namespace != null) {
            string = namespace.asNormalizedString();
        } else {
            Intrinsics.checkNotNull((Object)key, (String)"null cannot be cast to non-null type org.kingdoms.constants.group.upgradable.KingdomUpgrade");
            string = ((KingdomUpgrade)((Object)key)).getDataName();
        }
        keyProvider.setString(string);
        SectionCreatableDataSetter sectionCreatableDataSetter = keyProvider.getValueProvider();
        Intrinsics.checkNotNull((Object)value);
        sectionCreatableDataSetter.setInt(value);
    }

    private static final void save$lambda$6(int key, MappedIdSetter keyProvider, ItemStack value) {
        Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
        keyProvider.setInt(key);
        keyProvider.getValueProvider().setString(JsonItemStack.serialize(value));
    }

    private static final void save$lambda$9$lambda$8$lambda$7(SectionCreatableDataSetter elementProvider, String element) {
        Intrinsics.checkNotNullParameter((Object)elementProvider, (String)"elementProvider");
        elementProvider.setString(element);
    }

    private static final void save$lambda$9(String key, MappedIdSetter keyProvider, BookChapter value) {
        SectionableDataSetter sectionableDataSetter;
        Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
        keyProvider.setString(key);
        SectionableDataSetter $this$save_u24lambda_u249_u24lambda_u248 = sectionableDataSetter = keyProvider.getValueProvider().createSection();
        boolean bl = false;
        SectionableDataSetter sectionableDataSetter2 = $this$save_u24lambda_u249_u24lambda_u248.get("pages");
        List<String> list = value.getPages();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getPages(...)");
        sectionableDataSetter2.setCollection((Collection)list, DataHandlerKingdom::save$lambda$9$lambda$8$lambda$7);
    }

    private static final void save$lambda$10(SectionCreatableDataSetter elementProvider, UUID element) {
        Intrinsics.checkNotNullParameter((Object)elementProvider, (String)"elementProvider");
        elementProvider.setUUID(element);
    }

    private static final void save$lambda$11(UUID key, MappedIdSetter keyProvider, Long value) {
        Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
        keyProvider.setUUID(key);
        SectionCreatableDataSetter sectionCreatableDataSetter = keyProvider.getValueProvider();
        Intrinsics.checkNotNull((Object)value);
        sectionCreatableDataSetter.setLong(value);
    }

    private static final void save$lambda$14$lambda$13$lambda$12(SectionCreatableDataSetter elementProvider, UUID element) {
        Intrinsics.checkNotNullParameter((Object)elementProvider, (String)"elementProvider");
        elementProvider.setUUID(element);
    }

    private static final void save$lambda$14(String key, MappedIdSetter keyProvider, InviteCode value) {
        SectionableDataSetter sectionableDataSetter;
        Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
        keyProvider.setString(key);
        SectionableDataSetter $this$save_u24lambda_u2414_u24lambda_u2413 = sectionableDataSetter = keyProvider.getValueProvider().createSection();
        boolean bl = false;
        $this$save_u24lambda_u2414_u24lambda_u2413.setUUID("createdBy", value.getCreatedBy());
        $this$save_u24lambda_u2414_u24lambda_u2413.setLong("createdAt", value.getCreatedAt());
        $this$save_u24lambda_u2414_u24lambda_u2413.setLong("expiration", value.getExpiration());
        $this$save_u24lambda_u2414_u24lambda_u2413.setInt("uses", value.getUses());
        SectionableDataSetter sectionableDataSetter2 = $this$save_u24lambda_u2414_u24lambda_u2413.get("usedBy");
        Set<UUID> set = value.getUsedBy();
        Intrinsics.checkNotNullExpressionValue(set, (String)"getUsedBy(...)");
        sectionableDataSetter2.setCollection((Collection)set, DataHandlerKingdom::save$lambda$14$lambda$13$lambda$12);
    }

    private static final String load$lambda$15() {
        return KingdomsConfig.ChampionUpgrades.CHAMPIONS_DEFAULT.getManager().getString();
    }

    private static final void load$lambda$16(HashSet set, SectionableDataGetter element) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        UUID uUID = element.asUUID();
        Intrinsics.checkNotNull((Object)uUID);
        set.add(uUID);
    }

    private static final void load$lambda$17(HashSet set, SectionableDataGetter element) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        set.add(element.asSimpleChunkLocation());
    }

    private static final void load$lambda$18(NamespacedMap map, DataGetter key, SectionableDataGetter value) {
        Intrinsics.checkNotNull((Object)map);
        Map map2 = map;
        String string = key.asString();
        Intrinsics.checkNotNull((Object)string);
        map2.put(Namespace.fromString(string), value.asInt());
    }

    private static final void load$lambda$19(NamespacedMap map, DataGetter key, SectionableDataGetter value) {
        Intrinsics.checkNotNull((Object)map);
        Map map2 = map;
        String string = key.asString();
        Intrinsics.checkNotNull((Object)string);
        map2.put(Namespace.fromString(string), value.asInt());
    }

    private static final void load$lambda$20(NamespacedMap map, DataGetter key, SectionableDataGetter value) {
        Intrinsics.checkNotNull((Object)map);
        Map map2 = map;
        String string = key.asString();
        Intrinsics.checkNotNull((Object)string);
        map2.put(Namespace.fromString(string), value.asInt());
    }

    private static final void load$lambda$21(HashMap map, DataGetter key, SectionableDataGetter value) {
        Intrinsics.checkNotNull((Object)map);
        ((Map)map).put(key.asInt(), JsonItemStack.deserialize(value.asString()));
    }

    private static final void load$lambda$23$lambda$22(ArrayList list, SectionableDataGetter element) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        list.add(element.asString());
    }

    private static final void load$lambda$23(HashMap map, DataGetter key, SectionableDataGetter value) {
        String string = key.asString();
        Intrinsics.checkNotNull((Object)string);
        String chapter = string;
        Intrinsics.checkNotNull((Object)map);
        ((Map)map).put(chapter, new BookChapter(chapter, value.get("pages").asCollection((Collection)new ArrayList(), DataHandlerKingdom::load$lambda$23$lambda$22)));
    }

    private static final void load$lambda$24(HashSet collection, SectionableDataGetter element) {
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        UUID uUID = element.asUUID();
        Intrinsics.checkNotNull((Object)uUID);
        UUID mailId = uUID;
        collection.add(mailId);
    }

    private static final void load$lambda$25(HashMap map, DataGetter key, SectionableDataGetter value) {
        Intrinsics.checkNotNull((Object)map);
        Map map2 = map;
        UUID uUID = key.asUUID();
        Intrinsics.checkNotNull((Object)uUID);
        map2.put(uUID, value.asLong());
    }

    private static final void load$lambda$27$lambda$26(HashSet list, SectionableDataGetter element) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        UUID uUID = element.asUUID();
        Intrinsics.checkNotNull((Object)uUID);
        list.add(uUID);
    }

    private static final void load$lambda$27(HashMap map, DataGetter key, SectionableDataGetter value) {
        String string = key.asString();
        Intrinsics.checkNotNull((Object)string);
        String code = string;
        long createdAt = value.getLong("createdAt");
        UUID uUID = value.get("createdBy").asUUID();
        Intrinsics.checkNotNull((Object)uUID);
        UUID createdBy = uUID;
        long expiration = value.getLong("expiration");
        int uses = value.getInt("uses");
        Set usedBy = value.get("usedBy").asCollection((Collection)new HashSet(), DataHandlerKingdom::load$lambda$27$lambda$26);
        Intrinsics.checkNotNull((Object)map);
        ((Map)map).put(code, new InviteCode(code, createdAt, expiration, createdBy, usedBy, uses));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/kingdoms/data/handlers/DataHandlerKingdom$Companion;", "", "<init>", "()V", "INSTANCE", "Lorg/kingdoms/data/handlers/DataHandlerKingdom;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

