/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.handlers;

import java.awt.Color;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.kingdoms.constants.economy.Balance;
import org.kingdoms.constants.economy.GroupBankEconomy;
import org.kingdoms.constants.economy.ResourcePointsEconomy;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Shield;
import org.kingdoms.constants.group.flag.GroupBanner;
import org.kingdoms.constants.group.flag.GroupBannerProvider;
import org.kingdoms.constants.group.flag.GroupBannerRegistry;
import org.kingdoms.constants.group.flag.URLGroupBanner;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.KingdomRelationshipRequest;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.namespace.NamespacedFlags;
import org.kingdoms.constants.namespace.NamespacedMap;
import org.kingdoms.constants.namespaces.DefaultDataFlags;
import org.kingdoms.constants.namespaces.DefaultTaxes;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.constants.player.RankMap;
import org.kingdoms.constants.stats.Statistics;
import org.kingdoms.constants.themes.MainTheme;
import org.kingdoms.data.database.dataprovider.DataGetter;
import org.kingdoms.data.database.dataprovider.DataSetter;
import org.kingdoms.data.database.dataprovider.DynamicSection;
import org.kingdoms.data.database.dataprovider.MappedIdSetter;
import org.kingdoms.data.database.dataprovider.SectionCreatableDataSetter;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.data.handlers.DataHandlerKingdomsObject;
import org.kingdoms.data.handlers.DataHandlerRank;
import org.kingdoms.data.history.DataHandleContainer;
import org.kingdoms.data.history.DataHolder;
import org.kingdoms.data.history.DataVersion;
import org.kingdoms.data.history.DataVersionRegistry;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Unit;
import org.kingdoms.libs.kotlin.jdk7.AutoCloseableKt;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.functions.Function1;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.platform.bukkit.adapters.BukkitAdapter;
import org.kingdoms.server.location.Location;
import org.kingdoms.utils.compilers.MathCompiler;
import org.kingdoms.utils.compilers.expressions.MathExpression;
import org.kingdoms.utils.internal.enumeration.QuickEnumMap;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\"\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000b\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0007R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lorg/kingdoms/data/handlers/DataHandlerGroup;", "", "<init>", "()V", "registry", "Lorg/kingdoms/data/history/DataVersionRegistry;", "Lorg/kingdoms/data/handlers/DataHandlerGroup$GroupDataHolder;", "getRegistry", "()Lorg/kingdoms/data/history/DataVersionRegistry;", "save", "", "provider", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "data", "Lorg/kingdoms/constants/group/Group;", "serializeBanner", "name", "", "banner", "Lorg/kingdoms/constants/group/flag/GroupBanner;", "deserializeBanner", "Lorg/kingdoms/data/database/dataprovider/SectionableDataGetter;", "load", "isNation", "", "GroupDataHolder", "core"})
@SourceDebugExtension(value={"SMAP\nDataHandlerGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataHandlerGroup.kt\norg/kingdoms/data/handlers/DataHandlerGroup\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,258:1\n423#2:259\n1246#3,4:260\n1#4:264\n*S KotlinDebug\n*F\n+ 1 DataHandlerGroup.kt\norg/kingdoms/data/handlers/DataHandlerGroup\n*L\n229#1:259\n229#1:260,4\n*E\n"})
public final class DataHandlerGroup {
    @NotNull
    public static final DataHandlerGroup INSTANCE = new DataHandlerGroup();
    @NotNull
    private static final DataVersionRegistry<GroupDataHolder> registry = new DataVersionRegistry();

    private DataHandlerGroup() {
    }

    @NotNull
    public final DataVersionRegistry<GroupDataHolder> getRegistry() {
        return registry;
    }

    @JvmStatic
    public static final void save(@NotNull SectionableDataSetter provider, @NotNull Group data) {
        SectionableDataSetter sectionableDataSetter;
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        SectionableDataSetter $this$save_u24lambda_u2416 = sectionableDataSetter = provider;
        boolean bl = false;
        $this$save_u24lambda_u2416.setString("name", data.getName());
        $this$save_u24lambda_u2416.setString("tag", data.getTag());
        $this$save_u24lambda_u2416.setInt("level", data.getRawLevel());
        SectionableDataSetter sectionableDataSetter2 = $this$save_u24lambda_u2416.get("taxes");
        NamespacedMap<MathExpression> namespacedMap = data.getTaxes();
        Intrinsics.checkNotNullExpressionValue(namespacedMap, (String)"getTaxes(...)");
        sectionableDataSetter2.setMap((Map)namespacedMap, DataHandlerGroup::save$lambda$16$lambda$8);
        INSTANCE.serializeBanner("flag", data.getFlag(), provider);
        INSTANCE.serializeBanner("banner", data.getBanner(), provider);
        if (data.getColors() != null) {
            SectionableDataSetter sectionableDataSetter3 = $this$save_u24lambda_u2416.get("colors");
            NamespacedMap<Color> namespacedMap2 = data.getColors();
            Intrinsics.checkNotNullExpressionValue(namespacedMap2, (String)"getColors(...)");
            sectionableDataSetter3.setMap((Map)namespacedMap2, DataHandlerGroup::save$lambda$16$lambda$9);
        }
        $this$save_u24lambda_u2416.setDouble("bank", data.getBank().get());
        $this$save_u24lambda_u2416.setDouble("resourcePoints", data.getResourcePoints().get());
        $this$save_u24lambda_u2416.setLong("since", data.getSince());
        $this$save_u24lambda_u2416.setLong("shieldSince", data.getShield().getStartTime());
        $this$save_u24lambda_u2416.setLong("shieldTime", data.getShield().getDuration().toMillis());
        if (data.getHome() != null) {
            SectionableDataSetter sectionableDataSetter4 = $this$save_u24lambda_u2416.get("home");
            Location location = data.getHome();
            Intrinsics.checkNotNull((Object)location);
            sectionableDataSetter4.setLocation(BukkitAdapter.adapt(location));
        }
        if (data.getNexus() != null) {
            SectionableDataSetter sectionableDataSetter5 = $this$save_u24lambda_u2416.get("nexus");
            SimpleLocation simpleLocation = data.getNexus();
            Intrinsics.checkNotNull((Object)simpleLocation);
            sectionableDataSetter5.setSimpleLocation(simpleLocation);
        }
        SectionableDataSetter sectionableDataSetter6 = $this$save_u24lambda_u2416.get("flags");
        NamespacedFlags namespacedFlags = data.getFlags();
        Intrinsics.checkNotNullExpressionValue((Object)namespacedFlags, (String)"getFlags(...)");
        DataHandlerKingdomsObject.saveFlags(sectionableDataSetter6, namespacedFlags);
        SectionableDataSetter sectionableDataSetter7 = $this$save_u24lambda_u2416.get("statistics");
        Statistics statistics = data.getStatistics();
        Intrinsics.checkNotNullExpressionValue((Object)statistics, (String)"getStatistics(...)");
        DataHandlerKingdomsObject.saveStats(sectionableDataSetter7, statistics);
        SectionableDataSetter sectionableDataSetter8 = $this$save_u24lambda_u2416.get("ranks");
        Map<String, Rank> map = data.getRanks().getNodedRanks();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getNodedRanks(...)");
        sectionableDataSetter8.setMap(map, DataHandlerGroup::save$lambda$16$lambda$10);
        SectionableDataSetter sectionableDataSetter9 = $this$save_u24lambda_u2416.get("attributes");
        Map<KingdomRelation, Set<RelationAttribute>> map2 = data.getAttributes();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"getAttributes(...)");
        sectionableDataSetter9.setMap(map2, DataHandlerGroup::save$lambda$16$lambda$12);
        SectionableDataSetter sectionableDataSetter10 = $this$save_u24lambda_u2416.get("relationshipRequests");
        Map<UUID, KingdomRelationshipRequest> map3 = data.getRelationshipRequests();
        Intrinsics.checkNotNullExpressionValue(map3, (String)"getRelationshipRequests(...)");
        sectionableDataSetter10.setMap(map3, DataHandlerGroup::save$lambda$16$lambda$14);
        SectionableDataSetter sectionableDataSetter11 = $this$save_u24lambda_u2416.get("relations");
        Map<UUID, KingdomRelation> map4 = data.unsafeGetRelations();
        Intrinsics.checkNotNullExpressionValue(map4, (String)"unsafeGetRelations(...)");
        sectionableDataSetter11.setMap(map4, DataHandlerGroup::save$lambda$16$lambda$15);
        DataHandlerKingdomsObject.save($this$save_u24lambda_u2416, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void serializeBanner(String name, GroupBanner banner, SectionableDataSetter provider) {
        if (banner != null) {
            AutoCloseable autoCloseable = provider.createDynamicSection(name);
            Throwable throwable = null;
            try {
                DynamicSection it = (DynamicSection)autoCloseable;
                boolean bl = false;
                banner.serialize(new SerializationContext<DataSetter>(it.getSetter()));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
    }

    private final GroupBanner deserializeBanner(SectionableDataGetter provider) {
        SectionableDataGetter section = provider.asDynamicSection();
        String string = section.getString("namespace");
        if (string == null) {
            return null;
        }
        String nsStr = string;
        Namespace namespace = Namespace.fromString(nsStr);
        Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"fromString(...)");
        Namespace ns = namespace;
        GroupBannerProvider groupBannerProvider = (GroupBannerProvider)((Object)GroupBannerRegistry.INSTANCE.getRegistered(ns));
        if (groupBannerProvider == null) {
            throw new IllegalStateException("Unknown banner provider: " + nsStr);
        }
        GroupBannerProvider bannerProvider = groupBannerProvider;
        Object banner = bannerProvider.construct();
        banner.deserialize(new DeserializationContext<DataGetter>(section));
        return banner;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final GroupDataHolder load(@NotNull SectionableDataGetter provider, boolean isNation) {
        Cloneable cloneable;
        GroupDataHolder groupDataHolder;
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        GroupDataHolder $this$load_u24lambda_u2425 = groupDataHolder = new GroupDataHolder();
        boolean bl = false;
        String string = provider.getString("name");
        Intrinsics.checkNotNull((Object)string);
        $this$load_u24lambda_u2425.setName(string);
        $this$load_u24lambda_u2425.setTag(provider.getString("tag"));
        DataVersion dataVersion = DataVersion.getCurrentVersion();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)dataVersion), (String)"getCurrentVersion(...)");
        registry.get(dataVersion).load(provider, (GroupDataHolder)((DataHolder)$this$load_u24lambda_u2425));
        $this$load_u24lambda_u2425.setBank(GroupBankEconomy.INSTANCE.createBalance(provider.getDouble("bank")));
        $this$load_u24lambda_u2425.setResourcePoints(ResourcePointsEconomy.INSTANCE.createBalance(provider.getDouble("resourcePoints")));
        $this$load_u24lambda_u2425.setSince(provider.getLong("since"));
        long l = provider.getLong("shieldSince");
        Duration duration = Duration.ofMillis(provider.getLong("shieldTime"));
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        $this$load_u24lambda_u2425.setShield(new Shield(l, duration));
        $this$load_u24lambda_u2425.setHome(BukkitAdapter.adapt(provider.get("home").asLocation()));
        $this$load_u24lambda_u2425.setNexus(provider.get("nexus").asSimpleLocation());
        HashMap rankMapping = provider.get("ranks").asMap((Map)new HashMap(), DataHandlerGroup::load$lambda$25$lambda$18);
        GroupDataHolder groupDataHolder2 = $this$load_u24lambda_u2425;
        if (rankMapping.isEmpty()) {
            cloneable = Rank.copyDefaults(isNation);
        } else {
            Cloneable cloneable2;
            GroupDataHolder groupDataHolder3 = groupDataHolder2;
            try {
                void var17_18;
                void destination$iv;
                void $this$mapKeysTo$iv;
                cloneable2 = rankMapping;
                Map map = new TreeMap();
                HashMap hashMap = rankMapping;
                GroupDataHolder groupDataHolder4 = groupDataHolder3;
                boolean $i$f$mapKeysTo = false;
                Iterable $this$associateByTo$iv$iv = $this$mapKeysTo$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    void it$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv;
                    var17_18 = destination$iv;
                    boolean bl2 = false;
                    Rank v = (Rank)entry.getValue();
                    Map.Entry entry2 = (Map.Entry)element$iv$iv;
                    Integer n = v.getPriority();
                    entry = var17_18;
                    boolean bl3 = false;
                    Object v2 = it$iv.getValue();
                    entry.put(n, v2);
                }
                var17_18 = destination$iv;
                groupDataHolder2 = groupDataHolder4;
                TreeMap treeMap = (TreeMap)var17_18;
                HashMap hashMap2 = hashMap;
                cloneable2 = new RankMap(hashMap2, treeMap);
            }
            catch (Throwable destination$iv) {
                void ex;
                groupDataHolder2 = groupDataHolder3;
                KLogger.error("Corrupted rank data for '" + $this$load_u24lambda_u2425.getName() + "', resetting their ranks: " + ex.getMessage());
                cloneable2 = Rank.copyDefaults(isNation);
            }
            cloneable = cloneable2;
        }
        groupDataHolder2.setRanks((RankMap)cloneable);
        $this$load_u24lambda_u2425.setAttributes(provider.get("attributes").asMap((Map)new QuickEnumMap((Enum[])KingdomRelation.VALUES), DataHandlerGroup::load$lambda$25$lambda$21));
        $this$load_u24lambda_u2425.setRelationshipRequests(provider.get("relationshipRequests").asMap((Map)new HashMap(), DataHandlerGroup::load$lambda$25$lambda$23));
        $this$load_u24lambda_u2425.setRelations(provider.get("relations").asMap((Map)new HashMap(), DataHandlerGroup::load$lambda$25$lambda$24));
        return groupDataHolder;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit _init_$lambda$4(DataHandleContainer $this$version) {
        block6: {
            block5: {
                NamespacedMap<MathExpression> namespacedMap;
                Intrinsics.checkNotNullParameter((Object)$this$version, (String)"$this$version");
                ((GroupDataHolder)$this$version.getData()).setLevel(1);
                ((GroupDataHolder)$this$version.getData()).setStats(new Statistics());
                NamespacedFlags flags = new NamespacedFlags(DefaultDataFlags.Groups.DEFAULTS);
                ((Map)flags).put(DefaultDataFlags.Groups.PUBLIC_HOME, $this$version.getProvider().getBoolean("publicHome"));
                ((Map)flags).put(DefaultDataFlags.Groups.PERMANENT, $this$version.getProvider().getBoolean("permanent"));
                ((Map)flags).put(DefaultDataFlags.Groups.REQUIRES_INVITE, $this$version.getProvider().getBoolean("requiresInvite"));
                ((GroupDataHolder)$this$version.getData()).setFlags(flags);
                NamespacedMap<MathExpression> namespacedMap2 = namespacedMap = new NamespacedMap<MathExpression>();
                GroupDataHolder groupDataHolder = (GroupDataHolder)$this$version.getData();
                boolean bl = false;
                String string = $this$version.getProvider().getString("tax");
                if (string != null) {
                    void $this$lambda_u244_u24lambda_u241;
                    String it = string;
                    boolean bl2 = false;
                    $this$lambda_u244_u24lambda_u241.put(DefaultTaxes.MAIN, MathCompiler.Companion.compile(it));
                }
                groupDataHolder.setTaxes(namespacedMap);
                String string2 = $this$version.getProvider().getString("flag");
                if (string2 != null) {
                    URL bl2;
                    String flagStr = string2;
                    boolean bl3 = false;
                    try {
                        bl2 = new URI(flagStr).toURL();
                        Intrinsics.checkNotNull((Object)bl2);
                    }
                    catch (URISyntaxException ex) {
                        break block5;
                    }
                    URL url = bl2;
                    URLGroupBanner banner = new URLGroupBanner();
                    banner.setUrl(url);
                    ((GroupDataHolder)$this$version.getData()).setFlag(banner);
                }
            }
            int color = $this$version.getProvider().getInt("color");
            boolean bl = false;
            if (color == 0) break block6;
            NamespacedMap<Color> namespacedMap = ((GroupDataHolder)$this$version.getData()).getColors();
            if (namespacedMap != null) {
                namespacedMap.put(MainTheme.INSTANCE.getNamespace(), new Color(color));
            }
        }
        return Unit.INSTANCE;
    }

    private static final void lambda$7$lambda$5(NamespacedMap map, DataGetter key, SectionableDataGetter value) {
        Intrinsics.checkNotNull((Object)map);
        Map map2 = map;
        String string = key.asString();
        Intrinsics.checkNotNull((Object)string);
        map2.put(Namespace.fromString(string), MathCompiler.Companion.compile(value.asString()));
    }

    private static final void lambda$7$lambda$6(NamespacedMap colors, DataGetter key, SectionableDataGetter value) {
        Intrinsics.checkNotNull((Object)colors);
        Map map = colors;
        String string = key.asString();
        Intrinsics.checkNotNull((Object)string);
        map.put(Namespace.fromString(string), new Color(value.asInt(), true));
    }

    private static final Unit _init_$lambda$7(DataHandleContainer $this$version) {
        Intrinsics.checkNotNullParameter((Object)$this$version, (String)"$this$version");
        ((GroupDataHolder)$this$version.getData()).setLevel($this$version.getProvider().getInt("level"));
        ((GroupDataHolder)$this$version.getData()).setFlags(DataHandlerKingdomsObject.loadFlags($this$version.getProvider().get("flags")));
        ((GroupDataHolder)$this$version.getData()).setStats(DataHandlerKingdomsObject.loadStats($this$version.getProvider().get("statistics")));
        ((GroupDataHolder)$this$version.getData()).setTaxes($this$version.getProvider().get("taxes").asMap((Map)new NamespacedMap(), DataHandlerGroup::lambda$7$lambda$5));
        ((GroupDataHolder)$this$version.getData()).setFlag(INSTANCE.deserializeBanner($this$version.getProvider().get("flag")));
        ((GroupDataHolder)$this$version.getData()).setBanner(INSTANCE.deserializeBanner($this$version.getProvider().get("banner")));
        ((GroupDataHolder)$this$version.getData()).setColors($this$version.getProvider().get("colors").asMap((Map)new NamespacedMap(), DataHandlerGroup::lambda$7$lambda$6));
        return Unit.INSTANCE;
    }

    private static final void save$lambda$16$lambda$8(Namespace key, MappedIdSetter keyProvider, MathExpression value) {
        Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
        keyProvider.setString(key.asNormalizedString());
        SectionCreatableDataSetter sectionCreatableDataSetter = keyProvider.getValueProvider();
        String string = value.getOriginalString();
        if (string == null) {
            string = value.asString(false);
        }
        sectionCreatableDataSetter.setString(string);
    }

    private static final void save$lambda$16$lambda$9(Namespace key, MappedIdSetter mapProvider, Color color) {
        Intrinsics.checkNotNullParameter((Object)mapProvider, (String)"mapProvider");
        mapProvider.setString(key.asNormalizedString());
        SectionCreatableDataSetter valProvider = mapProvider.getValueProvider();
        valProvider.setInt(color.getRGB());
    }

    private static final void save$lambda$16$lambda$10(String key, MappedIdSetter keyProvider, Rank value) {
        Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
        keyProvider.setString(key);
        DataHandlerRank.serializeRank(value, keyProvider.getValueProvider().createSection());
    }

    private static final void save$lambda$16$lambda$12$lambda$11(SectionCreatableDataSetter elementProvider, RelationAttribute element) {
        Intrinsics.checkNotNullParameter((Object)elementProvider, (String)"elementProvider");
        elementProvider.setString(element.getNamespace().asNormalizedString());
    }

    private static final void save$lambda$16$lambda$12(KingdomRelation key, MappedIdSetter keyProvider, Set value) {
        Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
        keyProvider.setString(key.name());
        SectionCreatableDataSetter sectionCreatableDataSetter = keyProvider.getValueProvider();
        Intrinsics.checkNotNull((Object)value);
        sectionCreatableDataSetter.setCollection(value, DataHandlerGroup::save$lambda$16$lambda$12$lambda$11);
    }

    private static final void save$lambda$16$lambda$14(UUID key, MappedIdSetter keyProvider, KingdomRelationshipRequest value) {
        SectionableDataSetter sectionableDataSetter;
        Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
        keyProvider.setUUID(key);
        SectionableDataSetter $this$save_u24lambda_u2416_u24lambda_u2414_u24lambda_u2413 = sectionableDataSetter = keyProvider.getValueProvider().createSection();
        boolean bl = false;
        $this$save_u24lambda_u2416_u24lambda_u2414_u24lambda_u2413.setString("relation", value.getRelation().name());
        $this$save_u24lambda_u2416_u24lambda_u2414_u24lambda_u2413.setUUID("sender", value.getSender());
        $this$save_u24lambda_u2416_u24lambda_u2414_u24lambda_u2413.setLong("acceptTime", value.getAcceptTime().toMillis());
        $this$save_u24lambda_u2416_u24lambda_u2414_u24lambda_u2413.setLong("timestamp", value.getTimestamp());
    }

    private static final void save$lambda$16$lambda$15(UUID key, MappedIdSetter keyProvider, KingdomRelation value) {
        Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
        keyProvider.setUUID(key);
        keyProvider.getValueProvider().setString(value.name());
    }

    private static final void load$lambda$25$lambda$18(HashMap map, DataGetter key, SectionableDataGetter value) {
        String string = key.asString();
        Intrinsics.checkNotNull((Object)string);
        String node = string;
        Intrinsics.checkNotNull((Object)map);
        ((Map)map).put(node, DataHandlerRank.deserializeRank(node, value));
    }

    private static final void load$lambda$25$lambda$21$lambda$20(HashSet set, SectionableDataGetter element) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = element.asString();
        Intrinsics.checkNotNull((Object)string);
        Namespace namespace = Namespace.fromString(string);
        Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"fromString(...)");
        Namespace ns = namespace;
        set.add(Kingdoms.get().getRelationAttributeRegistry().getRegistered(ns));
    }

    private static final void load$lambda$25$lambda$21(Map map, DataGetter key, SectionableDataGetter value) {
        Intrinsics.checkNotNull((Object)map);
        String string = key.asString();
        Intrinsics.checkNotNull((Object)string);
        map.put(KingdomRelation.valueOf(string), value.asCollection((Collection)new HashSet(), DataHandlerGroup::load$lambda$25$lambda$21$lambda$20));
    }

    private static final void load$lambda$25$lambda$23(HashMap map, DataGetter key, SectionableDataGetter value) {
        Intrinsics.checkNotNull((Object)map);
        Map map2 = map;
        UUID uUID = key.asUUID();
        Intrinsics.checkNotNull((Object)uUID);
        UUID uUID2 = uUID;
        SectionableDataGetter it = value;
        boolean bl = false;
        String string = it.getString("relation");
        Intrinsics.checkNotNull((Object)string);
        KingdomRelation relation = KingdomRelation.valueOf(string);
        UUID sender = it.get("sender").asUUID();
        long acceptTime = it.getLong("acceptTime");
        long timestamp = it.getLong("timestamp");
        KingdomRelationshipRequest kingdomRelationshipRequest = new KingdomRelationshipRequest(relation, sender, acceptTime, timestamp);
        map2.put(uUID2, kingdomRelationshipRequest);
    }

    private static final void load$lambda$25$lambda$24(HashMap map, DataGetter k, SectionableDataGetter v) {
        Intrinsics.checkNotNull((Object)map);
        Map map2 = map;
        UUID uUID = k.asUUID();
        Intrinsics.checkNotNull((Object)uUID);
        String string = v.asString();
        Intrinsics.checkNotNull((Object)string);
        map2.put(uUID, KingdomRelation.valueOf(string));
    }

    static {
        registry.version(DataVersion.VERSION_0, (Function1<DataHandleContainer<GroupDataHolder>, Unit>)((Function1)DataHandlerGroup::_init_$lambda$4));
        registry.version(DataVersion.VERSION_1, (Function1<DataHandleContainer<GroupDataHolder>, Unit>)((Function1)DataHandlerGroup::_init_$lambda$7));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\"\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001d\"\u0004\b\"\u0010\u001fR\"\u0010#\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0011\"\u0004\b&\u0010\u0013R\u001a\u0010'\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001c\u0010-\u001a\u0004\u0018\u00010.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001c\u00103\u001a\u0004\u0018\u000104X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u001c\u00109\u001a\u0004\u0018\u000104X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u00106\"\u0004\b;\u00108R\u001c\u0010<\u001a\u0004\u0018\u00010=X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR\u001c\u0010B\u001a\u0004\u0018\u00010CX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR\u001c\u0010H\u001a\u0004\u0018\u00010IX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010MR(\u0010N\u001a\u0010\u0012\u0004\u0012\u00020P\u0012\u0004\u0012\u00020Q\u0018\u00010OX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010S\"\u0004\bT\u0010UR.\u0010V\u001a\u0016\u0012\u0004\u0012\u00020Q\u0012\n\u0012\b\u0012\u0004\u0012\u00020X0W\u0018\u00010OX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bY\u0010S\"\u0004\bZ\u0010UR(\u0010[\u001a\u0010\u0012\u0004\u0012\u00020P\u0012\u0004\u0012\u00020\\\u0018\u00010OX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b]\u0010S\"\u0004\b^\u0010UR\u001c\u0010_\u001a\u0004\u0018\u00010`X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\ba\u0010b\"\u0004\bc\u0010dR\u001c\u0010e\u001a\u0004\u0018\u00010fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bg\u0010h\"\u0004\bi\u0010j\u00a8\u0006k"}, d2={"Lorg/kingdoms/data/handlers/DataHandlerGroup$GroupDataHolder;", "Lorg/kingdoms/data/history/DataHolder;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "tag", "getTag", "setTag", "taxes", "Lorg/kingdoms/constants/namespace/NamespacedMap;", "Lorg/kingdoms/utils/compilers/expressions/MathExpression;", "getTaxes", "()Lorg/kingdoms/constants/namespace/NamespacedMap;", "setTaxes", "(Lorg/kingdoms/constants/namespace/NamespacedMap;)V", "level", "", "getLevel", "()I", "setLevel", "(I)V", "flag", "Lorg/kingdoms/constants/group/flag/GroupBanner;", "getFlag", "()Lorg/kingdoms/constants/group/flag/GroupBanner;", "setFlag", "(Lorg/kingdoms/constants/group/flag/GroupBanner;)V", "banner", "getBanner", "setBanner", "colors", "Ljava/awt/Color;", "getColors", "setColors", "since", "", "getSince", "()J", "setSince", "(J)V", "shield", "Lorg/kingdoms/constants/group/Shield;", "getShield", "()Lorg/kingdoms/constants/group/Shield;", "setShield", "(Lorg/kingdoms/constants/group/Shield;)V", "resourcePoints", "Lorg/kingdoms/constants/economy/Balance;", "getResourcePoints", "()Lorg/kingdoms/constants/economy/Balance;", "setResourcePoints", "(Lorg/kingdoms/constants/economy/Balance;)V", "bank", "getBank", "setBank", "home", "Lorg/kingdoms/server/location/Location;", "getHome", "()Lorg/kingdoms/server/location/Location;", "setHome", "(Lorg/kingdoms/server/location/Location;)V", "nexus", "Lorg/kingdoms/constants/land/location/SimpleLocation;", "getNexus", "()Lorg/kingdoms/constants/land/location/SimpleLocation;", "setNexus", "(Lorg/kingdoms/constants/land/location/SimpleLocation;)V", "ranks", "Lorg/kingdoms/constants/player/RankMap;", "getRanks", "()Lorg/kingdoms/constants/player/RankMap;", "setRanks", "(Lorg/kingdoms/constants/player/RankMap;)V", "relations", "", "Ljava/util/UUID;", "Lorg/kingdoms/constants/group/model/relationships/KingdomRelation;", "getRelations", "()Ljava/util/Map;", "setRelations", "(Ljava/util/Map;)V", "attributes", "", "Lorg/kingdoms/constants/group/model/relationships/RelationAttribute;", "getAttributes", "setAttributes", "relationshipRequests", "Lorg/kingdoms/constants/group/model/relationships/KingdomRelationshipRequest;", "getRelationshipRequests", "setRelationshipRequests", "flags", "Lorg/kingdoms/constants/namespace/NamespacedFlags;", "getFlags", "()Lorg/kingdoms/constants/namespace/NamespacedFlags;", "setFlags", "(Lorg/kingdoms/constants/namespace/NamespacedFlags;)V", "stats", "Lorg/kingdoms/constants/stats/Statistics;", "getStats", "()Lorg/kingdoms/constants/stats/Statistics;", "setStats", "(Lorg/kingdoms/constants/stats/Statistics;)V", "core"})
    public static final class GroupDataHolder
    implements DataHolder {
        public String name;
        @Nullable
        private String tag;
        @Nullable
        private NamespacedMap<MathExpression> taxes;
        private int level = 1;
        @Nullable
        private GroupBanner flag;
        @Nullable
        private GroupBanner banner;
        @Nullable
        private NamespacedMap<Color> colors;
        private long since;
        @Nullable
        private Shield shield;
        @Nullable
        private Balance resourcePoints;
        @Nullable
        private Balance bank;
        @Nullable
        private Location home;
        @Nullable
        private SimpleLocation nexus;
        @Nullable
        private RankMap ranks;
        @Nullable
        private Map<UUID, KingdomRelation> relations;
        @Nullable
        private Map<KingdomRelation, Set<RelationAttribute>> attributes;
        @Nullable
        private Map<UUID, KingdomRelationshipRequest> relationshipRequests;
        @Nullable
        private NamespacedFlags flags;
        @Nullable
        private Statistics stats;

        @NotNull
        public final String getName() {
            String string = this.name;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"name");
            return null;
        }

        public final void setName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.name = string;
        }

        @Nullable
        public final String getTag() {
            return this.tag;
        }

        public final void setTag(@Nullable String string) {
            this.tag = string;
        }

        @Nullable
        public final NamespacedMap<MathExpression> getTaxes() {
            return this.taxes;
        }

        public final void setTaxes(@Nullable NamespacedMap<MathExpression> namespacedMap) {
            this.taxes = namespacedMap;
        }

        public final int getLevel() {
            return this.level;
        }

        public final void setLevel(int n) {
            this.level = n;
        }

        @Nullable
        public final GroupBanner getFlag() {
            return this.flag;
        }

        public final void setFlag(@Nullable GroupBanner groupBanner) {
            this.flag = groupBanner;
        }

        @Nullable
        public final GroupBanner getBanner() {
            return this.banner;
        }

        public final void setBanner(@Nullable GroupBanner groupBanner) {
            this.banner = groupBanner;
        }

        @Nullable
        public final NamespacedMap<Color> getColors() {
            return this.colors;
        }

        public final void setColors(@Nullable NamespacedMap<Color> namespacedMap) {
            this.colors = namespacedMap;
        }

        public final long getSince() {
            return this.since;
        }

        public final void setSince(long l) {
            this.since = l;
        }

        @Nullable
        public final Shield getShield() {
            return this.shield;
        }

        public final void setShield(@Nullable Shield shield) {
            this.shield = shield;
        }

        @Nullable
        public final Balance getResourcePoints() {
            return this.resourcePoints;
        }

        public final void setResourcePoints(@Nullable Balance balance) {
            this.resourcePoints = balance;
        }

        @Nullable
        public final Balance getBank() {
            return this.bank;
        }

        public final void setBank(@Nullable Balance balance) {
            this.bank = balance;
        }

        @Nullable
        public final Location getHome() {
            return this.home;
        }

        public final void setHome(@Nullable Location location) {
            this.home = location;
        }

        @Nullable
        public final SimpleLocation getNexus() {
            return this.nexus;
        }

        public final void setNexus(@Nullable SimpleLocation simpleLocation) {
            this.nexus = simpleLocation;
        }

        @Nullable
        public final RankMap getRanks() {
            return this.ranks;
        }

        public final void setRanks(@Nullable RankMap rankMap) {
            this.ranks = rankMap;
        }

        @Nullable
        public final Map<UUID, KingdomRelation> getRelations() {
            return this.relations;
        }

        public final void setRelations(@Nullable Map<UUID, KingdomRelation> map) {
            this.relations = map;
        }

        @Nullable
        public final Map<KingdomRelation, Set<RelationAttribute>> getAttributes() {
            return this.attributes;
        }

        public final void setAttributes(@Nullable Map<KingdomRelation, Set<RelationAttribute>> map) {
            this.attributes = map;
        }

        @Nullable
        public final Map<UUID, KingdomRelationshipRequest> getRelationshipRequests() {
            return this.relationshipRequests;
        }

        public final void setRelationshipRequests(@Nullable Map<UUID, KingdomRelationshipRequest> map) {
            this.relationshipRequests = map;
        }

        @Nullable
        public final NamespacedFlags getFlags() {
            return this.flags;
        }

        public final void setFlags(@Nullable NamespacedFlags namespacedFlags) {
            this.flags = namespacedFlags;
        }

        @Nullable
        public final Statistics getStats() {
            return this.stats;
        }

        public final void setStats(@Nullable Statistics statistics) {
            this.stats = statistics;
        }
    }
}

