/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.sql.statements.setters;

import java.sql.PreparedStatement;
import java.util.UUID;
import org.kingdoms.data.database.sql.DatabaseType;
import org.kingdoms.data.database.sql.base.SQLDatabase;
import org.kingdoms.data.database.sql.statements.setters.SimplePreparedStatement;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\nJ\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0016J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u001bH\u0016J\u001a\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u001dH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u00020\u00038BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Lorg/kingdoms/data/database/sql/statements/setters/RawSimplePreparedStatement;", "Lorg/kingdoms/data/database/sql/statements/setters/SimplePreparedStatement;", "fromIndex", "", "databaseType", "Lorg/kingdoms/data/database/sql/DatabaseType;", "preparedStatement", "Ljava/sql/PreparedStatement;", "<init>", "(ILorg/kingdoms/data/database/sql/DatabaseType;Ljava/sql/PreparedStatement;)V", "(Lorg/kingdoms/data/database/sql/DatabaseType;Ljava/sql/PreparedStatement;)V", "index", "getIndex", "()I", "setString", "", "name", "", "value", "setInt", "setFloat", "", "setLong", "", "setBoolean", "", "setDouble", "", "setUUID", "Ljava/util/UUID;", "core"})
public final class RawSimplePreparedStatement
implements SimplePreparedStatement {
    @NotNull
    private final DatabaseType databaseType;
    @NotNull
    private final PreparedStatement preparedStatement;
    private int index;

    public RawSimplePreparedStatement(int fromIndex, @NotNull DatabaseType databaseType, @NotNull PreparedStatement preparedStatement) {
        Intrinsics.checkNotNullParameter((Object)((Object)databaseType), (String)"databaseType");
        Intrinsics.checkNotNullParameter((Object)preparedStatement, (String)"preparedStatement");
        this.databaseType = databaseType;
        this.preparedStatement = preparedStatement;
        this.index = fromIndex;
    }

    private final int getIndex() {
        int n = this.index;
        this.index = n + 1;
        return n;
    }

    public RawSimplePreparedStatement(@NotNull DatabaseType databaseType, @NotNull PreparedStatement preparedStatement) {
        Intrinsics.checkNotNullParameter((Object)((Object)databaseType), (String)"databaseType");
        Intrinsics.checkNotNullParameter((Object)preparedStatement, (String)"preparedStatement");
        this(1, databaseType, preparedStatement);
    }

    @Override
    public void setString(@NotNull String name, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.preparedStatement.setString(this.getIndex(), value);
    }

    @Override
    public void setInt(@NotNull String name, int value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.preparedStatement.setInt(this.getIndex(), value);
    }

    @Override
    public void setFloat(@NotNull String name, float value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.preparedStatement.setFloat(this.getIndex(), value);
    }

    @Override
    public void setLong(@NotNull String name, long value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.preparedStatement.setLong(this.getIndex(), value);
    }

    @Override
    public void setBoolean(@NotNull String name, boolean value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.preparedStatement.setBoolean(this.getIndex(), value);
    }

    @Override
    public void setDouble(@NotNull String name, double value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.preparedStatement.setDouble(this.getIndex(), value);
    }

    @Override
    public void setUUID(@NotNull String name, @Nullable UUID value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.databaseType == DatabaseType.PostgreSQL) {
            this.preparedStatement.setObject(this.getIndex(), value);
        } else {
            this.preparedStatement.setBytes(this.getIndex(), SQLDatabase.Companion.asBytes(value));
        }
    }
}

