/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.sql.schema;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kingdoms.utils.internal.nonnull.NonNullList;
import org.kingdoms.utils.internal.nonnull.NonNullMap;

public final class SQLSchemaReader {
    private static final Pattern MACRO_USAGE = Pattern.compile("\\[\\[(\\w+)\\]\\]");
    private final List<String> queries = new NonNullList<String>(100);
    private final Map<String, String> macros = new NonNullMap<String, String>(5);
    private String parsingMacro;
    private final StringBuilder sb = new StringBuilder();
    private String line;
    private int lineNumber = 0;

    public void error(String msg) {
        throw new IllegalStateException(msg + " at line " + this.lineNumber + ": " + this.line);
    }

    public List<String> getStatements(InputStream is) throws IOException {
        Objects.requireNonNull(is, "Cannot get statements from null stream");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            this.lineNumber = 0;
            while ((this.line = reader.readLine()) != null) {
                ++this.lineNumber;
                this.line = this.line.trim();
                if (this.line.isEmpty() || this.line.startsWith("--") || this.line.startsWith("#")) continue;
                if (this.line.startsWith("{{")) {
                    if (this.parsingMacro != null) {
                        this.error("Unexpected start of macro");
                    }
                    this.parsingMacro = this.line.substring(2).trim();
                    continue;
                }
                if (this.line.startsWith("}}")) {
                    if (this.parsingMacro == null) {
                        this.error("Unexpected end of macro");
                    }
                    this.macros.put(this.parsingMacro, this.sb.toString());
                    this.parsingMacro = null;
                    this.sb.setLength(0);
                    continue;
                }
                int commentStart = this.line.indexOf("--");
                if (commentStart > 0) {
                    this.line = this.line.substring(0, commentStart);
                }
                Matcher macroMatcher = MACRO_USAGE.matcher(this.line);
                while (macroMatcher.find()) {
                    String macroName = macroMatcher.group(1);
                    String macro = this.macros.get(macroName);
                    if (macro == null) {
                        this.error("Unknown macro '" + macroName + '\'');
                    }
                    this.line = macroMatcher.replaceAll(macro);
                }
                this.sb.append(this.line);
                if (!this.line.endsWith(";")) continue;
                this.sb.deleteCharAt(this.sb.length() - 1);
                this.queries.add(this.sb.toString());
                this.sb.setLength(0);
            }
        }
        return this.queries;
    }
}

