/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.sql.connection;

import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.Statement;
import java.util.EnumSet;
import java.util.Properties;
import java.util.Set;
import org.kingdoms.data.database.sql.DatabaseType;
import org.kingdoms.data.database.sql.H2Tools;
import org.kingdoms.data.database.sql.connection.NonClosableConnection;
import org.kingdoms.data.database.sql.connection.SQLConnectionProvider;
import org.kingdoms.dependencies.Dependency;
import org.kingdoms.dependencies.classpath.IsolatedClassLoader;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.ArraysKt;
import org.kingdoms.libs.kotlin.jdk7.AutoCloseableKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/kingdoms/data/database/sql/connection/SQLFlatFileConnectionProvider;", "Lorg/kingdoms/data/database/sql/connection/SQLConnectionProvider;", "databaseType", "Lorg/kingdoms/data/database/sql/DatabaseType;", "jdbcUrl", "", "file", "Ljava/nio/file/Path;", "<init>", "(Lorg/kingdoms/data/database/sql/DatabaseType;Ljava/lang/String;Ljava/nio/file/Path;)V", "getJdbcUrl", "()Ljava/lang/String;", "getFile", "()Ljava/nio/file/Path;", "connection", "Lorg/kingdoms/data/database/sql/connection/NonClosableConnection;", "connect", "", "getConnection", "Ljava/sql/Connection;", "close", "core"})
@SourceDebugExtension(value={"SMAP\nSQLConnectionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SQLConnectionProvider.kt\norg/kingdoms/data/database/sql/connection/SQLFlatFileConnectionProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,206:1\n1#2:207\n*E\n"})
public final class SQLFlatFileConnectionProvider
extends SQLConnectionProvider {
    @NotNull
    private final String jdbcUrl;
    @NotNull
    private final Path file;
    private NonClosableConnection connection;

    public SQLFlatFileConnectionProvider(@NotNull DatabaseType databaseType, @NotNull String jdbcUrl, @NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)((Object)databaseType), (String)"databaseType");
        Intrinsics.checkNotNullParameter((Object)jdbcUrl, (String)"jdbcUrl");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(databaseType);
        this.jdbcUrl = jdbcUrl;
        this.file = file;
        DatabaseType[] databaseTypeArray = new DatabaseType[]{DatabaseType.SQLite, DatabaseType.H2};
        if (!ArraysKt.contains((Object[])databaseTypeArray, (Object)((Object)databaseType))) {
            boolean bl = false;
            String string = "Invalid SQL type for flat file: " + (Object)((Object)databaseType);
            throw new IllegalArgumentException(string.toString());
        }
        this.testTemporaryLibCreation$core(databaseType);
    }

    @NotNull
    public final String getJdbcUrl() {
        return this.jdbcUrl;
    }

    @NotNull
    public final Path getFile() {
        return this.file;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void connect() {
        if (!(this.connection == null)) {
            boolean $i$a$-require-SQLFlatFileConnectionProvider$connect$22 = false;
            String $i$a$-require-SQLFlatFileConnectionProvider$connect$22 = "Already connected";
            throw new IllegalArgumentException($i$a$-require-SQLFlatFileConnectionProvider$connect$22.toString());
        }
        IsolatedClassLoader isolatedClassLoader = Kingdoms.get().getDependencyManager().obtainClassLoaderWith((Set<Dependency>)EnumSet.of((Enum)ArraysKt.first((Object[])this.getDatabaseType().getDependencies())));
        Intrinsics.checkNotNullExpressionValue((Object)isolatedClassLoader, (String)"obtainClassLoaderWith(...)");
        IsolatedClassLoader classLoader = isolatedClassLoader;
        try {
            Object object;
            Constructor<?> ctor;
            Object object2;
            String jdbc = this.getDatabaseType() == DatabaseType.SQLite ? "org.sqlite.jdbc4.JDBC4Connection" : "org.h2.jdbc.JdbcConnection";
            Class<?> clazz = classLoader.loadClass(jdbc);
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"loadClass(...)");
            Class<?> connectionClass = clazz;
            SQLFlatFileConnectionProvider sQLFlatFileConnectionProvider = this;
            if (this.getDatabaseType() == DatabaseType.SQLite) {
                object2 = new Class[]{String.class, String.class, Properties.class};
                ctor = connectionClass.getConstructor((Class<?>)object2);
                Object[] objectArray = new Object[]{"jdbc:sqlite:" + this.jdbcUrl, this.jdbcUrl, new Properties()};
                Object obj = ctor.newInstance(objectArray);
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type java.sql.Connection");
                object = obj;
            } else {
                object2 = new Class[]{String.class, Properties.class, String.class, Object.class, Boolean.TYPE};
                ctor = connectionClass.getConstructor((Class<?>)object2);
                SQLFlatFileConnectionProvider sQLFlatFileConnectionProvider2 = sQLFlatFileConnectionProvider;
                try {
                    sQLFlatFileConnectionProvider = sQLFlatFileConnectionProvider2;
                    String traceLvl = KLogger.isDebugging() ? ";TRACE_LEVEL_FILE=3" : "";
                    Object[] objectArray = new Object[]{"jdbc:h2:" + this.jdbcUrl + traceLvl, new Properties(), null, null, false};
                    Object obj = ctor.newInstance(objectArray);
                    Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type java.sql.Connection");
                    object2 = (Connection)obj;
                }
                catch (Throwable throwable) {
                    void ex;
                    SQLFlatFileConnectionProvider sQLFlatFileConnectionProvider3 = sQLFlatFileConnectionProvider2;
                    String string = ex.getMessage();
                    boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"corrupt", (boolean)false, (int)2, null) : false;
                    if (bl && this.getDatabaseType() == DatabaseType.H2) {
                        KLogger.error("Detected corrupted H2 database, attempting to run the recovery script...");
                        sQLFlatFileConnectionProvider2 = sQLFlatFileConnectionProvider3;
                        try {
                            sQLFlatFileConnectionProvider3 = sQLFlatFileConnectionProvider2;
                            H2Tools.recover(this.file);
                            KLogger.info("Recovery done. Please check your 'data' folder.");
                        }
                        catch (Throwable throwable2) {
                            void exx;
                            sQLFlatFileConnectionProvider3 = sQLFlatFileConnectionProvider2;
                            exx.printStackTrace();
                        }
                    }
                    throw ex;
                }
                object = object2;
            }
            Object object3 = object;
            sQLFlatFileConnectionProvider.connection = new NonClosableConnection((Connection)object3);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @NotNull
    public Connection getConnection() {
        NonClosableConnection nonClosableConnection = this.connection;
        if (nonClosableConnection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
            nonClosableConnection = null;
        }
        return nonClosableConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        NonClosableConnection nonClosableConnection;
        if (this.getDatabaseType() == DatabaseType.H2) {
            NonClosableConnection nonClosableConnection2 = this.connection;
            if (nonClosableConnection2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                nonClosableConnection2 = null;
            }
            if (!nonClosableConnection2.isClosed()) {
                NonClosableConnection nonClosableConnection3 = this.connection;
                if (nonClosableConnection3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                    nonClosableConnection3 = null;
                }
                AutoCloseable autoCloseable = nonClosableConnection3;
                Throwable throwable = null;
                try {
                    boolean bl;
                    NonClosableConnection it = (NonClosableConnection)autoCloseable;
                    boolean bl2 = false;
                    AutoCloseable autoCloseable2 = it.createStatement();
                    Throwable throwable2 = null;
                    try {
                        Statement statement = (Statement)autoCloseable2;
                        boolean bl3 = false;
                        bl = statement.execute("SHUTDOWN");
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                    }
                    boolean bl4 = bl;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
        }
        if ((nonClosableConnection = this.connection) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
            nonClosableConnection = null;
        }
        nonClosableConnection.shutdown();
    }
}

