/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.sql.connection;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.data.database.sql.DatabaseType;
import org.kingdoms.data.database.sql.connection.SQLFlatFileConnectionProvider;
import org.kingdoms.data.database.sql.connection.SQLHikariConnectionProvider;
import org.kingdoms.data.database.sql.schema.SQLSchemaProcessor;
import org.kingdoms.libs.hikari.HikariDataSource;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Unit;
import org.kingdoms.libs.kotlin.collections.ArraysKt;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jdk7.AutoCloseableKt;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.functions.Function1;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.text.Regex;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b&\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH&J\b\u0010\n\u001a\u00020\u000bH&J\b\u0010\f\u001a\u00020\u000bH&J\u0006\u0010\r\u001a\u00020\u000bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000bJ\u0015\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/kingdoms/data/database/sql/connection/SQLConnectionProvider;", "Ljava/io/Closeable;", "databaseType", "Lorg/kingdoms/data/database/sql/DatabaseType;", "<init>", "(Lorg/kingdoms/data/database/sql/DatabaseType;)V", "getDatabaseType", "()Lorg/kingdoms/data/database/sql/DatabaseType;", "getConnection", "Ljava/sql/Connection;", "connect", "", "close", "runSchema", "getMetaString", "", "printMeta", "testTemporaryLibCreation", "testTemporaryLibCreation$core", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nSQLConnectionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SQLConnectionProvider.kt\norg/kingdoms/data/database/sql/connection/SQLConnectionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,206:1\n739#2,9:207\n37#3:216\n36#3,3:217\n*S KotlinDebug\n*F\n+ 1 SQLConnectionProvider.kt\norg/kingdoms/data/database/sql/connection/SQLConnectionProvider\n*L\n58#1:207,9\n58#1:216\n58#1:217,3\n*E\n"})
public abstract class SQLConnectionProvider
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseType databaseType;
    @JvmField
    @NotNull
    public static final String TABLE_PREFIX = KingdomsConfig.DATABASE_TABLE_PREFIX.getString() + '_';

    public SQLConnectionProvider(@NotNull DatabaseType databaseType) {
        Intrinsics.checkNotNullParameter((Object)((Object)databaseType), (String)"databaseType");
        this.databaseType = databaseType;
    }

    @NotNull
    public final DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @NotNull
    public abstract Connection getConnection();

    public abstract void connect();

    @Override
    public abstract void close();

    public final void runSchema() {
        this.printMeta();
        InputStream schemaFile = Kingdoms.get().getResource("schema.sql");
        SQLSchemaProcessor.runSchema(this.databaseType, schemaFile, () -> SQLConnectionProvider.runSchema$lambda$0(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String getMetaString() {
        try {
            AutoCloseable autoCloseable = this.getConnection();
            Throwable throwable = null;
            try {
                Connection connection = (Connection)autoCloseable;
                boolean bl = false;
                DatabaseMetaData meta = connection.getMetaData();
                String string = "Running " + this.databaseType.name() + " SQL Database:\n   | Driver: " + meta.getDriverName() + " (" + meta.getCatalogTerm() + ") / " + meta.getDriverVersion() + "\n   | Product: " + meta.getDatabaseProductName() + " / " + meta.getDatabaseProductVersion() + "\n   | JDBC: " + meta.getJDBCMajorVersion() + '.' + meta.getJDBCMinorVersion();
                return string;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to retrieve meta information for SQL: " + (Object)((Object)this.databaseType), e);
        }
    }

    public final void printMeta() {
        List list;
        CharSequence charSequence = this.getMetaString();
        Regex regex = new Regex("\n");
        int n = 0;
        List $this$dropLastWhile$iv = regex.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Arrays.stream(thisCollection$iv.toArray(new String[0])).forEach(arg_0 -> SQLConnectionProvider.printMeta$lambda$4(SQLConnectionProvider::printMeta$lambda$3, arg_0));
    }

    public final void testTemporaryLibCreation$core(@NotNull DatabaseType databaseType) {
        Intrinsics.checkNotNullParameter((Object)((Object)databaseType), (String)"databaseType");
        Object object = new DatabaseType[]{DatabaseType.SQLite, DatabaseType.H2};
        if (ArraysKt.contains((Object[])object, (Object)((Object)databaseType))) {
            Object $this$testTemporaryLibCreation_u24lambda_u245 = object = new File(System.getProperty("java.io.tmpdir"));
            boolean bl = false;
            if (!(((File)$this$testTemporaryLibCreation_u24lambda_u245).exists() && ((File)$this$testTemporaryLibCreation_u24lambda_u245).isDirectory() && ((File)$this$testTemporaryLibCreation_u24lambda_u245).canRead() && ((File)$this$testTemporaryLibCreation_u24lambda_u245).canWrite())) {
                KLogger.error("A problem has occurred for with java.io.tmpdir " + ((File)$this$testTemporaryLibCreation_u24lambda_u245).exists() + " | " + ((File)$this$testTemporaryLibCreation_u24lambda_u245).isDirectory() + " | " + ((File)$this$testTemporaryLibCreation_u24lambda_u245).canRead() + " | " + ((File)$this$testTemporaryLibCreation_u24lambda_u245).canWrite());
            }
        }
    }

    private static final Connection runSchema$lambda$0(SQLConnectionProvider this$0) {
        return this$0.getConnection();
    }

    private static final Unit printMeta$lambda$3(String str) {
        KLogger.info(str);
        return Unit.INSTANCE;
    }

    private static final void printMeta$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final SQLConnectionProvider getProvider(@NotNull Path dataFolder, @NotNull DatabaseType databaseType) {
        return Companion.getProvider(dataFolder, databaseType);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/kingdoms/data/database/sql/connection/SQLConnectionProvider$Companion;", "", "<init>", "()V", "TABLE_PREFIX", "", "getProvider", "Lorg/kingdoms/data/database/sql/connection/SQLConnectionProvider;", "dataFolder", "Ljava/nio/file/Path;", "databaseType", "Lorg/kingdoms/data/database/sql/DatabaseType;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SQLConnectionProvider getProvider(@NotNull Path dataFolder, @NotNull DatabaseType databaseType) {
            SQLConnectionProvider sQLConnectionProvider;
            Intrinsics.checkNotNullParameter((Object)dataFolder, (String)"dataFolder");
            Intrinsics.checkNotNullParameter((Object)((Object)databaseType), (String)"databaseType");
            if (databaseType == DatabaseType.SQLite || databaseType == DatabaseType.H2) {
                String string = dataFolder.resolve("data").toAbsolutePath() + (databaseType == DatabaseType.H2 ? "" : ".db");
                Path path = dataFolder.resolve("data" + (databaseType == DatabaseType.H2 ? ".mv.db" : ".db"));
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                sQLConnectionProvider = new SQLFlatFileConnectionProvider(databaseType, string, path);
            } else {
                sQLConnectionProvider = new SQLHikariConnectionProvider(databaseType, new HikariDataSource());
            }
            return sQLConnectionProvider;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

