/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.sql.base;

import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import org.kingdoms.constants.base.KeyedKingdomsObject;
import org.kingdoms.constants.base.KingdomsObject;
import org.kingdoms.data.database.base.KingdomsDatabase;
import org.kingdoms.data.database.sql.DatabaseType;
import org.kingdoms.data.database.sql.SQLDataSetterProvider;
import org.kingdoms.data.database.sql.connection.SQLConnectionProvider;
import org.kingdoms.data.database.sql.statements.SQLStatement;
import org.kingdoms.data.database.sql.statements.setters.PreparedNamedSetterStatement;
import org.kingdoms.data.handlers.abstraction.DataHandler;
import org.kingdoms.data.handlers.abstraction.KeyedDataHandler;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Unit;
import org.kingdoms.libs.kotlin.jdk7.AutoCloseableKt;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.functions.Function1;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.InlineMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.utils.internal.functional.Fn;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 -*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001-B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0004J\b\u0010\u0012\u001a\u00020\u0005H\u0016J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007J\u0015\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\u001fH\u0016J5\u0010#\u001a\u0002H$\"\u0004\b\u0001\u0010$2\u0006\u0010\u0011\u001a\u00020\u00072\u0014\b\u0004\u0010%\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u0002H$0&H\u0084\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010(J5\u0010)\u001a\u0002H$\"\u0004\b\u0001\u0010$2\u0006\u0010\u0011\u001a\u00020\u00072\u0014\b\u0004\u0010%\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u0002H$0&H\u0084\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010(J\u000e\u0010)\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020+J\u000e\u0010)\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u0007J\b\u0010,\u001a\u00020\u001fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0016\u001a\u00020\u00178DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006."}, d2={"Lorg/kingdoms/data/database/sql/base/SQLDatabase;", "T", "Lorg/kingdoms/constants/base/KingdomsObject;", "Lorg/kingdoms/data/database/base/KingdomsDatabase;", "databaseType", "Lorg/kingdoms/data/database/sql/DatabaseType;", "table", "", "connectionProvider", "Lorg/kingdoms/data/database/sql/connection/SQLConnectionProvider;", "<init>", "(Lorg/kingdoms/data/database/sql/DatabaseType;Ljava/lang/String;Lorg/kingdoms/data/database/sql/connection/SQLConnectionProvider;)V", "getTable", "()Ljava/lang/String;", "getConnectionProvider", "()Lorg/kingdoms/data/database/sql/connection/SQLConnectionProvider;", "handleQuery", "query", "getDatabaseType", "columnExists", "", "column", "connection", "Ljava/sql/Connection;", "getConnection", "()Ljava/sql/Connection;", "dataHandler", "Lorg/kingdoms/data/handlers/abstraction/DataHandler;", "getDataHandler", "()Lorg/kingdoms/data/handlers/abstraction/DataHandler;", "save", "", "data", "(Lorg/kingdoms/constants/base/KingdomsObject;)V", "deleteAllData", "prepareStatement", "A", "executor", "Lorg/kingdoms/libs/kotlin/Function1;", "Ljava/sql/PreparedStatement;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "executeStatement", "Ljava/sql/ResultSet;", "Lorg/kingdoms/data/database/sql/statements/SQLStatement;", "close", "Companion", "core"})
public abstract class SQLDatabase<T extends KingdomsObject>
implements KingdomsDatabase<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseType databaseType;
    @NotNull
    private final String table;
    @NotNull
    private final SQLConnectionProvider connectionProvider;

    public SQLDatabase(@NotNull DatabaseType databaseType, @NotNull String table, @NotNull SQLConnectionProvider connectionProvider) {
        Intrinsics.checkNotNullParameter((Object)((Object)databaseType), (String)"databaseType");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)connectionProvider, (String)"connectionProvider");
        this.databaseType = databaseType;
        this.table = table;
        this.connectionProvider = connectionProvider;
    }

    @NotNull
    protected final String getTable() {
        return this.table;
    }

    @NotNull
    protected final SQLConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    @NotNull
    protected final String handleQuery(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        char sysIdEscChar = this.databaseType.getSystemIdentifierEscapeChar();
        if (sysIdEscChar != '`') {
            return StringsKt.replace$default((String)query, (char)'`', (char)sysIdEscChar, (boolean)false, (int)4, null);
        }
        return query;
    }

    @Override
    @NotNull
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean columnExists(@NotNull String column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        String query = this.handleQuery("SELECT `" + column + "` FROM `" + this.table + "` LIMIT 1");
        AutoCloseable autoCloseable = this.getConnection();
        Throwable throwable = null;
        try {
            Connection connection = (Connection)autoCloseable;
            boolean bl = false;
            try {
                AutoCloseable autoCloseable2 = connection.createStatement();
                Throwable throwable2 = null;
                try {
                    Statement ps = (Statement)autoCloseable2;
                    boolean bl2 = false;
                    boolean bl3 = ps.execute(query);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                }
                boolean bl4 = true;
                return bl4;
            }
            catch (SQLException ex) {
                boolean bl5;
                try {
                    bl5 = false;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    throw throwable5;
                }
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                return bl5;
            }
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @NotNull
    protected final Connection getConnection() {
        return this.connectionProvider.getConnection();
    }

    @NotNull
    protected abstract DataHandler<T> getDataHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(@NotNull T data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        DataHandler<T> dataHandler = this.getDataHandler();
        PreparedNamedSetterStatement ps = new PreparedNamedSetterStatement(this.databaseType, dataHandler.getSqlProperties().getAssociateNamedData());
        try {
            AutoCloseable autoCloseable = this.getConnection();
            Throwable throwable = null;
            try {
                Connection connection = (Connection)autoCloseable;
                boolean bl = false;
                SQLDataSetterProvider provider = new SQLDataSetterProvider(this.databaseType, this.table, null, false, false, ps);
                if (dataHandler instanceof KeyedDataHandler) {
                    ((KeyedDataHandler)dataHandler).getIdHandler().setSQL(ps, Fn.cast(((KeyedKingdomsObject)data).getKey()));
                } else {
                    provider.setBoolean("id", true);
                }
                dataHandler.save(provider, data);
                ps.buildStatement(this.table, connection);
                ps.execute();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException("Error while saving data " + data + " (" + data.getClass() + ')', ex);
        }
    }

    @Override
    public void deleteAllData() {
        this.executeStatement("DROP TABLE `" + this.table + '`');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final <A> A prepareStatement(@NotNull String query, @NotNull Function1<? super PreparedStatement, ? extends A> executor) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(executor, (String)"executor");
        boolean $i$f$prepareStatement = false;
        String query2 = this.handleQuery(query);
        try {
            Object object;
            AutoCloseable autoCloseable = this.getConnection();
            Throwable throwable = null;
            try {
                Object object2;
                Connection connection = (Connection)autoCloseable;
                boolean bl = false;
                AutoCloseable autoCloseable2 = connection.prepareStatement(query2);
                Throwable throwable2 = null;
                try {
                    object2 = executor.invoke((Object)autoCloseable2);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    InlineMarker.finallyStart((int)1);
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                    InlineMarker.finallyEnd((int)1);
                }
                object = object2;
            }
            catch (Throwable throwable4) {
                try {
                    throwable = throwable4;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    InlineMarker.finallyStart((int)1);
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    InlineMarker.finallyEnd((int)1);
                    throw throwable5;
                }
            }
            InlineMarker.finallyStart((int)2);
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            InlineMarker.finallyEnd((int)2);
            return (A)object;
        }
        catch (Throwable ex) {
            throw new RuntimeException("Error while handling data with query: " + query2 + " with " + this.connectionProvider.getMetaString(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected final <A> A executeStatement(@NotNull String query, @NotNull Function1<? super ResultSet, ? extends A> executor) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(executor, (String)"executor");
        boolean $i$f$executeStatement = false;
        String query2 = this.handleQuery(query);
        try {
            Object object;
            AutoCloseable autoCloseable = this.getConnection();
            Throwable throwable = null;
            Connection connection = (Connection)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = connection.createStatement();
            Throwable throwable2 = null;
            Statement ps = (Statement)autoCloseable2;
            boolean bl2 = false;
            AutoCloseable autoCloseable3 = ps.executeQuery(query2);
            Throwable throwable3 = null;
            try {
                object = executor.invoke((Object)autoCloseable3);
            }
            catch (Throwable throwable4) {
                throwable3 = throwable4;
                throw throwable4;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable3, (Throwable)throwable3);
                InlineMarker.finallyEnd((int)1);
            }
            Object object2 = object;
            InlineMarker.finallyStart((int)2);
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            InlineMarker.finallyEnd((int)2);
            Object object3 = object2;
            InlineMarker.finallyStart((int)2);
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            InlineMarker.finallyEnd((int)2);
            return (A)object3;
            {
                catch (Throwable throwable5) {
                    try {
                        try {
                            try {
                                throwable2 = throwable5;
                                throw throwable5;
                            }
                            catch (Throwable throwable6) {
                                InlineMarker.finallyStart((int)1);
                                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                                InlineMarker.finallyEnd((int)1);
                                throw throwable6;
                            }
                        }
                        catch (Throwable throwable7) {
                            throwable = throwable7;
                            throw throwable7;
                        }
                    }
                    catch (Throwable throwable8) {
                        InlineMarker.finallyStart((int)1);
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                        InlineMarker.finallyEnd((int)1);
                        throw throwable8;
                    }
                }
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException("Error while handling data with query: " + query2 + " with " + this.connectionProvider.getMetaString(), ex);
        }
    }

    public final void executeStatement(@NotNull SQLStatement query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        this.executeStatement(this.databaseType.createStatement(query, this.table));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void executeStatement(@NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        String query2 = this.handleQuery(query);
        try {
            AutoCloseable autoCloseable = this.getConnection();
            Throwable throwable = null;
            try {
                boolean bl;
                Connection connection = (Connection)autoCloseable;
                boolean bl2 = false;
                AutoCloseable autoCloseable2 = connection.createStatement();
                Throwable throwable2 = null;
                try {
                    Statement ps = (Statement)autoCloseable2;
                    boolean bl3 = false;
                    bl = ps.execute(query2);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                }
                boolean bl4 = bl;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException("Error while handling data with query: " + query2 + " with " + this.connectionProvider.getMetaString(), ex);
        }
    }

    @Override
    public void close() {
        this.connectionProvider.close();
    }

    @JvmStatic
    @Nullable
    public static final byte[] asBytes(@Nullable UUID uuid) {
        return Companion.asBytes(uuid);
    }

    @JvmStatic
    @Nullable
    public static final UUID asUUID(@Nullable byte[] bytes) {
        return Companion.asUUID(bytes);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u0014\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u0005H\u0007\u00a8\u0006\n"}, d2={"Lorg/kingdoms/data/database/sql/base/SQLDatabase$Companion;", "", "<init>", "()V", "asBytes", "", "uuid", "Ljava/util/UUID;", "asUUID", "bytes", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final byte[] asBytes(@Nullable UUID uuid) {
            if (uuid == null) {
                return null;
            }
            ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
            bb.putLong(uuid.getMostSignificantBits());
            bb.putLong(uuid.getLeastSignificantBits());
            return bb.array();
        }

        @JvmStatic
        @Nullable
        public final UUID asUUID(@Nullable byte[] bytes) {
            if (bytes == null) {
                return null;
            }
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            long firstLong = bb.getLong();
            long secondLong = bb.getLong();
            return new UUID(firstLong, secondLong);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

