/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.sql;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.bukkit.Location;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.data.database.dataprovider.DataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.flatfile.json.JsonElementDataProvider;
import org.kingdoms.data.database.flatfile.json.JsonObjectDataProvider;
import org.kingdoms.data.database.sql.DatabaseType;
import org.kingdoms.data.database.sql.SQLDataProvider;
import org.kingdoms.data.database.sql.SQLDataProviderKt;
import org.kingdoms.data.database.sql.statements.getters.SimpleResultSetQuery;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.functions.Function0;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.platform.bukkit.location.BukkitWorld;
import org.kingdoms.utils.gson.KingdomsGson;
import org.kingdoms.utils.internal.functional.TriConsumer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0002H\u0016J\b\u0010\u0010\u001a\u00020\u0002H\u0016J\u0011\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0006H\u0096\u0002J&\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u001a\u0010\u0013\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0014j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0006`\u0015H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J \u0010\u001e\u001a\u00020\u001f2\u0016\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u001f0\u0014j\b\u0012\u0004\u0012\u00020\u001f`\u0015H\u0016J \u0010 \u001a\u00020!2\u0016\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020!0\u0014j\b\u0012\u0004\u0012\u00020!`\u0015H\u0016J \u0010\"\u001a\u00020#2\u0016\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020#0\u0014j\b\u0012\u0004\u0012\u00020#`\u0015H\u0016J \u0010$\u001a\u00020%2\u0016\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020%0\u0014j\b\u0012\u0004\u0012\u00020%`\u0015H\u0016J \u0010&\u001a\u00020\t2\u0016\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\t0\u0014j\b\u0012\u0004\u0012\u00020\t`\u0015H\u0016J?\u0010'\u001a\u0002H(\"\u0004\b\u0000\u0010)\"\u000e\b\u0001\u0010(*\b\u0012\u0004\u0012\u0002H)0*2\u0006\u0010+\u001a\u0002H(2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u0002H(\u0012\u0004\u0012\u00020\u00020-H\u0016\u00a2\u0006\u0002\u0010.JQ\u0010/\u001a\u0002H0\"\u0004\b\u0000\u00101\"\u0004\b\u0001\u0010)\"\u0014\b\u0002\u00100*\u000e\u0012\u0004\u0012\u0002H1\u0012\u0004\u0012\u0002H)022\u0006\u00103\u001a\u0002H02\u0018\u00104\u001a\u0014\u0012\u0004\u0012\u0002H0\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020\u000205H\u0016\u00a2\u0006\u0002\u00107R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/kingdoms/data/database/sql/SQLDataGetterProvider;", "Lorg/kingdoms/data/database/sql/SQLDataProvider;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataGetter;", "databaseType", "Lorg/kingdoms/data/database/sql/DatabaseType;", "table", "", "name", "isInsideSingularEntity", "", "nameIsSection", "statement", "Lorg/kingdoms/data/database/sql/statements/getters/SimpleResultSetQuery;", "<init>", "(Lorg/kingdoms/data/database/sql/DatabaseType;Ljava/lang/String;Ljava/lang/String;ZZLorg/kingdoms/data/database/sql/statements/getters/SimpleResultSetQuery;)V", "asSection", "asDynamicSection", "get", "asString", "default", "Lorg/kingdoms/libs/kotlin/Function0;", "Lorg/kingdoms/data/database/dataprovider/Supply;", "asUUID", "Ljava/util/UUID;", "asSimpleLocation", "Lorg/kingdoms/constants/land/location/SimpleLocation;", "asSimpleChunkLocation", "Lorg/kingdoms/constants/land/location/SimpleChunkLocation;", "asLocation", "Lorg/bukkit/Location;", "asInt", "", "asLong", "", "asFloat", "", "asDouble", "", "asBoolean", "asCollection", "C", "V", "", "collection", "elementHandler", "Ljava/util/function/BiConsumer;", "(Ljava/util/Collection;Ljava/util/function/BiConsumer;)Ljava/util/Collection;", "asMap", "M", "K", "", "map", "handler", "Lorg/kingdoms/utils/internal/functional/TriConsumer;", "Lorg/kingdoms/data/database/dataprovider/DataGetter;", "(Ljava/util/Map;Lorg/kingdoms/utils/internal/functional/TriConsumer;)Ljava/util/Map;", "core"})
public final class SQLDataGetterProvider
extends SQLDataProvider
implements SectionableDataGetter {
    @NotNull
    private final SimpleResultSetQuery statement;

    public SQLDataGetterProvider(@NotNull DatabaseType databaseType, @NotNull String table, @Nullable String name, boolean isInsideSingularEntity, boolean nameIsSection, @NotNull SimpleResultSetQuery statement) {
        Intrinsics.checkNotNullParameter((Object)((Object)databaseType), (String)"databaseType");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        super(databaseType, table, name, isInsideSingularEntity, nameIsSection);
        this.statement = statement;
    }

    @Override
    @NotNull
    public SectionableDataGetter asSection() {
        return new SQLDataGetterProvider(this.getDatabaseType$core(), this.getTable$core(), this.getName$core(), false, true, this.statement);
    }

    @Override
    @NotNull
    public SectionableDataGetter asDynamicSection() {
        String string = this.statement.getString(this.getNamed$core());
        if (string == null) {
            return new JsonObjectDataProvider(null, SQLDataProviderKt.access$getEMPTY_JSON_OBJECT$p());
        }
        String str = string;
        JsonElement jsonElement = KingdomsGson.fromString(str);
        Intrinsics.checkNotNull((Object)jsonElement, (String)"null cannot be cast to non-null type com.google.gson.JsonObject");
        JsonObject obj = (JsonObject)jsonElement;
        return new JsonObjectDataProvider(null, obj);
    }

    @Override
    @NotNull
    public SectionableDataGetter get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.getName$core() != null && !this.getNameIsSection$core()) {
            throw new IllegalStateException("Attempting to get() without specifying the previous ones type: " + this.getTable$core() + " -> " + this.getName$core() + " -> " + name);
        }
        return new SQLDataGetterProvider(this.getDatabaseType$core(), this.getTable$core(), this.nameSepOrEmpty$core() + name, false, false, this.statement);
    }

    @Override
    @Nullable
    public String asString(@NotNull Function0<String> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"default");
        String string = this.statement.getString(this.getNamed$core());
        if (string == null) {
            string = (String)function0.invoke();
        }
        return string;
    }

    @Override
    @Nullable
    public UUID asUUID() {
        return this.statement.getUUID(this.getNamed$core());
    }

    @Override
    @Nullable
    public SimpleLocation asSimpleLocation() {
        SectionableDataGetter $this$asSimpleLocation_u24lambda_u240 = this.asSection();
        boolean bl = false;
        String string = $this$asSimpleLocation_u24lambda_u240.getString("world");
        if (string == null) {
            return null;
        }
        return new SimpleLocation(string, $this$asSimpleLocation_u24lambda_u240.getInt("x"), $this$asSimpleLocation_u24lambda_u240.getInt("y"), $this$asSimpleLocation_u24lambda_u240.getInt("z"));
    }

    @Override
    @NotNull
    public SimpleChunkLocation asSimpleChunkLocation() {
        SectionableDataGetter $this$asSimpleChunkLocation_u24lambda_u241 = this.asSection();
        boolean bl = false;
        String string = $this$asSimpleChunkLocation_u24lambda_u241.getString("world");
        Intrinsics.checkNotNull((Object)string);
        return new SimpleChunkLocation(string, $this$asSimpleChunkLocation_u24lambda_u241.getInt("x"), $this$asSimpleChunkLocation_u24lambda_u241.getInt("z"));
    }

    @Override
    @Nullable
    public Location asLocation() {
        SectionableDataGetter $this$asLocation_u24lambda_u242 = this.asSection();
        boolean bl = false;
        String string = $this$asLocation_u24lambda_u242.getString("world");
        if (string == null) {
            return null;
        }
        String world = string;
        return new Location(BukkitWorld.Companion.getWorld(world, (Object)$this$asLocation_u24lambda_u242), $this$asLocation_u24lambda_u242.getDouble("x"), $this$asLocation_u24lambda_u242.getDouble("y"), $this$asLocation_u24lambda_u242.getDouble("z"), $this$asLocation_u24lambda_u242.getFloat("yaw"), $this$asLocation_u24lambda_u242.getFloat("pitch"));
    }

    @Override
    public int asInt(@NotNull Function0<Integer> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"default");
        int result = this.statement.getInt(this.getNamed$core());
        boolean wasNull = this.statement.wasNull();
        return wasNull ? ((Number)function0.invoke()).intValue() : result;
    }

    @Override
    public long asLong(@NotNull Function0<Long> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"default");
        long result = this.statement.getLong(this.getNamed$core());
        boolean wasNull = this.statement.wasNull();
        return wasNull ? ((Number)function0.invoke()).longValue() : result;
    }

    @Override
    public float asFloat(@NotNull Function0<Float> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"default");
        float result = this.statement.getFloat(this.getNamed$core());
        boolean wasNull = this.statement.wasNull();
        return wasNull ? ((Number)function0.invoke()).floatValue() : result;
    }

    @Override
    public double asDouble(@NotNull Function0<Double> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"default");
        double result = this.statement.getDouble(this.getNamed$core());
        boolean wasNull = this.statement.wasNull();
        return wasNull ? ((Number)function0.invoke()).doubleValue() : result;
    }

    @Override
    public boolean asBoolean(@NotNull Function0<Boolean> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"default");
        boolean result = this.statement.getBoolean(this.getNamed$core());
        boolean wasNull = this.statement.wasNull();
        return wasNull ? (Boolean)function0.invoke() : result;
    }

    @Override
    @NotNull
    public <V, C extends Collection<V>> C asCollection(@NotNull C collection, @NotNull BiConsumer<C, SectionableDataGetter> elementHandler) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        Intrinsics.checkNotNullParameter(elementHandler, (String)"elementHandler");
        String string = this.statement.getString(this.getNamed$core());
        if (string == null) {
            return collection;
        }
        String str = string;
        JsonElement jsonElement = KingdomsGson.fromString(str);
        Intrinsics.checkNotNull((Object)jsonElement, (String)"null cannot be cast to non-null type com.google.gson.JsonArray");
        JsonArray array = (JsonArray)jsonElement;
        Iterator iterator = array.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            JsonElement element = (JsonElement)iterator2.next();
            Intrinsics.checkNotNull((Object)element);
            elementHandler.accept(collection, new JsonElementDataProvider(element));
        }
        return collection;
    }

    @Override
    @NotNull
    public <K, V, M extends Map<K, V>> M asMap(@NotNull M map, @NotNull TriConsumer<M, DataGetter, SectionableDataGetter> handler) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        String string = this.statement.getString(this.getNamed$core());
        if (string == null) {
            return map;
        }
        String str = string;
        JsonElement jsonElement = KingdomsGson.fromString(str);
        Intrinsics.checkNotNull((Object)jsonElement, (String)"null cannot be cast to non-null type com.google.gson.JsonObject");
        JsonObject obj = (JsonObject)jsonElement;
        for (Map.Entry entry : obj.entrySet()) {
            Intrinsics.checkNotNull((Object)entry);
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            JsonElementDataProvider jsonElementDataProvider = new JsonElementDataProvider((JsonElement)new JsonPrimitive(key));
            Intrinsics.checkNotNull((Object)value);
            handler.accept(map, jsonElementDataProvider, new JsonElementDataProvider(value));
        }
        return map;
    }
}

