/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.nbt;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.bukkit.Location;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.data.database.dataprovider.DataGetter;
import org.kingdoms.data.database.dataprovider.DataProvider;
import org.kingdoms.data.database.dataprovider.MappingSetterHandler;
import org.kingdoms.data.database.dataprovider.SectionCreatableDataSetter;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.data.database.dataprovider.StringMappedIdSetter;
import org.kingdoms.data.database.nbt.NBTDataProvider;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.functions.Function0;
import org.kingdoms.libs.kotlin.jvm.functions.Function1;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.nbt.tag.NBTTag;
import org.kingdoms.nbt.tag.NBTTagCompound;
import org.kingdoms.nbt.tag.NBTTagList;
import org.kingdoms.nbt.tag.NBTTagType;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.internal.functional.Fn;
import org.kingdoms.utils.internal.functional.TriConsumer;
import org.kingdoms.utils.internal.uuid.FastUUID;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 R2\u00020\u00012\u00020\u0002:\u0001RB\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0011\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0001H\u0016J&\u0010\u0017\u001a\u0004\u0018\u00010\u00042\u001a\u0010\u0018\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0019j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0004`\u001aH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\n\u0010!\u001a\u0004\u0018\u00010\"H\u0016J \u0010#\u001a\u00020$2\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020$0\u0019j\b\u0012\u0004\u0012\u00020$`\u001aH\u0016J \u0010%\u001a\u00020&2\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020&0\u0019j\b\u0012\u0004\u0012\u00020&`\u001aH\u0016J \u0010'\u001a\u00020(2\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020(0\u0019j\b\u0012\u0004\u0012\u00020(`\u001aH\u0016J \u0010)\u001a\u00020*2\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020*0\u0019j\b\u0012\u0004\u0012\u00020*`\u001aH\u0016J \u0010+\u001a\u00020,2\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020,0\u0019j\b\u0012\u0004\u0012\u00020,`\u001aH\u0016J?\u0010-\u001a\u0002H.\"\u0004\b\u0000\u0010/\"\u000e\b\u0001\u0010.*\b\u0012\u0004\u0012\u0002H/002\u0006\u00101\u001a\u0002H.2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u0002H.\u0012\u0004\u0012\u00020403H\u0016\u00a2\u0006\u0002\u00105JQ\u00106\u001a\u0002H7\"\u0004\b\u0000\u00108\"\u0004\b\u0001\u0010/\"\u0014\b\u0002\u00107*\u000e\u0012\u0004\u0012\u0002H8\u0012\u0004\u0012\u0002H/092\u0006\u0010:\u001a\u0002H72\u0018\u0010;\u001a\u0014\u0012\u0004\u0012\u0002H7\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u0002040<H\u0016\u00a2\u0006\u0002\u0010>J\u0012\u0010?\u001a\u00020@2\b\u0010A\u001a\u0004\u0018\u00010\u0004H\u0016J\u0012\u0010B\u001a\u00020@2\b\u0010A\u001a\u0004\u0018\u00010\u001eH\u0016J\u0010\u0010C\u001a\u00020@2\u0006\u0010A\u001a\u00020 H\u0016J\u0012\u0010D\u001a\u00020@2\b\u0010A\u001a\u0004\u0018\u00010\u001cH\u0016J\u0010\u0010E\u001a\u00020@2\u0006\u0010A\u001a\u00020$H\u0016J\u0010\u0010F\u001a\u00020@2\u0006\u0010A\u001a\u00020&H\u0016J\u0010\u0010G\u001a\u00020@2\u0006\u0010A\u001a\u00020(H\u0016J\u0010\u0010H\u001a\u00020@2\u0006\u0010A\u001a\u00020*H\u0016J\u0010\u0010I\u001a\u00020@2\u0006\u0010A\u001a\u00020,H\u0016J\u0012\u0010J\u001a\u00020@2\b\u0010A\u001a\u0004\u0018\u00010\"H\u0016J0\u0010K\u001a\u00020@\"\u0004\b\u0000\u0010/2\f\u00101\u001a\b\u0012\u0004\u0012\u0002H/0L2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H/03H\u0016J<\u0010M\u001a\u00020@\"\u0004\b\u0000\u00108\"\u0004\b\u0001\u0010/2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u0002H8\u0012\u0004\u0012\u0002H/0N2\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u0002H8\u0012\u0004\u0012\u0002H/0OH\u0016J\b\u0010P\u001a\u00020QH\u0016J\u0010\u0010P\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u0014\u0010\u0013\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\n\u00a8\u0006S"}, d2={"Lorg/kingdoms/data/database/nbt/NamedNBTDataProvider;", "Lorg/kingdoms/data/database/dataprovider/DataProvider;", "Lorg/kingdoms/data/database/dataprovider/SectionCreatableDataSetter;", "name", "", "obj", "Lorg/kingdoms/nbt/tag/NBTTagCompound;", "<init>", "(Ljava/lang/String;Lorg/kingdoms/nbt/tag/NBTTagCompound;)V", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "getObj", "()Lorg/kingdoms/nbt/tag/NBTTagCompound;", "setObj", "(Lorg/kingdoms/nbt/tag/NBTTagCompound;)V", "section", "getSection", "verifiedName", "getVerifiedName", "get", "asSection", "asString", "default", "Lorg/kingdoms/libs/kotlin/Function0;", "Lorg/kingdoms/data/database/dataprovider/Supply;", "asUUID", "Ljava/util/UUID;", "asSimpleLocation", "Lorg/kingdoms/constants/land/location/SimpleLocation;", "asSimpleChunkLocation", "Lorg/kingdoms/constants/land/location/SimpleChunkLocation;", "asLocation", "Lorg/bukkit/Location;", "asInt", "", "asLong", "", "asFloat", "", "asDouble", "", "asBoolean", "", "asCollection", "C", "V", "", "collection", "elementHandler", "Ljava/util/function/BiConsumer;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataGetter;", "(Ljava/util/Collection;Ljava/util/function/BiConsumer;)Ljava/util/Collection;", "asMap", "M", "K", "", "map", "handler", "Lorg/kingdoms/utils/internal/functional/TriConsumer;", "Lorg/kingdoms/data/database/dataprovider/DataGetter;", "(Ljava/util/Map;Lorg/kingdoms/utils/internal/functional/TriConsumer;)Ljava/util/Map;", "setString", "", "value", "setSimpleLocation", "setSimpleChunkLocation", "setUUID", "setInt", "setLong", "setFloat", "setDouble", "setBoolean", "setLocation", "setCollection", "", "setMap", "", "Lorg/kingdoms/data/database/dataprovider/MappingSetterHandler;", "createSection", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nNamedNBTDataProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NamedNBTDataProvider.kt\norg/kingdoms/data/database/nbt/NamedNBTDataProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1#2:142\n*E\n"})
public final class NamedNBTDataProvider
implements DataProvider,
SectionCreatableDataSetter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String name;
    @NotNull
    private NBTTagCompound obj;

    public NamedNBTDataProvider(@Nullable String name, @NotNull NBTTagCompound obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        this.name = name;
        this.obj = obj;
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    public final void setName(@Nullable String string) {
        this.name = string;
    }

    @NotNull
    public final NBTTagCompound getObj() {
        return this.obj;
    }

    public final void setObj(@NotNull NBTTagCompound nBTTagCompound) {
        Intrinsics.checkNotNullParameter((Object)nBTTagCompound, (String)"<set-?>");
        this.obj = nBTTagCompound;
    }

    private final NBTTagCompound getSection() {
        return this.name == null ? this.obj : this.obj.getCompound(this.name);
    }

    private final String getVerifiedName() {
        String string = this.name;
        if (string == null) {
            throw new IllegalStateException("No key name set");
        }
        return string;
    }

    @Override
    @NotNull
    public DataProvider get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new NamedNBTDataProvider(name, this.obj);
    }

    @Override
    @NotNull
    public DataProvider asSection() {
        NBTTagCompound nBTTagCompound = this.getSection();
        if (nBTTagCompound == null) {
            NBTTagCompound nBTTagCompound2 = NBTTagCompound.empty();
            nBTTagCompound = nBTTagCompound2;
            Intrinsics.checkNotNullExpressionValue((Object)nBTTagCompound2, (String)"empty(...)");
        }
        return new NamedNBTDataProvider(null, nBTTagCompound);
    }

    @Override
    @Nullable
    public String asString(@NotNull Function0<String> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"default");
        String string = (String)this.obj.get(this.getVerifiedName(), NBTTagType.STRING);
        if (string == null) {
            string = (String)function0.invoke();
        }
        return string;
    }

    @Override
    @Nullable
    public UUID asUUID() {
        UUID uUID;
        String string = this.asString();
        if (string != null) {
            String it = string;
            boolean bl = false;
            uUID = FastUUID.fromString(it);
        } else {
            uUID = null;
        }
        return uUID;
    }

    @Override
    @Nullable
    public SimpleLocation asSimpleLocation() {
        SimpleLocation simpleLocation;
        String string = this.asString();
        if (string != null) {
            String it = string;
            boolean bl = false;
            simpleLocation = SimpleLocation.fromString(it);
        } else {
            simpleLocation = null;
        }
        return simpleLocation;
    }

    @Override
    @NotNull
    public SimpleChunkLocation asSimpleChunkLocation() {
        String string = this.asString();
        Intrinsics.checkNotNull((Object)string);
        SimpleChunkLocation simpleChunkLocation = SimpleChunkLocation.fromString(string);
        Intrinsics.checkNotNullExpressionValue((Object)simpleChunkLocation, (String)"fromString(...)");
        return simpleChunkLocation;
    }

    @Override
    @Nullable
    public Location asLocation() {
        Location location;
        String string = this.asString();
        if (string != null) {
            String it = string;
            boolean bl = false;
            location = LocationUtils.fromString(it);
        } else {
            location = null;
        }
        return location;
    }

    @Override
    public int asInt(@NotNull Function0<Integer> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"default");
        Integer n = (Integer)this.obj.get(this.getVerifiedName(), NBTTagType.INT);
        return n != null ? n.intValue() : ((Number)function0.invoke()).intValue();
    }

    @Override
    public long asLong(@NotNull Function0<Long> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"default");
        Long l = (Long)this.obj.get(this.getVerifiedName(), NBTTagType.LONG);
        return l != null ? l.longValue() : ((Number)function0.invoke()).longValue();
    }

    @Override
    public float asFloat(@NotNull Function0<Float> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"default");
        Float f = (Float)this.obj.get(this.getVerifiedName(), NBTTagType.FLOAT);
        return f != null ? f.floatValue() : ((Number)function0.invoke()).floatValue();
    }

    @Override
    public double asDouble(@NotNull Function0<Double> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"default");
        Double d = (Double)this.obj.get(this.getVerifiedName(), NBTTagType.DOUBLE);
        return d != null ? d.doubleValue() : ((Number)function0.invoke()).doubleValue();
    }

    @Override
    public boolean asBoolean(@NotNull Function0<Boolean> function0) {
        boolean bl;
        Intrinsics.checkNotNullParameter(function0, (String)"default");
        Byte by = (Byte)this.obj.get(this.getVerifiedName(), NBTTagType.BOOL);
        if (by != null) {
            byte it = ((Number)by).byteValue();
            boolean bl2 = false;
            bl = it != 0;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public <V, C extends Collection<V>> C asCollection(@NotNull C collection, @NotNull BiConsumer<C, SectionableDataGetter> elementHandler) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        Intrinsics.checkNotNullParameter(elementHandler, (String)"elementHandler");
        List list = (List)this.obj.get(this.getVerifiedName(), (NBTTagType)Fn.cast(NBTTagType.LIST));
        if (list == null) {
            return collection;
        }
        List array = list;
        for (NBTTag element : array) {
            elementHandler.accept(collection, Companion.createProvider$core(element));
        }
        return collection;
    }

    @Override
    @NotNull
    public <K, V, M extends Map<K, V>> M asMap(@NotNull M map, @NotNull TriConsumer<M, DataGetter, SectionableDataGetter> handler) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        NBTTagCompound nBTTagCompound = this.getSection();
        if (nBTTagCompound == null) {
            return map;
        }
        NBTTagCompound newObj = nBTTagCompound;
        Object object = newObj.value();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value(...)");
        for (Map.Entry entry : object.entrySet()) {
            String key = (String)entry.getKey();
            NBTTag value = (NBTTag)entry.getValue();
            Intrinsics.checkNotNull((Object)key);
            Object obj = NBTTagType.Companion.fromJava(key).construct(key);
            Intrinsics.checkNotNull(obj);
            NBTDataProvider nBTDataProvider = new NBTDataProvider((NBTTag<?>)obj);
            Intrinsics.checkNotNull((Object)value);
            handler.accept(map, nBTDataProvider, Companion.createProvider$core(value));
        }
        return map;
    }

    @Override
    public void setString(@Nullable String value) {
        if (value != null) {
            this.obj.set(this.getVerifiedName(), value);
        }
    }

    @Override
    public void setSimpleLocation(@Nullable SimpleLocation value) {
        SimpleLocation simpleLocation = value;
        this.setString(simpleLocation != null ? simpleLocation.asDataString() : null);
    }

    @Override
    public void setSimpleChunkLocation(@NotNull SimpleChunkLocation value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.setString(value.asDataString());
    }

    @Override
    public void setUUID(@Nullable UUID value) {
        if (value != null) {
            this.obj.set(this.getVerifiedName(), FastUUID.toString(value));
        }
    }

    @Override
    public void setInt(int value) {
        this.obj.set(this.getVerifiedName(), value);
    }

    @Override
    public void setLong(long value) {
        this.obj.set(this.getVerifiedName(), value);
    }

    @Override
    public void setFloat(float value) {
        this.obj.set(this.getVerifiedName(), value);
    }

    @Override
    public void setDouble(double value) {
        this.obj.set(this.getVerifiedName(), value);
    }

    @Override
    public void setBoolean(boolean value) {
        this.obj.set(this.getVerifiedName(), value);
    }

    @Override
    public void setLocation(@Nullable Location value) {
        if (value == null) {
            return;
        }
        this.setString(LocationUtils.toString(value));
    }

    @Override
    public <V> void setCollection(@NotNull Collection<? extends V> collection, @NotNull BiConsumer<SectionCreatableDataSetter, V> elementHandler) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        Intrinsics.checkNotNullParameter(elementHandler, (String)"elementHandler");
        if (collection.isEmpty()) {
            return;
        }
        NBTTagList<?> nBTTagList = NBTTagList.unknownEmpty();
        Intrinsics.checkNotNullExpressionValue(nBTTagList, (String)"unknownEmpty(...)");
        NBTTagList<?> array = nBTTagList;
        for (V element : collection) {
            elementHandler.accept(Companion.createProvider$core((NBTTag)array), element);
        }
        Object object = array.value();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value(...)");
        if (!((Collection)object).isEmpty()) {
            this.obj.set(this.getVerifiedName(), (NBTTag)array);
        }
    }

    @Override
    public <K, V> void setMap(@NotNull Map<K, ? extends V> map, @NotNull MappingSetterHandler<K, V> handler) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        if (map.isEmpty()) {
            return;
        }
        NBTTagCompound nBTTagCompound = NBTTagCompound.empty();
        Intrinsics.checkNotNullExpressionValue((Object)nBTTagCompound, (String)"empty(...)");
        NBTTagCompound compound = nBTTagCompound;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            handler.map(key, new StringMappedIdSetter((Function1<? super String, ? extends SectionCreatableDataSetter>)((Function1)arg_0 -> NamedNBTDataProvider.setMap$lambda$4(compound, arg_0))), value);
        }
        Object object = compound.value();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value(...)");
        if (!object.isEmpty()) {
            this.obj.set(this.getVerifiedName(), (NBTTag)compound);
        }
    }

    @Override
    @NotNull
    public SectionableDataSetter createSection() {
        NBTTagCompound nBTTagCompound = NBTTagCompound.empty();
        Intrinsics.checkNotNullExpressionValue((Object)nBTTagCompound, (String)"empty(...)");
        NBTTagCompound obj = nBTTagCompound;
        String string = this.name;
        Intrinsics.checkNotNull((Object)string);
        this.obj.set(string, (NBTTag)obj);
        return new NamedNBTDataProvider(null, obj);
    }

    @Override
    @NotNull
    public DataProvider createSection(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.name != null) {
            throw new IllegalStateException("Previous name not handled: " + this.name + " -> " + name);
        }
        NBTTagCompound nBTTagCompound = NBTTagCompound.empty();
        Intrinsics.checkNotNullExpressionValue((Object)nBTTagCompound, (String)"empty(...)");
        NBTTagCompound obj = nBTTagCompound;
        this.obj.set(name, (NBTTag)obj);
        return new NamedNBTDataProvider(null, obj);
    }

    private static final SectionCreatableDataSetter setMap$lambda$4(NBTTagCompound $compound, String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return new NamedNBTDataProvider(id, $compound);
    }

    @JvmStatic
    @NotNull
    public static final DataProvider createProvider$core(@NotNull NBTTag<?> value) {
        return Companion.createProvider$core(value);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0001\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/kingdoms/data/database/nbt/NamedNBTDataProvider$Companion;", "", "<init>", "()V", "createProvider", "Lorg/kingdoms/data/database/dataprovider/DataProvider;", "value", "Lorg/kingdoms/nbt/tag/NBTTag;", "createProvider$core", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DataProvider createProvider$core(@NotNull NBTTag<?> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            return value instanceof NBTTagCompound ? (DataProvider)new NamedNBTDataProvider(null, (NBTTagCompound)value) : (DataProvider)new NBTDataProvider(value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

