/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.nbt;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.bukkit.Location;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.data.database.dataprovider.DataGetter;
import org.kingdoms.data.database.dataprovider.DataProvider;
import org.kingdoms.data.database.dataprovider.MappingSetterHandler;
import org.kingdoms.data.database.dataprovider.SectionCreatableDataSetter;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.data.database.nbt.NamedNBTDataProvider;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.KotlinNothingValueException;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.functions.Function0;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.nbt.tag.NBTTag;
import org.kingdoms.nbt.tag.NBTTagBool;
import org.kingdoms.nbt.tag.NBTTagCompound;
import org.kingdoms.nbt.tag.NBTTagDouble;
import org.kingdoms.nbt.tag.NBTTagFloat;
import org.kingdoms.nbt.tag.NBTTagInt;
import org.kingdoms.nbt.tag.NBTTagList;
import org.kingdoms.nbt.tag.NBTTagLong;
import org.kingdoms.nbt.tag.NBTTagString;
import org.kingdoms.nbt.tag.NBTTagType;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.internal.functional.TriConsumer;
import org.kingdoms.utils.internal.uuid.FastUUID;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u0013\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\t\u001a\u00020\fH\u0016J\u0011\u0010\r\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0002J\b\u0010\u000e\u001a\u00020\u0001H\u0016J&\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\u001a\u0010\u0010\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0011j\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b`\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J \u0010\u001b\u001a\u00020\u001c2\u0016\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u001c0\u0011j\b\u0012\u0004\u0012\u00020\u001c`\u0012H\u0016J \u0010\u001d\u001a\u00020\u001e2\u0016\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u001e0\u0011j\b\u0012\u0004\u0012\u00020\u001e`\u0012H\u0016J \u0010\u001f\u001a\u00020 2\u0016\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020 0\u0011j\b\u0012\u0004\u0012\u00020 `\u0012H\u0016J \u0010!\u001a\u00020\"2\u0016\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\"0\u0011j\b\u0012\u0004\u0012\u00020\"`\u0012H\u0016J \u0010#\u001a\u00020$2\u0016\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020$0\u0011j\b\u0012\u0004\u0012\u00020$`\u0012H\u0016J?\u0010%\u001a\u0002H&\"\u0004\b\u0000\u0010'\"\u000e\b\u0001\u0010&*\b\u0012\u0004\u0012\u0002H'0(2\u0006\u0010)\u001a\u0002H&2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u0002H&\u0012\u0004\u0012\u00020,0+H\u0016\u00a2\u0006\u0002\u0010-JQ\u0010.\u001a\u0002H/\"\u0004\b\u0000\u00100\"\u0004\b\u0001\u0010'\"\u0014\b\u0002\u0010/*\u000e\u0012\u0004\u0012\u0002H0\u0012\u0004\u0012\u0002H'012\u0006\u00102\u001a\u0002H/2\u0018\u00103\u001a\u0014\u0012\u0004\u0012\u0002H/\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020,04H\u0016\u00a2\u0006\u0002\u00106J\u0012\u0010;\u001a\u00020<2\b\u0010=\u001a\u0004\u0018\u00010\u0016H\u0016J\u0010\u0010>\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0018H\u0016J\u0010\u0010?\u001a\u00020<2\u0006\u0010=\u001a\u00020\u001eH\u0016J\u0012\u0010@\u001a\u00020<2\b\u0010=\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010A\u001a\u00020<2\u0006\u0010=\u001a\u00020\u001cH\u0016J\u0010\u0010B\u001a\u00020<2\u0006\u0010=\u001a\u00020 H\u0016J\u0010\u0010C\u001a\u00020<2\u0006\u0010=\u001a\u00020\"H\u0016J\u0010\u0010D\u001a\u00020<2\u0006\u0010=\u001a\u00020$H\u0016J0\u0010E\u001a\u000208\"\u0004\b\u0000\u0010'2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H'0F2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H'0+H\u0016J<\u0010G\u001a\u000208\"\u0004\b\u0000\u00100\"\u0004\b\u0001\u0010'2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u0002H0\u0012\u0004\u0012\u0002H'0H2\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u0002H0\u0012\u0004\u0012\u0002H'0IH\u0016J\u0012\u0010N\u001a\u00020<2\b\u0010=\u001a\u0004\u0018\u00010\u001aH\u0016J\u0012\u0010O\u001a\u00020<2\b\u0010=\u001a\u0004\u0018\u00010\u0014H\u0016R\u0018\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u00107\u001a\u0002088BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:R\u0014\u0010J\u001a\u00020K8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bL\u0010M\u00a8\u0006P"}, d2={"Lorg/kingdoms/data/database/nbt/NBTDataProvider;", "Lorg/kingdoms/data/database/dataprovider/DataProvider;", "Lorg/kingdoms/data/database/dataprovider/SectionCreatableDataSetter;", "element", "Lorg/kingdoms/nbt/tag/NBTTag;", "<init>", "(Lorg/kingdoms/nbt/tag/NBTTag;)V", "getElement$core", "()Lorg/kingdoms/nbt/tag/NBTTag;", "createSection", "name", "", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "get", "asSection", "asString", "default", "Lorg/kingdoms/libs/kotlin/Function0;", "Lorg/kingdoms/data/database/dataprovider/Supply;", "asUUID", "Ljava/util/UUID;", "asSimpleLocation", "Lorg/kingdoms/constants/land/location/SimpleLocation;", "asSimpleChunkLocation", "Lorg/kingdoms/constants/land/location/SimpleChunkLocation;", "asLocation", "Lorg/bukkit/Location;", "asInt", "", "asLong", "", "asFloat", "", "asDouble", "", "asBoolean", "", "asCollection", "C", "V", "", "collection", "elementHandler", "Ljava/util/function/BiConsumer;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataGetter;", "(Ljava/util/Collection;Ljava/util/function/BiConsumer;)Ljava/util/Collection;", "asMap", "M", "K", "", "map", "handler", "Lorg/kingdoms/utils/internal/functional/TriConsumer;", "Lorg/kingdoms/data/database/dataprovider/DataGetter;", "(Ljava/util/Map;Lorg/kingdoms/utils/internal/functional/TriConsumer;)Ljava/util/Map;", "unsupported", "", "getUnsupported", "()Ljava/lang/Void;", "setSimpleLocation", "", "value", "setSimpleChunkLocation", "setLong", "setString", "setInt", "setFloat", "setDouble", "setBoolean", "setCollection", "", "setMap", "", "Lorg/kingdoms/data/database/dataprovider/MappingSetterHandler;", "obj", "Lorg/kingdoms/nbt/tag/NBTTagCompound;", "getObj", "()Lorg/kingdoms/nbt/tag/NBTTagCompound;", "setLocation", "setUUID", "core"})
@SourceDebugExtension(value={"SMAP\nNBTDataProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NBTDataProvider.kt\norg/kingdoms/data/database/nbt/NBTDataProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1#2:140\n*E\n"})
public final class NBTDataProvider
implements DataProvider,
SectionCreatableDataSetter {
    @NotNull
    private final NBTTag<?> element;

    public NBTDataProvider(@NotNull NBTTag<?> element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        this.element = element;
    }

    @NotNull
    public final NBTTag<?> getElement$core() {
        return this.element;
    }

    @Override
    @NotNull
    public DataProvider createSection(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        NBTTagCompound nBTTagCompound = NBTTagCompound.empty();
        Intrinsics.checkNotNullExpressionValue((Object)nBTTagCompound, (String)"empty(...)");
        NBTTagCompound newSection = nBTTagCompound;
        if (!(this.element instanceof NBTTagCompound)) {
            this.getUnsupported();
            throw new KotlinNothingValueException();
        }
        ((NBTTagCompound)this.element).set(name, (NBTTag)newSection);
        return new NBTDataProvider(newSection);
    }

    @Override
    @NotNull
    public SectionableDataSetter createSection() {
        NBTTagCompound nBTTagCompound = NBTTagCompound.empty();
        Intrinsics.checkNotNullExpressionValue((Object)nBTTagCompound, (String)"empty(...)");
        NBTTagCompound obj = nBTTagCompound;
        if (!(this.element instanceof NBTTagList)) {
            this.getUnsupported();
            throw new KotlinNothingValueException();
        }
        ((NBTTagList)this.element).addUnknown(obj);
        return new NamedNBTDataProvider(null, obj);
    }

    @Override
    @NotNull
    public DataProvider get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new NamedNBTDataProvider(name, this.getObj());
    }

    @Override
    @NotNull
    public DataProvider asSection() {
        return this;
    }

    @Override
    @Nullable
    public String asString(@NotNull Function0<String> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"default");
        NBTTag<?> nBTTag = this.element;
        Object object = nBTTag instanceof NBTTagString ? (NBTTagString)nBTTag : null;
        if (object == null || (object = ((NBTTagString)object).value()) == null) {
            object = (String)function0.invoke();
        }
        return object;
    }

    @Override
    @NotNull
    public UUID asUUID() {
        UUID uUID = FastUUID.fromString(this.asString((Function0<String>)((Function0)NBTDataProvider::asUUID$lambda$0)));
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
        return uUID;
    }

    @Override
    @Nullable
    public SimpleLocation asSimpleLocation() {
        SimpleLocation simpleLocation;
        String string = this.asString();
        if (string != null) {
            String it = string;
            boolean bl = false;
            simpleLocation = SimpleLocation.fromString(it);
        } else {
            simpleLocation = null;
        }
        return simpleLocation;
    }

    @Override
    @NotNull
    public SimpleChunkLocation asSimpleChunkLocation() {
        String string = this.asString((Function0<String>)((Function0)NBTDataProvider::asSimpleChunkLocation$lambda$2));
        Intrinsics.checkNotNull((Object)string);
        SimpleChunkLocation simpleChunkLocation = SimpleChunkLocation.fromString(string);
        Intrinsics.checkNotNullExpressionValue((Object)simpleChunkLocation, (String)"fromString(...)");
        return simpleChunkLocation;
    }

    @Override
    @Nullable
    public Location asLocation() {
        Location location;
        String string = this.asString((Function0<String>)((Function0)NBTDataProvider::asLocation$lambda$3));
        if (string != null) {
            String it = string;
            boolean bl = false;
            location = LocationUtils.fromString(it);
        } else {
            location = null;
        }
        return location;
    }

    @Override
    public int asInt(@NotNull Function0<Integer> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"default");
        NBTTag<?> nBTTag = this.element;
        Intrinsics.checkNotNull(nBTTag, (String)"null cannot be cast to non-null type org.kingdoms.nbt.tag.NBTTagInt");
        return ((NBTTagInt)nBTTag).valueAsInt();
    }

    @Override
    public long asLong(@NotNull Function0<Long> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"default");
        NBTTag<?> nBTTag = this.element;
        Intrinsics.checkNotNull(nBTTag, (String)"null cannot be cast to non-null type org.kingdoms.nbt.tag.NBTTagLong");
        return ((NBTTagLong)nBTTag).valueAsLong();
    }

    @Override
    public float asFloat(@NotNull Function0<Float> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"default");
        NBTTag<?> nBTTag = this.element;
        Intrinsics.checkNotNull(nBTTag, (String)"null cannot be cast to non-null type org.kingdoms.nbt.tag.NBTTagFloat");
        return ((NBTTagFloat)nBTTag).valueAsFloat();
    }

    @Override
    public double asDouble(@NotNull Function0<Double> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"default");
        NBTTag<?> nBTTag = this.element;
        Intrinsics.checkNotNull(nBTTag, (String)"null cannot be cast to non-null type org.kingdoms.nbt.tag.NBTTagDouble");
        return ((NBTTagDouble)nBTTag).valueAsDouble();
    }

    @Override
    public boolean asBoolean(@NotNull Function0<Boolean> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"default");
        NBTTag<?> nBTTag = this.element;
        Intrinsics.checkNotNull(nBTTag, (String)"null cannot be cast to non-null type org.kingdoms.nbt.tag.NBTTagBool");
        return ((NBTTagBool)nBTTag).valueAsBool();
    }

    @Override
    @NotNull
    public <V, C extends Collection<V>> C asCollection(@NotNull C collection, @NotNull BiConsumer<C, SectionableDataGetter> elementHandler) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        Intrinsics.checkNotNullParameter(elementHandler, (String)"elementHandler");
        NBTTag<?> nBTTag = this.element;
        Intrinsics.checkNotNull(nBTTag, (String)"null cannot be cast to non-null type org.kingdoms.nbt.tag.NBTTagList<*>");
        NBTTagList array = (NBTTagList)nBTTag;
        Iterator iterator = array.value().iterator();
        while (iterator.hasNext()) {
            NBTTag element = (NBTTag)iterator.next();
            Intrinsics.checkNotNull((Object)element);
            elementHandler.accept(collection, new NBTDataProvider(element));
        }
        return collection;
    }

    @Override
    @NotNull
    public <K, V, M extends Map<K, V>> M asMap(@NotNull M map, @NotNull TriConsumer<M, DataGetter, SectionableDataGetter> handler) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        NBTTag<?> nBTTag = this.element;
        Intrinsics.checkNotNull(nBTTag, (String)"null cannot be cast to non-null type org.kingdoms.nbt.tag.NBTTagCompound");
        NBTTagCompound obj = (NBTTagCompound)nBTTag;
        Object object = obj.value();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value(...)");
        for (Map.Entry entry : object.entrySet()) {
            String key = (String)entry.getKey();
            NBTTag value = (NBTTag)entry.getValue();
            NBTTagString nBTTagString = NBTTagString.of(key);
            Intrinsics.checkNotNullExpressionValue((Object)nBTTagString, (String)"of(...)");
            NBTDataProvider nBTDataProvider = new NBTDataProvider(nBTTagString);
            Intrinsics.checkNotNull((Object)value);
            handler.accept(map, nBTDataProvider, new NBTDataProvider(value));
        }
        return map;
    }

    private final Void getUnsupported() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSimpleLocation(@Nullable SimpleLocation value) {
        SimpleLocation simpleLocation = value;
        this.setString(simpleLocation != null ? simpleLocation.asDataString() : null);
    }

    @Override
    public void setSimpleChunkLocation(@NotNull SimpleChunkLocation value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.setString(value.asDataString());
    }

    @Override
    public void setLong(long value) {
        if (!(this.element instanceof NBTTagList)) {
            this.getUnsupported();
            throw new KotlinNothingValueException();
        }
        ((NBTTagList)this.element).addUnknown(NBTTagLong.of(value));
    }

    @Override
    public void setString(@Nullable String value) {
        if (value == null) {
            return;
        }
        if (!(this.element instanceof NBTTagList)) {
            this.getUnsupported();
            throw new KotlinNothingValueException();
        }
        ((NBTTagList)this.element).addUnknown(NBTTagString.of(value));
    }

    @Override
    public void setInt(int value) {
        if (!(this.element instanceof NBTTagList)) {
            this.getUnsupported();
            throw new KotlinNothingValueException();
        }
        ((NBTTagList)this.element).addUnknown(NBTTagInt.of(value));
    }

    @Override
    public void setFloat(float value) {
        if (!(this.element instanceof NBTTagList)) {
            this.getUnsupported();
            throw new KotlinNothingValueException();
        }
        ((NBTTagList)this.element).addUnknown(NBTTagFloat.of(value));
    }

    @Override
    public void setDouble(double value) {
        if (!(this.element instanceof NBTTagList)) {
            this.getUnsupported();
            throw new KotlinNothingValueException();
        }
        ((NBTTagList)this.element).addUnknown(NBTTagDouble.of(value));
    }

    @Override
    public void setBoolean(boolean value) {
        if (!(this.element instanceof NBTTagList)) {
            this.getUnsupported();
            throw new KotlinNothingValueException();
        }
        ((NBTTagList)this.element).addUnknown(NBTTagBool.of(value));
    }

    @NotNull
    public <V> Void setCollection(@NotNull Collection<? extends V> collection, @NotNull BiConsumer<SectionCreatableDataSetter, V> elementHandler) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        Intrinsics.checkNotNullParameter(elementHandler, (String)"elementHandler");
        this.getUnsupported();
        throw new KotlinNothingValueException();
    }

    @NotNull
    public <K, V> Void setMap(@NotNull Map<K, ? extends V> map, @NotNull MappingSetterHandler<K, V> handler) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.getUnsupported();
        throw new KotlinNothingValueException();
    }

    private final NBTTagCompound getObj() {
        return NBTTagType.COMPOUND.cast(this.element);
    }

    @Override
    public void setLocation(@Nullable Location value) {
        if (value == null) {
            return;
        }
        this.setString(LocationUtils.toString(value));
    }

    @Override
    public void setUUID(@Nullable UUID value) {
        this.setString(FastUUID.toString(value));
    }

    private static final String asUUID$lambda$0() {
        throw new IllegalStateException();
    }

    private static final String asSimpleChunkLocation$lambda$2() {
        throw new IllegalStateException();
    }

    private static final String asLocation$lambda$3() {
        return null;
    }
}

