/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.mongo;

import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.base.KingdomsObject;
import org.kingdoms.data.database.base.KingdomsDatabase;
import org.kingdoms.data.database.mongo.SimpleChunkLocationEncoder;
import org.kingdoms.data.database.mongo.SimpleLocationEncoder;
import org.kingdoms.data.database.sql.DatabaseProperties;
import org.kingdoms.data.database.sql.DatabaseType;
import org.kingdoms.data.handlers.abstraction.DataHandler;
import org.kingdoms.libs.bson.Document;
import org.kingdoms.libs.bson.UuidRepresentation;
import org.kingdoms.libs.bson.codecs.Codec;
import org.kingdoms.libs.bson.codecs.DecoderContext;
import org.kingdoms.libs.bson.codecs.configuration.CodecRegistries;
import org.kingdoms.libs.bson.codecs.configuration.CodecRegistry;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.mongodb.ConnectionString;
import org.kingdoms.libs.mongodb.MongoClientSettings;
import org.kingdoms.libs.mongodb.MongoCredential;
import org.kingdoms.libs.mongodb.ServerApi;
import org.kingdoms.libs.mongodb.ServerApiVersion;
import org.kingdoms.libs.mongodb.client.MongoClient;
import org.kingdoms.libs.mongodb.client.MongoClients;
import org.kingdoms.libs.mongodb.client.MongoCollection;
import org.kingdoms.libs.mongodb.client.MongoDatabase;
import org.kingdoms.libs.mongodb.client.model.ReplaceOptions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u0013*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\u0013B\u0017\b\u0004\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lorg/kingdoms/data/database/mongo/MongoDBDatabase;", "T", "Lorg/kingdoms/constants/base/KingdomsObject;", "Lorg/kingdoms/data/database/base/KingdomsDatabase;", "collection", "Lorg/kingdoms/libs/mongodb/client/MongoCollection;", "Lorg/kingdoms/libs/bson/Document;", "<init>", "(Lcom/mongodb/client/MongoCollection;)V", "getCollection", "()Lcom/mongodb/client/MongoCollection;", "dataHandler", "Lorg/kingdoms/data/handlers/abstraction/DataHandler;", "getDataHandler", "()Lorg/kingdoms/data/handlers/abstraction/DataHandler;", "getDatabaseType", "Lorg/kingdoms/data/database/sql/DatabaseType;", "close", "", "Companion", "core"})
public abstract class MongoDBDatabase<T extends KingdomsObject>
implements KingdomsDatabase<T> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final MongoCollection<Document> collection;
    @NotNull
    private static final MongoClient CLIENT;
    @NotNull
    private static final MongoDatabase DATABASE;
    private static final ReplaceOptions UPSERT;
    @NotNull
    public static final String PRIMARY_KEY_ID = "_id";
    private static final DecoderContext DEFAULT_DECODER_CONTEXT;

    protected MongoDBDatabase(@NotNull MongoCollection<Document> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        this.collection = collection;
    }

    @NotNull
    protected final MongoCollection<Document> getCollection() {
        return this.collection;
    }

    @NotNull
    protected abstract DataHandler<T> getDataHandler();

    @Override
    @NotNull
    public DatabaseType getDatabaseType() {
        return DatabaseType.MongoDB;
    }

    @Override
    public void close() {
        CLIENT.close();
    }

    @JvmStatic
    @NotNull
    public static final MongoCollection<Document> getCollection(@NotNull String name) {
        return Companion.getCollection(name);
    }

    static {
        MongoClientSettings.Builder builder;
        Companion = new Companion(null);
        UPSERT = new ReplaceOptions().upsert(true);
        DEFAULT_DECODER_CONTEXT = DecoderContext.builder().build();
        DatabaseProperties props = DatabaseProperties.Companion.defaults(DatabaseType.MongoDB);
        MongoClientSettings.Builder $this$_init__u24lambda_u240 = builder = MongoClientSettings.builder();
        boolean bl = false;
        $this$_init__u24lambda_u240.applicationName("KingdomsX");
        String fullURL = KingdomsConfig.DATABASE_URI.getString();
        Object object = (CodecRegistry[])fullURL;
        if (!(object == null || object.length() == 0)) {
            $this$_init__u24lambda_u240.applyConnectionString(new ConnectionString(fullURL));
        } else {
            object = KingdomsConfig.DATABASE_USERNAME.getString();
            if (!(object == null || object.length() == 0)) {
                String string = props.getUser();
                String string2 = props.getDatabaseName();
                char[] cArray = props.getPassword().toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                $this$_init__u24lambda_u240.credential(MongoCredential.createCredential((String)string, (String)string2, (char[])cArray));
            }
        }
        $this$_init__u24lambda_u240.retryReads(false);
        $this$_init__u24lambda_u240.retryWrites(true);
        $this$_init__u24lambda_u240.uuidRepresentation(UuidRepresentation.STANDARD);
        $this$_init__u24lambda_u240.serverApi(ServerApi.builder().version(ServerApiVersion.V1).deprecationErrors(true).strict(true).build());
        object = new CodecRegistry[2];
        object[0] = MongoClientSettings.getDefaultCodecRegistry();
        Codec[] codecArray = new Codec[]{new SimpleChunkLocationEncoder(), new SimpleLocationEncoder()};
        object[1] = CodecRegistries.fromCodecs((Codec[])codecArray);
        $this$_init__u24lambda_u240.codecRegistry(CodecRegistries.fromRegistries((CodecRegistry[])object));
        MongoClientSettings.Builder settings = builder;
        CLIENT = MongoClients.create((MongoClientSettings)settings.build(), null);
        DATABASE = CLIENT.getDatabase(props.getDatabaseName());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u0013H\u0007R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0012\u001a\u00020\u0013X\u0080T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\n \u000e*\u0004\u0018\u00010\u00150\u0015X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lorg/kingdoms/data/database/mongo/MongoDBDatabase$Companion;", "", "<init>", "()V", "CLIENT", "Lorg/kingdoms/libs/mongodb/client/MongoClient;", "getCLIENT$core", "()Lcom/mongodb/client/MongoClient;", "DATABASE", "Lorg/kingdoms/libs/mongodb/client/MongoDatabase;", "getDATABASE$core", "()Lcom/mongodb/client/MongoDatabase;", "UPSERT", "Lorg/kingdoms/libs/mongodb/client/model/ReplaceOptions;", "org.kingdoms.libs.kotlin.jvm.PlatformType", "getUPSERT$core", "()Lcom/mongodb/client/model/ReplaceOptions;", "Lorg/kingdoms/libs/mongodb/client/model/ReplaceOptions;", "PRIMARY_KEY_ID", "", "DEFAULT_DECODER_CONTEXT", "Lorg/kingdoms/libs/bson/codecs/DecoderContext;", "getDEFAULT_DECODER_CONTEXT$core", "()Lorg/bson/codecs/DecoderContext;", "Lorg/kingdoms/libs/bson/codecs/DecoderContext;", "getCollection", "Lorg/kingdoms/libs/mongodb/client/MongoCollection;", "Lorg/kingdoms/libs/bson/Document;", "name", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MongoClient getCLIENT$core() {
            return CLIENT;
        }

        @NotNull
        public final MongoDatabase getDATABASE$core() {
            return DATABASE;
        }

        public final ReplaceOptions getUPSERT$core() {
            return UPSERT;
        }

        public final DecoderContext getDEFAULT_DECODER_CONTEXT$core() {
            return DEFAULT_DECODER_CONTEXT;
        }

        @JvmStatic
        @NotNull
        public final MongoCollection<Document> getCollection(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            String collectionName = KingdomsConfig.DATABASE_TABLE_PREFIX.getString() + '_' + name;
            MongoCollection mongoCollection = this.getDATABASE$core().getCollection(collectionName);
            Intrinsics.checkNotNullExpressionValue((Object)mongoCollection, (String)"getCollection(...)");
            return mongoCollection;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

