/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.mongo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.kingdoms.constants.base.KeyedKingdomsObject;
import org.kingdoms.data.database.base.KeyedKingdomsDatabase;
import org.kingdoms.data.database.mongo.MongoDBDatabase;
import org.kingdoms.data.database.mongo.MongoDataProvider;
import org.kingdoms.data.database.mongo.MongoIdQueryContainer;
import org.kingdoms.data.handlers.abstraction.KeyedDataHandler;
import org.kingdoms.libs.bson.BsonDocumentReader;
import org.kingdoms.libs.bson.BsonReader;
import org.kingdoms.libs.bson.Document;
import org.kingdoms.libs.bson.codecs.Codec;
import org.kingdoms.libs.bson.conversions.Bson;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.ranges.RangesKt;
import org.kingdoms.libs.mongodb.client.FindIterable;
import org.kingdoms.libs.mongodb.client.MongoCollection;
import org.kingdoms.libs.mongodb.client.MongoCursor;
import org.kingdoms.libs.mongodb.client.model.BulkWriteOptions;
import org.kingdoms.libs.mongodb.client.model.ReplaceOneModel;
import org.kingdoms.main.KLogger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 1*\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\b\u0012\u0004\u0012\u0002H\u00030\u00052\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0006:\u00011B+\b\u0002\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ\u001b\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\u0006\u0010\u0014\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0015J\u0015\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0017\u0010\u0018\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0015\u0010\u001b\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u0002H\u0002\u00a2\u0006\u0002\u0010\u001cJ$\u0010\u0018\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00010!H\u0016J\u0015\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010$J\u0015\u0010%\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010&J\u0015\u0010'\u001a\u00020(2\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010)J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\u001fH\u0016J\b\u0010+\u001a\u00020\u001dH\u0016J\b\u0010,\u001a\u00020\u0011H\u0016J\u001e\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00010\u001f2\u000e\u0010.\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010/H\u0016J\u0016\u0010\"\u001a\u00020\u001d2\f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00010\u001fH\u0016J\b\u00100\u001a\u00020\u001dH\u0016R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/kingdoms/data/database/mongo/KeyedMongoDBDatabase;", "K", "", "T", "Lorg/kingdoms/constants/base/KeyedKingdomsObject;", "Lorg/kingdoms/data/database/mongo/MongoDBDatabase;", "Lorg/kingdoms/data/database/base/KeyedKingdomsDatabase;", "dataHandler", "Lorg/kingdoms/data/handlers/abstraction/KeyedDataHandler;", "collection", "Lorg/kingdoms/libs/mongodb/client/MongoCollection;", "Lorg/kingdoms/libs/bson/Document;", "<init>", "(Lorg/kingdoms/data/handlers/abstraction/KeyedDataHandler;Lcom/mongodb/client/MongoCollection;)V", "getDataHandler", "()Lorg/kingdoms/data/handlers/abstraction/KeyedDataHandler;", "maxEntries", "", "constructIdContainer", "Lorg/kingdoms/data/database/mongo/MongoIdQueryContainer;", "id", "(Ljava/lang/Object;)Lorg/kingdoms/data/database/mongo/MongoIdQueryContainer;", "sectionWithId", "(Ljava/lang/Object;)Lorg/bson/Document;", "load", "key", "(Ljava/lang/Object;)Lorg/kingdoms/constants/base/KeyedKingdomsObject;", "decode", "(Ljava/lang/Object;)Ljava/lang/Object;", "", "keys", "", "handler", "Ljava/util/function/Consumer;", "save", "data", "(Lorg/kingdoms/constants/base/KeyedKingdomsObject;)V", "delete", "(Ljava/lang/Object;)V", "hasData", "", "(Ljava/lang/Object;)Z", "getAllDataKeys", "deleteAllData", "count", "loadAllData", "filter", "Ljava/util/function/Predicate;", "close", "Companion", "core"})
public final class KeyedMongoDBDatabase<K, T extends KeyedKingdomsObject<K>>
extends MongoDBDatabase<T>
implements KeyedKingdomsDatabase<K, T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KeyedDataHandler<K, T> dataHandler;
    private int maxEntries;

    private KeyedMongoDBDatabase(KeyedDataHandler<K, T> dataHandler, MongoCollection<Document> collection) {
        super(collection);
        this.dataHandler = dataHandler;
        this.maxEntries = 10;
    }

    @NotNull
    protected KeyedDataHandler<K, T> getDataHandler() {
        return this.dataHandler;
    }

    private final MongoIdQueryContainer<K> constructIdContainer(K id) {
        return new MongoIdQueryContainer<K>(id, ((KeyedDataHandler)this.getDataHandler()).getIdHandler().getKlass());
    }

    private final Document sectionWithId(K id) {
        return new Document("_id", id);
    }

    @Override
    @Nullable
    public T load(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Document document = (Document)this.getCollection().find((Bson)this.constructIdContainer(key)).first();
        if (document == null) {
            return null;
        }
        Document doc = document;
        MongoDataProvider provider = new MongoDataProvider(null, doc);
        return (T)((KeyedKingdomsObject)((KeyedDataHandler)this.getDataHandler()).load(provider, key));
    }

    private final K decode(Object key) {
        if (key instanceof Document) {
            Codec codec = this.getCollection().getCodecRegistry().get(((KeyedDataHandler)this.getDataHandler()).getIdHandler().getKlass());
            Intrinsics.checkNotNull((Object)codec);
            Codec codec2 = codec;
            Object object = codec2.decode((BsonReader)new BsonDocumentReader(((Document)key).toBsonDocument()), MongoDBDatabase.Companion.getDEFAULT_DECODER_CONTEXT$core());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"decode(...)");
            return (K)object;
        }
        Intrinsics.checkNotNull((Object)key, (String)"null cannot be cast to non-null type K of org.kingdoms.data.database.mongo.KeyedMongoDBDatabase");
        return (K)key;
    }

    @Override
    public void load(@NotNull Collection<K> keys, @NotNull Consumer<T> handler) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        if (keys.isEmpty()) {
            return;
        }
        Document ids = new Document("_id", (Object)new Document("$in", keys));
        FindIterable result = this.getCollection().find((Bson)ids);
        MongoCursor mongoCursor = result.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)mongoCursor, (String)"iterator(...)");
        MongoCursor mongoCursor2 = mongoCursor;
        while (mongoCursor2.hasNext()) {
            Document document = (Document)mongoCursor2.next();
            Intrinsics.checkNotNull((Object)document);
            MongoDataProvider provider = new MongoDataProvider(null, document);
            Object object = document.get((Object)"_id");
            Intrinsics.checkNotNull((Object)object);
            K id = this.decode(object);
            KeyedKingdomsObject data = (KeyedKingdomsObject)((KeyedDataHandler)this.getDataHandler()).load(provider, id);
            handler.accept(data);
        }
    }

    @Override
    public void save(@NotNull T data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Object k = data.getKey();
        Intrinsics.checkNotNullExpressionValue(k, (String)"getKey(...)");
        MongoIdQueryContainer id = this.constructIdContainer(k);
        Object k2 = data.getKey();
        Intrinsics.checkNotNullExpressionValue(k2, (String)"getKey(...)");
        Document document = this.sectionWithId(k2);
        MongoDataProvider provider = new MongoDataProvider(null, document);
        this.getDataHandler().save(provider, data);
        this.getCollection().replaceOne((Bson)id, (Object)document, MongoDBDatabase.Companion.getUPSERT$core());
    }

    @Override
    public void delete(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.getCollection().deleteOne((Bson)this.constructIdContainer(key));
    }

    @Override
    public boolean hasData(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.getCollection().find((Bson)this.constructIdContainer(key)).first() != null;
    }

    @Override
    @NotNull
    public Collection<K> getAllDataKeys() {
        List list = new ArrayList((int)this.getCollection().estimatedDocumentCount());
        MongoCursor mongoCursor = this.getCollection().find().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)mongoCursor, (String)"iterator(...)");
        MongoCursor mongoCursor2 = mongoCursor;
        while (mongoCursor2.hasNext()) {
            Document document = (Document)mongoCursor2.next();
            Object object = document.get((Object)"_id");
            Intrinsics.checkNotNull((Object)object);
            K id = this.decode(object);
            list.add(id);
        }
        return list;
    }

    @Override
    public void deleteAllData() {
        this.getCollection().drop();
    }

    @Override
    public int count() {
        return (int)this.getCollection().countDocuments();
    }

    @Override
    @NotNull
    public Collection<T> loadAllData(@Nullable Predicate<K> filter) {
        List list = new ArrayList(this.maxEntries);
        MongoCursor mongoCursor = this.getCollection().find().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)mongoCursor, (String)"iterator(...)");
        MongoCursor mongoCursor2 = mongoCursor;
        while (mongoCursor2.hasNext()) {
            Document document = (Document)mongoCursor2.next();
            Intrinsics.checkNotNull((Object)document);
            MongoDataProvider provider = new MongoDataProvider(null, document);
            Object object = document.get((Object)"_id");
            Intrinsics.checkNotNull((Object)object);
            K key = this.decode(object);
            if (filter != null && !filter.test(key)) continue;
            try {
                list.add(((KeyedDataHandler)this.getDataHandler()).load(provider, key));
            }
            catch (Throwable ex) {
                KLogger.error("Error while loading '" + key + "' of type " + this.getDataHandler().getClass().getSimpleName() + " (Skipping):");
                ex.printStackTrace();
            }
        }
        this.maxEntries = RangesKt.coerceAtLeast((int)this.maxEntries, (int)list.size());
        return list;
    }

    @Override
    public void save(@NotNull Collection<T> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        if (data.isEmpty()) {
            return;
        }
        List replacingModels = new ArrayList(data.size());
        for (KeyedKingdomsObject datum : data) {
            Object k = datum.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"getKey(...)");
            MongoIdQueryContainer id = this.constructIdContainer(k);
            Object k2 = datum.getKey();
            Intrinsics.checkNotNullExpressionValue(k2, (String)"getKey(...)");
            Document document = this.sectionWithId(k2);
            MongoDataProvider provider = new MongoDataProvider(null, document);
            this.getDataHandler().save(provider, datum);
            replacingModels.add(new ReplaceOneModel((Bson)id, (Object)document, MongoDBDatabase.Companion.getUPSERT$core()));
        }
        this.getCollection().bulkWrite(replacingModels, new BulkWriteOptions().ordered(false).comment("Save batch data of " + data.size()));
    }

    @Override
    public void close() {
        MongoDBDatabase.Companion.getCLIENT$core().close();
    }

    @JvmStatic
    @NotNull
    public static final <K, T extends KeyedKingdomsObject<K>> KeyedMongoDBDatabase<K, T> withCollection(@NotNull String name, @NotNull KeyedDataHandler<K, T> dataHandler) {
        return Companion.withCollection(name, dataHandler);
    }

    public /* synthetic */ KeyedMongoDBDatabase(KeyedDataHandler dataHandler, MongoCollection collection, DefaultConstructorMarker $constructor_marker) {
        this(dataHandler, (MongoCollection<Document>)collection);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JJ\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\u0005\"\b\b\u0002\u0010\u0006*\u00020\u0001\"\u000e\b\u0003\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00060\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\fH\u0007\u00a8\u0006\r"}, d2={"Lorg/kingdoms/data/database/mongo/KeyedMongoDBDatabase$Companion;", "", "<init>", "()V", "withCollection", "Lorg/kingdoms/data/database/mongo/KeyedMongoDBDatabase;", "K", "T", "Lorg/kingdoms/constants/base/KeyedKingdomsObject;", "name", "", "dataHandler", "Lorg/kingdoms/data/handlers/abstraction/KeyedDataHandler;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <K, T extends KeyedKingdomsObject<K>> KeyedMongoDBDatabase<K, T> withCollection(@NotNull String name, @NotNull KeyedDataHandler<K, T> dataHandler) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(dataHandler, (String)"dataHandler");
            return new KeyedMongoDBDatabase(dataHandler, MongoDBDatabase.Companion.getCollection(name), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

