/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.flatfile;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.kingdoms.constants.base.KeyedKingdomsObject;
import org.kingdoms.data.database.base.KeyedKingdomsDatabase;
import org.kingdoms.data.handlers.abstraction.KeyedDataHandler;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Unit;
import org.kingdoms.libs.kotlin.io.CloseableKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.ranges.RangesKt;
import org.kingdoms.utils.fs.FSUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005B+\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001dJ\"\u0010\u001c\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00010\"J\u001f\u0010\u001c\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001a\u001a\u00028\u00002\u0006\u0010#\u001a\u00020$H&\u00a2\u0006\u0002\u0010%J\u001d\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00028\u00012\u0006\u0010(\u001a\u00020)H&\u00a2\u0006\u0002\u0010*J\u0013\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00028\u0001\u00a2\u0006\u0002\u0010+J\u0013\u0010,\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u0010-J\u0013\u0010.\u001a\u00020/2\u0006\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\u0002\u00100J\f\u00101\u001a\b\u0012\u0004\u0012\u00028\u000002J\u0006\u00103\u001a\u00020\u001eJ\b\u00104\u001a\u00020\u0015H\u0016J\u001c\u00105\u001a\b\u0012\u0004\u0012\u00028\u00010 2\u000e\u00106\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u000107J\u0014\u0010&\u001a\u00020\u001e2\f\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00010 J\u0006\u00108\u001a\u00020\u001eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/kingdoms/data/database/flatfile/KeyedFlatFileDatabase;", "K", "", "T", "Lorg/kingdoms/constants/base/KeyedKingdomsObject;", "Lorg/kingdoms/data/database/base/KeyedKingdomsDatabase;", "extension", "", "folder", "Ljava/nio/file/Path;", "dataHandler", "Lorg/kingdoms/data/handlers/abstraction/KeyedDataHandler;", "<init>", "(Ljava/lang/String;Ljava/nio/file/Path;Lorg/kingdoms/data/handlers/abstraction/KeyedDataHandler;)V", "getExtension", "()Ljava/lang/String;", "getFolder", "()Ljava/nio/file/Path;", "getDataHandler", "()Lorg/kingdoms/data/handlers/abstraction/KeyedDataHandler;", "maxKeys", "", "keyFromFile", "path", "(Ljava/nio/file/Path;)Ljava/lang/Object;", "fileFromKey", "key", "(Ljava/lang/Object;)Ljava/nio/file/Path;", "load", "(Ljava/lang/Object;)Lorg/kingdoms/constants/base/KeyedKingdomsObject;", "", "keys", "", "handler", "Ljava/util/function/Consumer;", "reader", "Ljava/io/BufferedReader;", "(Ljava/lang/Object;Ljava/io/BufferedReader;)Lorg/kingdoms/constants/base/KeyedKingdomsObject;", "save", "data", "writer", "Ljava/io/BufferedWriter;", "(Lorg/kingdoms/constants/base/KeyedKingdomsObject;Ljava/io/BufferedWriter;)V", "(Lorg/kingdoms/constants/base/KeyedKingdomsObject;)V", "delete", "(Ljava/lang/Object;)V", "hasData", "", "(Ljava/lang/Object;)Z", "getAllDataKeys", "", "deleteAllData", "count", "loadAllData", "filter", "Ljava/util/function/Predicate;", "close", "core"})
@SourceDebugExtension(value={"SMAP\nKeyedFlatFileDatabase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyedFlatFileDatabase.kt\norg/kingdoms/data/database/flatfile/KeyedFlatFileDatabase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,153:1\n1#2:154\n*E\n"})
public abstract class KeyedFlatFileDatabase<K, T extends KeyedKingdomsObject<K>>
implements KeyedKingdomsDatabase<K, T> {
    @NotNull
    private final String extension;
    @NotNull
    private final Path folder;
    @NotNull
    private final KeyedDataHandler<K, T> dataHandler;
    private int maxKeys;

    public KeyedFlatFileDatabase(@NotNull String extension, @NotNull Path folder, @NotNull KeyedDataHandler<K, T> dataHandler) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        Intrinsics.checkNotNullParameter(dataHandler, (String)"dataHandler");
        this.extension = extension;
        this.folder = folder;
        this.dataHandler = dataHandler;
        this.maxKeys = 10;
        if (!Files.exists(this.folder, new LinkOption[0])) {
            try {
                Files.createDirectories(this.folder, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @NotNull
    public final String getExtension() {
        return this.extension;
    }

    @NotNull
    public final Path getFolder() {
        return this.folder;
    }

    @NotNull
    public final KeyedDataHandler<K, T> getDataHandler() {
        return this.dataHandler;
    }

    private final K keyFromFile(Path path) {
        String str = ((Object)path.getFileName()).toString();
        String string = str.substring(0, str.length() - this.extension.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String removedExtension = string;
        try {
            return this.dataHandler.getIdHandler().fromString(removedExtension);
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException("Malformed data ID from file name: '" + path + "' (Did you put/rename a file/folder inside Kingdoms data folders?)");
        }
    }

    @NotNull
    public final Path fileFromKey(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Path path = this.folder.resolve(this.dataHandler.getIdHandler().toString(key) + '.' + this.extension);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final T load(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Path file = this.fileFromKey(key);
        if (!Files.exists(file, new LinkOption[0])) {
            return null;
        }
        Closeable closeable = Files.newBufferedReader(file, StandardCharsets.UTF_8);
        Throwable throwable = null;
        try {
            BufferedReader reader = (BufferedReader)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)reader);
            T t = this.load(key, reader);
            return t;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Override
    public final void load(@NotNull Collection<K> keys, @NotNull Consumer<T> handler) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        for (K key : keys) {
            T data;
            if (this.load(key) == null) continue;
            handler.accept(data);
        }
    }

    @Nullable
    public abstract T load(@NotNull K var1, @NotNull BufferedReader var2);

    public abstract void save(@NotNull T var1, @NotNull BufferedWriter var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void save(@NotNull T data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        String key = data.getKey() + '.' + this.extension;
        Path path = this.folder.resolve(key);
        try {
            Closeable closeable = FSUtil.standardWriter(path);
            Throwable throwable = null;
            try {
                BufferedWriter writer = (BufferedWriter)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)writer);
                this.save(data, writer);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public final void delete(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        try {
            Files.deleteIfExists(this.fileFromKey(key));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final boolean hasData(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return Files.exists(this.fileFromKey(key), new LinkOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public final Collection<K> getAllDataKeys() {
        List paths = new ArrayList(this.maxKeys);
        Closeable closeable = Files.newDirectoryStream(this.folder);
        Throwable throwable = null;
        try {
            DirectoryStream fs = (DirectoryStream)closeable;
            boolean bl = false;
            Iterator iterator = fs.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Path path = (Path)iterator2.next();
                if (!Files.isRegularFile(path, new LinkOption[0])) continue;
                Intrinsics.checkNotNull((Object)path);
                paths.add(this.keyFromFile(path));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this.maxKeys = RangesKt.coerceAtLeast((int)paths.size(), (int)this.maxKeys);
        return paths;
    }

    @Override
    public final void deleteAllData() {
        try {
            FSUtil.deleteFolder(this.folder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int count() {
        return FSUtil.countEntriesOf(this.folder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public final Collection<T> loadAllData(@Nullable Predicate<K> filter) {
        List loaded = new ArrayList(this.maxKeys);
        Closeable closeable = Files.newDirectoryStream(this.folder);
        Throwable throwable = null;
        try {
            DirectoryStream fs = (DirectoryStream)closeable;
            boolean bl = false;
            Iterator iterator = fs.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Path path = (Path)iterator2.next();
                if (!Files.isRegularFile(path, new LinkOption[0])) continue;
                Intrinsics.checkNotNull((Object)path);
                K key = this.keyFromFile(path);
                if (filter != null && !filter.test(key)) continue;
                try {
                    T data;
                    if (this.load(key) == null) {
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        LinkOption[] linkOptionArray2 = new LinkOption[]{};
                        throw new IllegalStateException("Couldn't load bulk data " + key + " -> " + path + " -> " + Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) + " -> " + this.fileFromKey(key) + " -> " + Files.exists(this.fileFromKey(key), Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)));
                    }
                    loaded.add(data);
                }
                catch (Throwable ex) {
                    throw new RuntimeException("Error while loading " + key, ex);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this.maxKeys = RangesKt.coerceAtLeast((int)loaded.size(), (int)this.maxKeys);
        return loaded;
    }

    @Override
    public final void save(@NotNull Collection<T> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        for (KeyedKingdomsObject datum : data) {
            this.save((T)datum);
        }
    }

    @Override
    public final void close() {
    }
}

