/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.dataprovider;

import java.util.UUID;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.data.database.dataprovider.IdDataTypeHandler;
import org.kingdoms.data.database.sql.statements.getters.SimpleResultSetQuery;
import org.kingdoms.data.database.sql.statements.setters.SimplePreparedStatement;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.utils.internal.uuid.FastUUID;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\b\t\nB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/kingdoms/data/database/dataprovider/StdIdDataType;", "", "<init>", "()V", "UUID", "Lorg/kingdoms/data/database/dataprovider/StdIdDataType$UUIDKey;", "SIMPLE_CHUNK_LOCATION", "Lorg/kingdoms/data/database/dataprovider/StdIdDataType$SimpleChunkLocationKey;", "NoKey", "UUIDKey", "SimpleChunkLocationKey", "core"})
public final class StdIdDataType {
    @NotNull
    public static final StdIdDataType INSTANCE = new StdIdDataType();
    @JvmField
    @NotNull
    public static final UUIDKey UUID = new UUIDKey("id");
    @JvmField
    @NotNull
    public static final SimpleChunkLocationKey SIMPLE_CHUNK_LOCATION = new SimpleChunkLocationKey("id");

    private StdIdDataType() {
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\u0010"}, d2={"Lorg/kingdoms/data/database/dataprovider/StdIdDataType$NoKey;", "Lorg/kingdoms/data/database/dataprovider/IdDataTypeHandler;", "", "<init>", "()V", "setSQL", "", "statement", "Lorg/kingdoms/data/database/sql/statements/setters/SimplePreparedStatement;", "id", "fromSQL", "result", "Lorg/kingdoms/data/database/sql/statements/getters/SimpleResultSetQuery;", "fromString", "string", "toString", "core"})
    public static final class NoKey
    extends IdDataTypeHandler<String> {
        @NotNull
        public static final NoKey INSTANCE = new NoKey();

        private NoKey() {
            super("NoKey", String.class, new String[0]);
        }

        @NotNull
        public Void setSQL(@NotNull SimplePreparedStatement statement, @NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String fromSQL(@NotNull SimpleResultSetQuery result) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String fromString(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public String toString(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            throw new UnsupportedOperationException();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/kingdoms/data/database/dataprovider/StdIdDataType$SimpleChunkLocationKey;", "Lorg/kingdoms/data/database/dataprovider/IdDataTypeHandler;", "Lorg/kingdoms/constants/land/location/SimpleChunkLocation;", "prefix", "", "<init>", "(Ljava/lang/String;)V", "setSQL", "", "statement", "Lorg/kingdoms/data/database/sql/statements/setters/SimplePreparedStatement;", "id", "fromSQL", "result", "Lorg/kingdoms/data/database/sql/statements/getters/SimpleResultSetQuery;", "fromString", "string", "toString", "core"})
    public static final class SimpleChunkLocationKey
    extends IdDataTypeHandler<SimpleChunkLocation> {
        public SimpleChunkLocationKey(@NotNull String prefix) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            String[] stringArray = new String[]{"world", "x", "z"};
            super(prefix, SimpleChunkLocation.class, stringArray);
        }

        @Override
        public void setSQL(@NotNull SimplePreparedStatement statement, @NotNull SimpleChunkLocation id) {
            SimplePreparedStatement simplePreparedStatement;
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            SimplePreparedStatement $this$setSQL_u24lambda_u240 = simplePreparedStatement = statement;
            boolean bl = false;
            $this$setSQL_u24lambda_u240.setString(this.getPrefix$core() + "_world", id.getWorld());
            $this$setSQL_u24lambda_u240.setInt(this.getPrefix$core() + "_x", id.getX());
            $this$setSQL_u24lambda_u240.setInt(this.getPrefix$core() + "_z", id.getZ());
        }

        @Override
        @NotNull
        public SimpleChunkLocation fromSQL(@NotNull SimpleResultSetQuery result) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            SimpleResultSetQuery $this$fromSQL_u24lambda_u241 = result;
            boolean bl = false;
            return new SimpleChunkLocation($this$fromSQL_u24lambda_u241.getString(this.getPrefix$core() + "_world"), $this$fromSQL_u24lambda_u241.getInt(this.getPrefix$core() + "_x"), $this$fromSQL_u24lambda_u241.getInt(this.getPrefix$core() + "_z"));
        }

        @Override
        @NotNull
        public SimpleChunkLocation fromString(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            SimpleChunkLocation simpleChunkLocation = SimpleChunkLocation.fromString(string);
            Intrinsics.checkNotNullExpressionValue((Object)simpleChunkLocation, (String)"fromString(...)");
            return simpleChunkLocation;
        }

        @Override
        @NotNull
        public String toString(@NotNull SimpleChunkLocation id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            String string = id.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/kingdoms/data/database/dataprovider/StdIdDataType$UUIDKey;", "Lorg/kingdoms/data/database/dataprovider/IdDataTypeHandler;", "Ljava/util/UUID;", "prefix", "", "<init>", "(Ljava/lang/String;)V", "setSQL", "", "statement", "Lorg/kingdoms/data/database/sql/statements/setters/SimplePreparedStatement;", "id", "fromSQL", "result", "Lorg/kingdoms/data/database/sql/statements/getters/SimpleResultSetQuery;", "fromString", "string", "toString", "core"})
    public static final class UUIDKey
    extends IdDataTypeHandler<UUID> {
        public UUIDKey(@NotNull String prefix) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            super(prefix, UUID.class, new String[0]);
        }

        @Override
        public void setSQL(@NotNull SimplePreparedStatement statement, @NotNull UUID id) {
            Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            statement.setUUID(this.getPrefix$core(), id);
        }

        @Override
        @NotNull
        public UUID fromSQL(@NotNull SimpleResultSetQuery result) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            UUID uUID = result.getUUID(this.getPrefix$core());
            Intrinsics.checkNotNull((Object)uUID);
            return uUID;
        }

        @Override
        @NotNull
        public UUID fromString(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            UUID uUID = FastUUID.fromString(string);
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
            return uUID;
        }

        @Override
        @NotNull
        public String toString(@NotNull UUID id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            String string = FastUUID.toString(id);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
    }
}

