/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.compressor;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.bukkit.Location;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.data.compressor.DataCompressor;
import org.kingdoms.data.database.dataprovider.MappingSetterHandler;
import org.kingdoms.data.database.dataprovider.SectionCreatableDataSetter;
import org.kingdoms.data.database.dataprovider.SectionableDataProvider;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.data.database.dataprovider.StringMappedIdSetter;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.functions.Function1;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0019\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u0005H\u0002J\u0011\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0096\u0002J\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0010\u001a\u00020\u0000H\u0016J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u0016J\u0012\u0010\u0014\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020#H\u0016J\u0012\u0010$\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010%H\u0016J0\u0010&\u001a\u00020\u0012\"\u0004\b\u0000\u0010'2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H'0)2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H'0+H\u0016J<\u0010,\u001a\u00020\u0012\"\u0004\b\u0000\u0010-\"\u0004\b\u0001\u0010'2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u0002H-\u0012\u0004\u0012\u0002H'0/2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u0002H-\u0012\u0004\u0012\u0002H'01H\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u00062"}, d2={"Lorg/kingdoms/data/database/compressor/CompressorDataProvider;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataProvider;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "Lorg/kingdoms/data/database/dataprovider/SectionCreatableDataSetter;", "name", "", "compressor", "Lorg/kingdoms/data/compressor/DataCompressor;", "<init>", "(Ljava/lang/String;Lorg/kingdoms/data/compressor/DataCompressor;)V", "getName", "()Ljava/lang/String;", "getCompressor", "()Lorg/kingdoms/data/compressor/DataCompressor;", "verifiedName", "get", "createSection", "setString", "", "value", "setSimpleLocation", "Lorg/kingdoms/constants/land/location/SimpleLocation;", "setSimpleChunkLocation", "Lorg/kingdoms/constants/land/location/SimpleChunkLocation;", "setUUID", "Ljava/util/UUID;", "setInt", "", "setLong", "", "setFloat", "", "setDouble", "", "setBoolean", "", "setLocation", "Lorg/bukkit/Location;", "setCollection", "V", "collection", "", "elementHandler", "Ljava/util/function/BiConsumer;", "setMap", "K", "map", "", "handler", "Lorg/kingdoms/data/database/dataprovider/MappingSetterHandler;", "core"})
@SourceDebugExtension(value={"SMAP\nCompressorDataProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompressorDataProvider.kt\norg/kingdoms/data/database/compressor/CompressorDataProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1#2:90\n*E\n"})
public final class CompressorDataProvider
implements SectionableDataProvider,
SectionableDataSetter,
SectionCreatableDataSetter {
    @Nullable
    private final String name;
    @NotNull
    private final DataCompressor compressor;

    public CompressorDataProvider(@Nullable String name, @NotNull DataCompressor compressor) {
        Intrinsics.checkNotNullParameter((Object)compressor, (String)"compressor");
        this.name = name;
        this.compressor = compressor;
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final DataCompressor getCompressor() {
        return this.compressor;
    }

    private final String verifiedName() {
        if (this.name == null) {
            throw new IllegalStateException("No key name set");
        }
        this.compressor.compress(this.name);
        return this.name;
    }

    @Override
    @NotNull
    public CompressorDataProvider get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new CompressorDataProvider(name, this.compressor);
    }

    @Override
    @NotNull
    public CompressorDataProvider createSection(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new CompressorDataProvider(null, this.compressor);
    }

    @Override
    @NotNull
    public CompressorDataProvider createSection() {
        return new CompressorDataProvider(this.verifiedName(), this.compressor);
    }

    @Override
    public void setString(@Nullable String value) {
        this.compressor.compress(value);
    }

    @Override
    public void setSimpleLocation(@Nullable SimpleLocation value) {
        if (value == null) {
            this.compressor.compressNull();
        } else {
            SimpleLocation simpleLocation;
            SimpleLocation $this$setSimpleLocation_u24lambda_u240 = simpleLocation = value;
            boolean bl = false;
            this.compressor.compress($this$setSimpleLocation_u24lambda_u240.getWorld()).compress($this$setSimpleLocation_u24lambda_u240.getX()).compress($this$setSimpleLocation_u24lambda_u240.getY()).compress($this$setSimpleLocation_u24lambda_u240.getZ());
        }
    }

    @Override
    public void setSimpleChunkLocation(@NotNull SimpleChunkLocation value) {
        SimpleChunkLocation simpleChunkLocation;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        SimpleChunkLocation $this$setSimpleChunkLocation_u24lambda_u241 = simpleChunkLocation = value;
        boolean bl = false;
        this.compressor.compress($this$setSimpleChunkLocation_u24lambda_u241.getWorld()).compress($this$setSimpleChunkLocation_u24lambda_u241.getX()).compress($this$setSimpleChunkLocation_u24lambda_u241.getZ());
    }

    @Override
    public void setUUID(@Nullable UUID value) {
        this.compressor.compress(value);
    }

    @Override
    public void setInt(int value) {
        this.compressor.compress(value);
    }

    @Override
    public void setLong(long value) {
        this.compressor.compress(value);
    }

    @Override
    public void setFloat(float value) {
        this.compressor.compress(value);
    }

    @Override
    public void setDouble(double value) {
        this.compressor.compress(value);
    }

    @Override
    public void setBoolean(boolean value) {
        this.compressor.compress(value);
    }

    @Override
    public void setLocation(@Nullable Location value) {
        DataCompressor dataCompressor = value == null ? this.compressor.compressNull() : this.compressor.compress(value);
    }

    @Override
    public <V> void setCollection(@NotNull Collection<? extends V> collection, @NotNull BiConsumer<SectionCreatableDataSetter, V> elementHandler) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        Intrinsics.checkNotNullParameter(elementHandler, (String)"elementHandler");
        if (collection.isEmpty()) {
            return;
        }
        for (V element : collection) {
            elementHandler.accept(this, element);
        }
    }

    @Override
    public <K, V> void setMap(@NotNull Map<K, ? extends V> map, @NotNull MappingSetterHandler<K, V> handler) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        if (map.isEmpty()) {
            return;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            handler.map(key, new StringMappedIdSetter((Function1<? super String, ? extends SectionCreatableDataSetter>)((Function1)arg_0 -> CompressorDataProvider.setMap$lambda$2(this, arg_0))), value);
        }
    }

    private static final SectionCreatableDataSetter setMap$lambda$2(CompressorDataProvider this$0, String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return new CompressorDataProvider(id, this$0.compressor);
    }
}

