/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.compressor;

import java.awt.Color;
import java.awt.IllegalComponentStateException;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.namespace.Namespaced;
import org.kingdoms.data.compressor.DataCompressRegistry;
import org.kingdoms.server.location.Location;
import org.kingdoms.utils.internal.ByteArrayOutputStream;

public final class DataCompressor {
    public static final DataCompressRegistry REGISTRY = new DataCompressRegistry();
    private static final byte TRUE_BYTE = 1;
    private static final byte FALSE_BYTE = 0;
    private static final byte NULL_BYTE = 0;
    private static final int DEFLATOR_BUFFER_SIZE = 8192;
    private final ByteArrayOutputStream baos;
    private final OutputStream writer;
    private final DataOutputStream primitiveWriter;
    private boolean closed;

    public DataCompressor(int size) {
        this.baos = new ByteArrayOutputStream(size);
        this.writer = new DeflaterOutputStream((OutputStream)this.baos, new Deflater(), size == 0 ? 8192 : Math.min(size, 8192));
        this.primitiveWriter = new DataOutputStream(this.writer);
    }

    public ByteArrayOutputStream result() {
        if (this.closed) {
            throw new IllegalStateException("Already used");
        }
        try {
            this.writer.close();
            this.baos.close();
            this.closed = true;
            return this.baos;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DataCompressor ensureAdditionalCapacity(int additional) {
        this.baos.ensureCapacity(this.baos.size() + additional);
        return this;
    }

    public void registerSize(Class<?> clazz) {
        if (!this.closed) {
            throw new IllegalComponentStateException("Cannot register size when open");
        }
        REGISTRY.registerSize(clazz, this.baos.size());
    }

    public DataCompressor compress(ByteBuffer buffer) {
        this.compress(buffer.array());
        return this;
    }

    public DataCompressor compressDynamically(Object obj) {
        REGISTRY.compress(this, obj);
        return this;
    }

    public DataCompressor compress(byte[] b) {
        try {
            this.writer.write(b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public DataCompressor compressNull() {
        return this.compressByte((byte)0);
    }

    public DataCompressor compressByte(byte b) {
        try {
            this.writer.write(b);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public DataCompressor compress(short i) {
        try {
            this.primitiveWriter.writeShort(i);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public DataCompressor compress(char i) {
        try {
            this.primitiveWriter.writeChar(i);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public DataCompressor compress(float i) {
        try {
            this.primitiveWriter.writeFloat(i);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public DataCompressor compress(int i) {
        try {
            this.primitiveWriter.writeInt(i);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public DataCompressor compress(long i) {
        try {
            this.primitiveWriter.writeLong(i);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public DataCompressor compress(double i) {
        try {
            this.primitiveWriter.writeDouble(i);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public DataCompressor compress(org.bukkit.Location location) {
        if (location == null) {
            return this.compressNull();
        }
        World world = location.getWorld();
        if (world == null) {
            this.compressNull();
        } else {
            this.compress(world.getName());
        }
        return this.compress(location.getX()).compress(location.getY()).compress(location.getZ()).compress(location.getYaw()).compress(location.getPitch());
    }

    public DataCompressor compress(Location location) {
        if (location == null) {
            return this.compressNull();
        }
        return this.compress(location.getWorld().getName()).compress(location.getX()).compress(location.getY()).compress(location.getZ()).compress(location.getYaw()).compress(location.getPitch());
    }

    public DataCompressor compress(Namespaced ns) {
        return this.compress(ns.getNamespace());
    }

    public DataCompressor compress(Namespace ns) {
        if (ns == null) {
            return this.compressNull();
        }
        return this.compress(ns.asNormalizedString());
    }

    public DataCompressor compress(UUID id) {
        if (id == null) {
            return this.compressNull();
        }
        return this.compress(id.getLeastSignificantBits()).compress(id.getMostSignificantBits());
    }

    public DataCompressor compress(boolean bool) {
        this.compressByte(bool ? (byte)1 : 0);
        return this;
    }

    public <T> DataCompressor compressNotNull(T data, BiConsumer<DataCompressor, T> notNullFn) {
        if (data == null) {
            return this.compressNull();
        }
        notNullFn.accept(this, (DataCompressor)data);
        return this;
    }

    public DataCompressor compress(String string) {
        if (string == null) {
            return this.compressNull();
        }
        return this.compress(string.length()).compress(string.getBytes(StandardCharsets.UTF_8));
    }

    public DataCompressor compress(Enum<?> enumerate) {
        if (enumerate == null) {
            return this.compressNull();
        }
        return this.compress(enumerate.ordinal());
    }

    public DataCompressor compress(Color color) {
        if (color == null) {
            return this.compressNull();
        }
        return this.compress(color.getRGB());
    }

    public DataCompressor compress(Inventory inventory) {
        this.compress(inventory.getSize());
        this.ensureAdditionalCapacity(inventory.getSize() * 500);
        for (ItemStack item : inventory.getContents()) {
            if (item == null || item.getType() == Material.AIR) continue;
            this.compress(item.toString());
        }
        return this;
    }

    public <T> DataCompressor compress(Collection<T> collection) {
        return this.compress(collection, 0, DataCompressor::compressDynamically);
    }

    public <T> DataCompressor compress(Collection<T> collection, BiConsumer<DataCompressor, T> function) {
        return this.compress(collection, 0, function);
    }

    public <T> DataCompressor compress(Collection<T> collection, int mod, BiConsumer<DataCompressor, T> function) {
        Objects.requireNonNull(collection, "Cannot compress null collection");
        Objects.requireNonNull(function, "Compress function cannot be null");
        int size = collection.size();
        if (size == 0) {
            return this.compressNull();
        }
        if (mod == 0) {
            mod = size;
        }
        this.ensureAdditionalCapacity(mod * 2);
        this.compress(collection.size());
        for (T element : collection) {
            function.accept(this, (DataCompressor)element);
        }
        return this;
    }

    public <K, V> DataCompressor compress(Map<K, V> map) {
        return this.compress(map, 0, DataCompressor::compressDynamically, DataCompressor::compressDynamically);
    }

    public <K, V> DataCompressor compress(Map<K, V> map, BiConsumer<DataCompressor, K> keyCompressor, BiConsumer<DataCompressor, V> valueCompressor) {
        return this.compress(map, 0, keyCompressor, valueCompressor);
    }

    public <K, V> DataCompressor compress(Map<K, V> map, int mod, BiConsumer<DataCompressor, K> keyCompressor, BiConsumer<DataCompressor, V> valueCompressor) {
        int size = map.size();
        if (size == 0) {
            return this.compressNull();
        }
        if (mod == 0) {
            mod = size;
        }
        this.ensureAdditionalCapacity(mod * 3);
        this.compress(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            keyCompressor.accept(this, entry.getKey());
            V val = entry.getValue();
            valueCompressor.accept(this, val);
        }
        return this;
    }
}

