/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.centers;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.base.KeyedKingdomsObject;
import org.kingdoms.constants.base.KingdomsObject;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.data.centers.DataCenter;
import org.kingdoms.data.database.base.KeyedKingdomsDatabase;
import org.kingdoms.data.database.base.KingdomsDatabase;
import org.kingdoms.data.database.base.SingularKingdomsDatabase;
import org.kingdoms.data.database.flatfile.json.KeyedJsonDatabase;
import org.kingdoms.data.database.flatfile.json.SingularJsonDatabase;
import org.kingdoms.data.database.flatfile.yaml.KeyedYamlDatabase;
import org.kingdoms.data.database.flatfile.yaml.SingularYamlDatabase;
import org.kingdoms.data.database.mongo.KeyedMongoDBDatabase;
import org.kingdoms.data.database.mongo.SingularMongoDBDatabase;
import org.kingdoms.data.database.sql.DatabaseType;
import org.kingdoms.data.database.sql.base.KeyedSQLDatabase;
import org.kingdoms.data.database.sql.base.SingularSQLDatabase;
import org.kingdoms.data.database.sql.connection.SQLConnectionProvider;
import org.kingdoms.data.database.sql.connection.SQLFlatFileConnectionProvider;
import org.kingdoms.data.handlers.abstraction.DataHandler;
import org.kingdoms.data.handlers.abstraction.KeyedDataHandler;
import org.kingdoms.data.handlers.abstraction.SingularDataHandler;
import org.kingdoms.data.managers.GlobalsDataManager;
import org.kingdoms.data.managers.KingdomManager;
import org.kingdoms.data.managers.KingdomPlayerManager;
import org.kingdoms.data.managers.LandManager;
import org.kingdoms.data.managers.MessageTransferAgent;
import org.kingdoms.data.managers.NationManager;
import org.kingdoms.dependencies.Dependency;
import org.kingdoms.libs.jetbrains.annotations.ApiStatus;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.string.Strings;

public class KingdomsDataCenter
extends DataCenter {
    public static final String DATA_FOLDER_NAME = "data";
    public static final Path DATA_FOLDER = Kingdoms.getPath("data");
    private final KingdomManager kingdomManager;
    private final NationManager nationManager;
    private final LandManager landManager;
    private final KingdomPlayerManager kingdomPlayerManager;
    private final MessageTransferAgent mtg;
    private final GlobalsDataManager globals;
    private final Path path;
    private SQLConnectionProvider sqlConnectionProvider;

    @ApiStatus.Internal
    public static KingdomsDataCenter createDefault() {
        return new KingdomsDataCenter(Namespace.kingdoms("MAIN"), KingdomsDataCenter.getDefaultDatabaseType(), KingdomsDataCenter.getDefaultPath(), KingdomsConfig.DATABASE_AUTO_SAVE_INTERVAL.getTime(), KingdomsConfig.DATABASE_LOAD_ALL_DATA_ON_STARTUP.getBoolean(), false, KingdomsConfig.DATABASE_SMART_SAVE.getBoolean());
    }

    @ApiStatus.Internal
    public KingdomsDataCenter(Namespace namespace, DatabaseType databaseType, Path path, Duration autoSaveInterval, boolean staticCache, boolean temporary, boolean smartSaving) {
        super(namespace, databaseType, autoSaveInterval, staticCache, temporary, smartSaving);
        this.path = path;
        this.globals = this.register(new GlobalsDataManager(this));
        this.nationManager = this.register(new NationManager(this));
        this.kingdomManager = this.register(new KingdomManager(this));
        this.landManager = this.register(new LandManager(this));
        this.kingdomPlayerManager = this.register(new KingdomPlayerManager(this));
        this.mtg = this.register(new MessageTransferAgent(this));
    }

    private static void loadDatabaseLibraries(List<Dependency> dependencies) {
        Kingdoms.get().getDependencyManager().loadDependencies(dependencies);
    }

    @Override
    public <K, T extends KeyedKingdomsObject<K>> KeyedKingdomsDatabase<K, T> constructDatabase(String name, String table, KeyedDataHandler<K, T> dataHandler) {
        return (KeyedKingdomsDatabase)this.constructDatabase0(name, table, dataHandler);
    }

    @Override
    public <T extends KingdomsObject> SingularKingdomsDatabase<T> constructDatabase(String name, String table, SingularDataHandler<T> dataHandler) {
        return (SingularKingdomsDatabase)this.constructDatabase0(name, table, dataHandler);
    }

    private static Path getDefaultPath() {
        Path path = Kingdoms.getFolder();
        if (KingdomsConfig.DATABASE_USE_DATA_FOLDER.getManager().noDefault().getBoolean()) {
            path = Kingdoms.getPath(DATA_FOLDER_NAME);
        }
        return path;
    }

    public static DatabaseType getDefaultDatabaseType() {
        String db = Strings.deleteWhitespace(KingdomsConfig.DATABASE_METHOD.getString()).toLowerCase(Locale.ENGLISH);
        DatabaseType databaseType = Arrays.stream(DatabaseType.values()).filter(x -> x.name().toLowerCase().equals(db)).findFirst().orElse(null);
        if (databaseType == null) {
            throw new IllegalArgumentException("Unknown database type: " + db);
        }
        return databaseType;
    }

    @Override
    protected <T extends KingdomsObject> KingdomsDatabase<T> constructDatabase0(String name, String table, DataHandler<T> dataHandler) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(table);
        Objects.requireNonNull(dataHandler);
        boolean singular = dataHandler instanceof SingularDataHandler;
        boolean loadedInitials = this.loadedInitials;
        this.loadedInitials = true;
        switch (this.databaseType) {
            case JSON: {
                if (singular) {
                    return new SingularJsonDatabase(this.path.resolve(name + ".json"), (SingularDataHandler)dataHandler);
                }
                return new KeyedJsonDatabase(this.path.resolve(name), (KeyedDataHandler)dataHandler);
            }
            case YAML: {
                if (singular) {
                    return new SingularYamlDatabase(this.path.resolve(name + ".yml"), (SingularDataHandler)dataHandler);
                }
                return new KeyedYamlDatabase(this.path.resolve(name), (KeyedDataHandler)dataHandler);
            }
            case MongoDB: {
                if (!loadedInitials) {
                    KLogger.info("Loading Mongo libraries for " + name + " database...");
                    KingdomsDataCenter.loadDatabaseLibraries(Arrays.asList(DatabaseType.MongoDB.getDependencies()));
                    KLogger.info("Loaded all libraries.");
                }
                if (singular) {
                    return SingularMongoDBDatabase.withCollection(table, (SingularDataHandler)dataHandler);
                }
                return KeyedMongoDBDatabase.withCollection(table, (KeyedDataHandler)dataHandler);
            }
        }
        if (!loadedInitials) {
            KLogger.info("Loading SQL libraries for " + name + " database...");
            KingdomsDataCenter.loadDatabaseLibraries(Arrays.asList(Dependency.HIKARI, Dependency.SLF4J_SIMPLE));
        }
        if (this.sqlConnectionProvider == null) {
            this.sqlConnectionProvider = SQLConnectionProvider.getProvider(this.path, this.databaseType);
        }
        if (!loadedInitials) {
            Path file;
            if (this.databaseType == DatabaseType.H2 && this.sqlConnectionProvider instanceof SQLFlatFileConnectionProvider && Files.exists(file = ((SQLFlatFileConnectionProvider)this.sqlConnectionProvider).getFile(), new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(file);){
                    String headerLine = reader.readLine().replace(" ", "");
                    if (headerLine.contains("format:2")) {
                        Dependency.H2_DRIVER.setDefaultVersion("2.1.214");
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read H2 database file: " + file, e);
                }
            }
            KingdomsDataCenter.loadDatabaseLibraries(Arrays.asList(this.databaseType.getDependencies()));
            KLogger.info("Loaded all libraries.");
        }
        if (!loadedInitials) {
            this.sqlConnectionProvider.connect();
            this.sqlConnectionProvider.runSchema();
        }
        table = SQLConnectionProvider.TABLE_PREFIX + table;
        if (singular) {
            return new SingularSQLDatabase(this.databaseType, table, (SingularDataHandler)dataHandler, this.sqlConnectionProvider);
        }
        return new KeyedSQLDatabase(this.databaseType, table, (KeyedDataHandler)dataHandler, this.sqlConnectionProvider);
    }

    public MessageTransferAgent getMTG() {
        return this.mtg;
    }

    public KingdomManager getKingdomManager() {
        return this.kingdomManager;
    }

    public NationManager getNationManager() {
        return this.nationManager;
    }

    public LandManager getLandManager() {
        return this.landManager;
    }

    public KingdomPlayerManager getKingdomPlayerManager() {
        return this.kingdomPlayerManager;
    }

    public GlobalsDataManager getGlobals() {
        return this.globals;
    }

    public static KingdomsDataCenter get() {
        return Kingdoms.get().getDataCenter();
    }

    @ApiStatus.Internal
    public SQLConnectionProvider getSqlConnectionProvider() {
        return this.sqlConnectionProvider;
    }

    @Override
    public void close() {
        super.close();
        if (this.sqlConnectionProvider != null) {
            this.sqlConnectionProvider.close();
            this.sqlConnectionProvider = null;
        }
    }
}

