/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.top;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.kingdoms.constants.top.TopData;
import org.kingdoms.libs.checkerframework.common.value.qual.IntRange;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Unmodifiable;
import org.kingdoms.utils.Validate;
import org.kingdoms.utils.internal.IndexedHashMap;

public abstract class IndexedTopData<K, V>
implements TopData<V> {
    private final IndexedHashMap<K, Integer> cache;
    private final Comparator<V> reversedComparator = this.reversed();

    public IndexedTopData() {
        this.cache = new IndexedHashMap(this.createKeyArray(0));
    }

    @Override
    public Optional<V> getTopPosition(int position) {
        Validate.isTrue(position > 0, "Kingdom top positions start at 1");
        K id = this.cache.at(position - 1);
        if (id == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.fetchData(id));
    }

    @Override
    public @IntRange(from=1L) Optional<Integer> getPositionOf(@NotNull V data) {
        Objects.requireNonNull(data, "Cannot get position of null data");
        Integer cached = this.cache.get(this.getKey(data));
        if (cached == null) {
            return Optional.empty();
        }
        return Optional.of(cached + 1);
    }

    @Override
    public List<V> getTop(int skip, int limit, Predicate<V> predicate) {
        return Collections.unmodifiableList(this.cache.subList(skip, limit, id -> {
            V kingdom = this.fetchData(id);
            if (kingdom == null) {
                return null;
            }
            return predicate == null || predicate.test(kingdom) ? kingdom : null;
        }));
    }

    @Override
    public void update(Collection<V> allData) {
        if (allData.isEmpty()) {
            return;
        }
        K[] keys = this.createKeyArray(allData.size());
        V[] values = allData.toArray(this.createValueArray(keys.length));
        Arrays.sort(values, this.reversedComparator);
        for (int i = 0; i < values.length; ++i) {
            keys[i] = this.getKey(values[i]);
        }
        this.cache.set(keys, x -> x);
    }

    @Override
    @NotNull
    public @Unmodifiable List<V> getTop() {
        ArrayList<V> data = new ArrayList<V>(this.cache.size());
        for (K key : this.cache.asArray()) {
            data.add(this.fetchData(key));
        }
        return Collections.unmodifiableList(data);
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    protected abstract K[] createKeyArray(int var1);

    protected abstract V[] createValueArray(int var1);

    protected abstract K getKey(V var1);

    protected abstract V fetchData(K var1);
}

