/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.stats;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.namespace.NamespacedMap;
import org.kingdoms.constants.stats.GroupedStat;
import org.kingdoms.constants.stats.NumberStat;
import org.kingdoms.constants.stats.Stat;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.enums.EnumEntries;
import org.kingdoms.libs.kotlin.enums.EnumEntriesKt;
import org.kingdoms.libs.kotlin.jvm.JvmOverloads;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\"\u0010\u0005\u001a\u00020\u00022\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bJ1\u0010\f\u001a\u0002H\r\"\b\b\u0000\u0010\r*\u00020\u00022\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\r0\u000b\u00a2\u0006\u0002\u0010\u000eJ\u001e\u0010\u000f\u001a\u0004\u0018\u00010\u00022\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u0002J \u0010\u0010\u001a\u00020\u00112\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\u0012\u001a\u00020\u0011H\u0007J?\u0010\u0013\u001a\u0004\u0018\u0001H\r\"\b\b\u0000\u0010\r*\u00020\u00022\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0014\u001a\u00020\u00152\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u0002H\r\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lorg/kingdoms/constants/stats/Statistics;", "Lorg/kingdoms/constants/namespace/NamespacedMap;", "Lorg/kingdoms/constants/stats/Stat;", "<init>", "()V", "find", "Ljava/util/Optional;", "path", "", "Lorg/kingdoms/constants/namespace/Namespace;", "default", "Ljava/util/function/Supplier;", "findOrAdd", "T", "(Ljava/util/List;Ljava/util/function/Supplier;)Lorg/kingdoms/constants/stats/Stat;", "addOrReplace", "inc", "", "by", "internalOp", "op", "Lorg/kingdoms/constants/stats/Statistics$InternalOp;", "(Ljava/util/List;Lorg/kingdoms/constants/stats/Statistics$InternalOp;Ljava/util/function/Supplier;)Lorg/kingdoms/constants/stats/Stat;", "InternalOp", "core"})
@SourceDebugExtension(value={"SMAP\nStatistics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Statistics.kt\norg/kingdoms/constants/stats/Statistics\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,256:1\n1#2:257\n*E\n"})
public final class Statistics
extends NamespacedMap<Stat> {
    @NotNull
    public final Optional<Stat> find(@NotNull List<Namespace> path) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        Optional<Stat> optional = Optional.ofNullable(this.internalOp(path, InternalOp.FIND, null));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    @NotNull
    public final Stat find(@NotNull List<Namespace> path, @NotNull Supplier<Stat> supplier) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        Intrinsics.checkNotNullParameter(supplier, (String)"default");
        Stat stat = this.internalOp(path, InternalOp.FIND, supplier);
        Intrinsics.checkNotNull((Object)stat);
        return stat;
    }

    @NotNull
    public final <T extends Stat> T findOrAdd(@NotNull List<Namespace> path, @NotNull Supplier<T> supplier) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        Intrinsics.checkNotNullParameter(supplier, (String)"default");
        T t = this.internalOp(path, InternalOp.ADD_IF_ABSENT, supplier);
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type T of org.kingdoms.constants.stats.Statistics.findOrAdd");
        return t;
    }

    @Nullable
    public final Stat addOrReplace(@NotNull List<Namespace> path, @NotNull Stat stat) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)stat, (String)"default");
        return this.internalOp(path, InternalOp.REPLACE, () -> Statistics.addOrReplace$lambda$0(stat));
    }

    @JvmOverloads
    public final long inc(@NotNull List<Namespace> path, long by) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        if (!(by != 0L)) {
            boolean bl = false;
            String string = "Cannot increment stat by zero";
            throw new IllegalArgumentException(string.toString());
        }
        NumberStat stat = this.findOrAdd(path, Statistics::inc$lambda$2);
        stat.setValue(stat.getValue() + by);
        return stat.getValue();
    }

    public static /* synthetic */ long inc$default(Statistics statistics, List list, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = 1L;
        }
        return statistics.inc(list, l);
    }

    private final <T extends Stat> T internalOp(List<Namespace> path, InternalOp op, Supplier<T> supplier) {
        boolean create;
        boolean bl = create = op == InternalOp.ADD_IF_ABSENT || op == InternalOp.REPLACE;
        if (create && !(supplier != null)) {
            boolean $i$a$-require-Statistics$internalOp$22 = false;
            String $i$a$-require-Statistics$internalOp$22 = "Cannot add when the default provided value is null";
            throw new IllegalArgumentException($i$a$-require-Statistics$internalOp$22.toString());
        }
        Statistics lastStats = this;
        Stat lastStat = null;
        Iterator iterator = ((Iterable)path).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            Namespace namespace = (Namespace)iterator.next();
            if (lastStats == null) {
                throw new IllegalArgumentException("Path doesn't refer to a stat group at position " + namespace.asNormalizedString() + ": " + CollectionsKt.joinToString$default((Iterable)path, null, null, null, (int)0, null, Statistics::internalOp$lambda$4, (int)31, null));
            }
            boolean isLastOne = index + 1 == path.size();
            Stat stat = lastStat = isLastOne && op == InternalOp.REPLACE ? null : (Stat)lastStats.get((Object)namespace);
            if (lastStat == null) {
                if (isLastOne) {
                    Stat finalValue;
                    Supplier<T> supplier2 = supplier;
                    Stat stat2 = finalValue = supplier2 != null ? (Stat)supplier2.get() : null;
                    if (create) {
                        Map map = lastStats;
                        Stat stat3 = finalValue;
                        Intrinsics.checkNotNull((Object)stat3);
                        map.put(namespace, stat3);
                        lastStat = finalValue;
                        continue;
                    }
                    return (T)finalValue;
                }
                if (create) {
                    Statistics innerStats = new Statistics();
                    lastStat = new GroupedStat(innerStats);
                    ((Map)lastStats).put(namespace, lastStat);
                    lastStats = innerStats;
                    continue;
                }
                Supplier<T> supplier3 = supplier;
                return (T)(supplier3 != null ? (Stat)supplier3.get() : null);
            }
            if (!(lastStat instanceof GroupedStat)) continue;
            lastStats = ((GroupedStat)lastStat).getValue();
        }
        return (T)lastStat;
    }

    @JvmOverloads
    public final long inc(@NotNull List<Namespace> path) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        return Statistics.inc$default(this, path, 0L, 2, null);
    }

    private static final Stat addOrReplace$lambda$0(Stat $default) {
        return $default;
    }

    private static final NumberStat inc$lambda$2() {
        return new NumberStat(0L);
    }

    private static final CharSequence internalOp$lambda$4(Namespace it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.asNormalizedString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asNormalizedString(...)");
        return string;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/kingdoms/constants/stats/Statistics$InternalOp;", "", "<init>", "(Ljava/lang/String;I)V", "FIND", "ADD_IF_ABSENT", "REPLACE", "core"})
    private static final class InternalOp
    extends Enum<InternalOp> {
        public static final /* enum */ InternalOp FIND = new InternalOp();
        public static final /* enum */ InternalOp ADD_IF_ABSENT = new InternalOp();
        public static final /* enum */ InternalOp REPLACE = new InternalOp();
        private static final /* synthetic */ InternalOp[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static InternalOp[] values() {
            return (InternalOp[])$VALUES.clone();
        }

        public static InternalOp valueOf(String value) {
            return Enum.valueOf(InternalOp.class, value);
        }

        @NotNull
        public static EnumEntries<InternalOp> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = internalOpArray = new InternalOp[]{InternalOp.FIND, InternalOp.ADD_IF_ABSENT, InternalOp.REPLACE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

