/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.stats;

import java.util.Map;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.stats.AbstractStat;
import org.kingdoms.constants.stats.Stat;
import org.kingdoms.constants.stats.StatRegistry;
import org.kingdoms.constants.stats.Statistics;
import org.kingdoms.data.database.dataprovider.DataGetter;
import org.kingdoms.data.database.dataprovider.MappedIdSetter;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bH\u0016J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0016\u0010\u0011\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u0014"}, d2={"Lorg/kingdoms/constants/stats/GroupedStat;", "Lorg/kingdoms/constants/stats/AbstractStat;", "value", "Lorg/kingdoms/constants/stats/Statistics;", "<init>", "(Lorg/kingdoms/constants/stats/Statistics;)V", "getValue", "()Lorg/kingdoms/constants/stats/Statistics;", "setValue", "getNamespace", "Lorg/kingdoms/constants/namespace/Namespace;", "Lorg/kingdoms/libs/jetbrains/annotations/NotNull;", "deserialize", "", "context", "Lorg/kingdoms/constants/land/abstraction/data/DeserializationContext;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataGetter;", "serialize", "Lorg/kingdoms/constants/land/abstraction/data/SerializationContext;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "core"})
public final class GroupedStat
extends AbstractStat {
    @NotNull
    private Statistics value;

    public GroupedStat(@NotNull Statistics value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
    }

    @Override
    @NotNull
    public Statistics getValue() {
        return this.value;
    }

    public void setValue(@NotNull Statistics statistics) {
        Intrinsics.checkNotNullParameter((Object)statistics, (String)"<set-?>");
        this.value = statistics;
    }

    @Override
    @NotNull
    public Namespace getNamespace() {
        return StatRegistry.NS_GROUP;
    }

    @Override
    public void deserialize(@NotNull DeserializationContext<SectionableDataGetter> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        this.setValue(new Statistics());
        context.getDataProvider().asMap((Map)this.getValue(), (arg_0, arg_1, arg_2) -> GroupedStat.deserialize$lambda$1(this, arg_0, arg_1, arg_2));
    }

    @Override
    public void serialize(@NotNull SerializationContext<SectionableDataSetter> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        context.getDataProvider().setMap(this.getValue(), GroupedStat::serialize$lambda$2);
    }

    private static final void deserialize$lambda$1(GroupedStat this$0, Statistics statistics, DataGetter keyProvider, SectionableDataGetter valueProvider) {
        block0: {
            String string = keyProvider.asString();
            Intrinsics.checkNotNull((Object)string);
            Namespace namespace = Namespace.fromString(string);
            Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"fromString(...)");
            Namespace ns = namespace;
            Intrinsics.checkNotNull((Object)valueProvider);
            Stat stat = StatRegistry.deserializeStat(valueProvider);
            if (stat == null) break block0;
            Stat it = stat;
            boolean bl = false;
            this$0.getValue().put(ns, it);
        }
    }

    private static final void serialize$lambda$2(Namespace key, MappedIdSetter keyProvider, Stat value) {
        Intrinsics.checkNotNullParameter((Object)keyProvider, (String)"keyProvider");
        keyProvider.setString(key.asNormalizedString());
        SectionableDataSetter valueProvider = keyProvider.getValueProvider().createSection();
        Intrinsics.checkNotNull((Object)value);
        StatRegistry.serializeStat(value, valueProvider);
    }
}

