/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.player;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.jetbrains.annotations.ApiStatus;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Unmodifiable;
import org.kingdoms.utils.Validate;
import org.kingdoms.utils.internal.nonnull.NonNullMap;

public class RankMap
implements Cloneable,
Iterable<Rank> {
    protected final @NonNull Map<String, Rank> main;
    protected final @NonNull TreeMap<Integer, Rank> sorted;

    public RankMap() {
        this.main = new NonNullMap<String, Rank>();
        this.sorted = new TreeMap(Integer::compareTo);
    }

    protected void clear() {
        this.main.clear();
        this.sorted.clear();
    }

    public RankMap(@NonNull Map<String, Rank> main, @NonNull TreeMap<Integer, Rank> sorted) {
        Validate.isTrue(main.size() == sorted.size(), "The rank map size doesn't match the sorted map size: " + main.size() + " - " + sorted.size());
        this.main = Objects.requireNonNull(main, "Ranks map cannot be null");
        this.sorted = Objects.requireNonNull(sorted, "Ranks sorted map cannot be null");
    }

    public RankMap(@NonNull Map<String, Rank> main) {
        this.main = Objects.requireNonNull(main, "Ranks map cannot be null");
        this.sorted = new TreeMap(Integer::compareTo);
        for (Rank rank : main.values()) {
            this.sorted.put(rank.getPriority(), rank);
        }
        Validate.isTrue(main.size() == this.sorted.size(), "The rank map size doesn't match the sorted map size: " + main.size() + " - " + this.sorted.size());
    }

    public RankMap(@NonNull TreeMap<Integer, Rank> sorted) {
        this.sorted = Objects.requireNonNull(sorted, "Ranks map cannot be null");
        this.main = new NonNullMap<String, Rank>(sorted.size());
        for (Rank rank : sorted.values()) {
            this.main.put(rank.getNode(), rank);
        }
        Validate.isTrue(this.main.size() == sorted.size(), "The rank map size doesn't match the sorted map size: " + this.main.size() + " - " + sorted.size());
    }

    @ApiStatus.Internal
    public static void changePriority(Rank rank, int priority) {
        rank.setPriority(priority);
    }

    public @Nullable Rank get(int priority) {
        return this.sorted.get(priority);
    }

    public @Nullable Rank get(@NonNull String node) {
        return this.main.get(node);
    }

    public boolean has(int priority) {
        return this.sorted.containsKey(priority);
    }

    public boolean has(@NonNull String node) {
        return this.main.containsKey(node);
    }

    public void updateNode(@NonNull String node, @NonNull String newNode) {
        Rank rank = Objects.requireNonNull(this.main.remove(node), "Cannot update a rank's node that's not in the map");
        rank.setNode(newNode);
        this.main.put(newNode, rank);
        this.sorted.put(rank.getPriority(), rank);
    }

    private void validatePriority(int priority) {
        if (priority <= 0) {
            throw new IllegalArgumentException("Priority must be greater than zero: " + priority);
        }
        if (priority >= this.sorted.size()) {
            throw new IllegalArgumentException("Out of range priority: " + priority + " - " + this);
        }
    }

    public void switchPriorities(int firstPriority, int secondPriority) {
        this.validatePriority(firstPriority);
        this.validatePriority(secondPriority);
        Rank first = this.sorted.get(firstPriority);
        Rank second = this.sorted.get(secondPriority);
        first.setPriority(secondPriority);
        second.setPriority(firstPriority);
        this.sorted.put(first.getPriority(), first);
        this.sorted.put(second.getPriority(), second);
    }

    public void add(@NonNull Rank rank) {
        Objects.requireNonNull(rank, "Cannot add null rank");
        if (rank.getPriority() < 0) {
            throw new IllegalArgumentException("Rank priority can't be a negative number: " + rank.toShortString());
        }
        if (rank.getPriority() > this.sorted.size()) {
            throw new IllegalArgumentException("Sparse rank addition: " + rank.toShortString() + " -> " + this);
        }
        if (this.main.containsKey(rank.getNode())) {
            throw new IllegalArgumentException("Rank with node already exists: " + rank.toShortString());
        }
        if (this.sorted.containsKey(rank.getPriority())) {
            throw new IllegalArgumentException("Rank with priority already exists: " + rank.toShortString());
        }
        this.sorted.put(rank.getPriority(), rank);
        this.main.put(rank.getNode(), rank);
    }

    public int size() {
        return this.main.size();
    }

    public @NonNull RankMap clone() {
        NonNullMap<String, Rank> cloneMain = new NonNullMap<String, Rank>(this.main.size());
        TreeMap<Integer, Rank> cloneSorted = new TreeMap<Integer, Rank>(Integer::compareTo);
        for (Map.Entry<String, Rank> entry : this.main.entrySet()) {
            Rank rank = entry.getValue().clone();
            cloneMain.put(entry.getKey(), rank);
            cloneSorted.put(rank.getPriority(), rank);
        }
        return new RankMap(cloneMain, cloneSorted);
    }

    public @Nullable Rank remove(@NonNull String node) {
        Rank rank = this.main.remove(node);
        if (rank == null) {
            return null;
        }
        Objects.requireNonNull(this.sorted.remove(rank.getPriority()), () -> "Sorted rank map does not contain rank: " + rank.toShortString());
        this.fillSparsePriority(rank.getPriority());
        return rank;
    }

    public String toString() {
        return "RankMap {" + this.main.entrySet().stream().map(x -> (String)x.getKey() + " -> " + ((Rank)x.getValue()).getNode() + ':' + ((Rank)x.getValue()).getPriority()).collect(Collectors.toList()) + '\n' + this.sorted.entrySet().stream().map(x -> x.getKey() + " -> " + ((Rank)x.getValue()).getNode() + ':' + ((Rank)x.getValue()).getPriority()).collect(Collectors.toList()) + '\n' + '}';
    }

    private void fillSparsePriority(int priority) {
        int size = this.size();
        ++priority;
        while (priority < size + 1) {
            Rank removed = this.sorted.remove(priority);
            if (removed != null) {
                int newPriority = removed.getPriority() - 1;
                removed.setPriority(newPriority);
                this.sorted.put(removed.getPriority(), removed);
            }
            ++priority;
        }
    }

    public @Nullable Rank remove(@NonNull Rank rank) {
        return this.remove(rank.getNode());
    }

    public @NonNull @Unmodifiable SortedMap<Integer, Rank> getSortedRanks() {
        return Collections.unmodifiableSortedMap(this.sorted);
    }

    @ApiStatus.Internal
    public @NonNull SortedMap<Integer, Rank> unsafeGetSortedRanks() {
        return this.sorted;
    }

    public @NonNull @Unmodifiable Map<String, Rank> getNodedRanks() {
        return Collections.unmodifiableMap(this.main);
    }

    @ApiStatus.Internal
    public @NonNull Map<String, Rank> unsafeGetNodedRanks() {
        return this.main;
    }

    public @NonNull Rank getLowestRank() {
        return this.sorted.lastEntry().getValue();
    }

    public @NonNull Rank getHighestRank() {
        return this.sorted.firstEntry().getValue();
    }

    public boolean isMemberRank(@NonNull Rank rank) {
        return rank.getPriority() == this.size() - 1;
    }

    @Override
    @NotNull
    public Iterator<Rank> iterator() {
        return this.sorted.values().iterator();
    }
}

