/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.player;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.abstraction.InvasionOperator;
import org.kingdoms.abstraction.KingdomOperator;
import org.kingdoms.abstraction.NamespacedFlagsContainer;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.base.KeyedKingdomsObject;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.objects.JailStructure;
import org.kingdoms.constants.mails.Mail;
import org.kingdoms.constants.namespace.NamespacedFlags;
import org.kingdoms.constants.namespaces.DefaultDataFlags;
import org.kingdoms.constants.player.ClaimingHistory;
import org.kingdoms.constants.player.KingdomInvite;
import org.kingdoms.constants.player.KingdomPermission;
import org.kingdoms.constants.player.KingdomsChatChannel;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.data.Pair;
import org.kingdoms.data.centers.KingdomsDataCenter;
import org.kingdoms.data.handlers.DataHandlerKingdomPlayer;
import org.kingdoms.data.handlers.abstraction.DataHandler;
import org.kingdoms.events.general.GroupResourcePointConvertEvent;
import org.kingdoms.events.general.ranks.PlayerRankChangeContext;
import org.kingdoms.events.general.ranks.PlayerRankChangeEvent;
import org.kingdoms.events.lands.KingdomFlightToggleEvent;
import org.kingdoms.events.members.KingdomJoinEvent;
import org.kingdoms.events.members.KingdomLeaveEvent;
import org.kingdoms.events.members.LeaveReason;
import org.kingdoms.events.members.PlayerChangeChatChannelEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.jetbrains.annotations.ApiStatus;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.locale.Language;
import org.kingdoms.locale.LanguageManager;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.managers.FlyManager;
import org.kingdoms.managers.invasions.Invasion;
import org.kingdoms.managers.land.map.KingdomsMap;
import org.kingdoms.managers.resourcepoints.ConvertedResourcePoints;
import org.kingdoms.server.core.Server;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.Validate;
import org.kingdoms.utils.internal.nonnull.NonNullMap;
import org.kingdoms.utils.internal.uuid.FastUUID;

public class KingdomPlayer
extends KeyedKingdomsObject<UUID>
implements Comparable<KingdomPlayer>,
InvasionOperator,
KingdomOperator,
NamespacedFlagsContainer {
    private final transient @NonNull LinkedList<ClaimingHistory> landHistory = new LinkedList();
    private long joinedAt;
    private long lastPowerCheckup;
    private long lastDonationTime;
    private double totalDonations;
    private double lastDonationAmount;
    private @Nullable UUID kingdom;
    private final transient UUID id;
    private transient boolean autoMap;
    private transient boolean flying;
    private transient Boolean autoClaim;
    private NamespacedFlags flags;
    private transient @Nullable Invasion invasion;
    private @NonNull Set<UUID> readMails;
    private @Nullable String rank;
    private @Nullable String nationalRank;
    private @Nullable String markersType;
    private @NonNull Map<UUID, KingdomInvite> invites;
    private @NonNull Set<SimpleChunkLocation> claims;
    private @NonNull Set<SimpleLocation> protectedBlocks;
    private transient int landHistoryPosition = -1;
    private double power;
    private @NonNull Language language = LanguageManager.getDefaultLanguage();
    private @Nullable Pair<Integer, Integer> mapSize;
    private @Nullable SimpleLocation jailCell;
    private @Nullable String chatChannel;
    private @NonNull Set<String> mutedChannels;

    public KingdomPlayer(@Nullable UUID id, @Nullable UUID kingdom, long joinedAt) {
        this.id = id;
        this.kingdom = kingdom;
        this.joinedAt = joinedAt;
        this.lastPowerCheckup = System.currentTimeMillis();
        this.claims = new HashSet<SimpleChunkLocation>();
        this.invites = new NonNullMap<UUID, KingdomInvite>();
        this.readMails = new HashSet<UUID>();
        this.protectedBlocks = new HashSet<SimpleLocation>();
        this.chatChannel = KingdomsChatChannel.getGlobalChannel().getDataId();
        this.mutedChannels = new HashSet<String>();
        this.flags = new NamespacedFlags(DefaultDataFlags.Players.DEFAULTS);
        if (id != null) {
            KingdomsDataCenter.get().getKingdomPlayerManager().cache(this, true);
        }
    }

    public KingdomPlayer(@NonNull UUID id, @Nullable UUID kingdom, @NonNull Language language, @Nullable String rank, @Nullable String nationalRank, @NonNull String chatChannel, @Nullable String markersType, long joinedAt, double power, long lastDonationTime, double lastDonationAmount, double totalDonations, long lastPowerCheckup, @NonNull Set<UUID> readMails, @NonNull Map<UUID, KingdomInvite> invites, @Nullable Set<SimpleChunkLocation> claims, @Nullable Pair<Integer, Integer> mapSize, NamespacedFlags flags, @NonNull Set<String> mutedChannels, Set<SimpleLocation> protectedBlocks) {
        this.id = id;
        this.kingdom = kingdom;
        this.rank = rank;
        this.nationalRank = nationalRank;
        this.markersType = markersType;
        this.chatChannel = Objects.requireNonNull(chatChannel, "Player chat channel cannot be null");
        this.joinedAt = joinedAt;
        this.power = power;
        this.mutedChannels = Objects.requireNonNull(mutedChannels);
        this.protectedBlocks = Objects.requireNonNull(protectedBlocks);
        this.lastPowerCheckup = lastPowerCheckup;
        this.language = language;
        this.flags = flags;
        this.lastDonationTime = lastDonationTime;
        this.lastDonationAmount = lastDonationAmount;
        this.totalDonations = totalDonations;
        this.readMails = readMails;
        this.invites = invites;
        this.claims = Objects.requireNonNull(claims, "Player claims cannot be null");
        this.mapSize = mapSize;
    }

    public static @NonNull KingdomPlayer getKingdomPlayer(@NonNull OfflinePlayer player) {
        return KingdomPlayer.getKingdomPlayer(player.getUniqueId());
    }

    public static @NonNull KingdomPlayer getKingdomPlayer(@NonNull UUID id) {
        KingdomPlayer kp = (KingdomPlayer)KingdomsDataCenter.get().getKingdomPlayerManager().getOrLoadData(id);
        return kp == null ? new KingdomPlayer(id, null, System.currentTimeMillis()) : kp;
    }

    public boolean hasKingdom() {
        return this.kingdom != null;
    }

    public int countUnreadMails(Map<UUID, Mail> mails) {
        return (int)mails.values().stream().filter(this::isUnreadMail).count();
    }

    public boolean isUnreadMail(Mail mail) {
        return !this.id.equals(mail.getSender()) && !this.readMails.contains(mail.getId());
    }

    public @Nullable Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.id);
    }

    public boolean isInSameKingdomAs(KingdomPlayer kp) {
        return this.kingdom != null && kp.kingdom != null && FastUUID.equals(this.kingdom, kp.kingdom);
    }

    public @NonNull OfflinePlayer getOfflinePlayer() {
        return Bukkit.getOfflinePlayer((UUID)this.id);
    }

    @Override
    public @Nullable Kingdom getKingdom() {
        if (this.kingdom == null) {
            return null;
        }
        Kingdom kingdom = Kingdom.getKingdom(this.kingdom);
        if (kingdom == null) {
            MessageHandler.sendConsolePluginMessage("&4Invalid kingdom data &e" + this.kingdom + " &4for player &e" + this.getOfflinePlayer().getName() + " (" + this.id + ") &4removing player data...");
            this.silentlyLeaveKingdom();
            return null;
        }
        return kingdom;
    }

    public SimpleLocation getJailCell() {
        return this.jailCell;
    }

    public void setJailCell(SimpleLocation jailCell) {
        this.jailCell = jailCell;
    }

    public @Nullable Rank getRank() {
        Kingdom kingdom = this.getKingdom();
        if (kingdom == null) {
            return null;
        }
        if (this.rank == null) {
            return kingdom.getRanks().getLowestRank();
        }
        Rank rank = kingdom.getRanks().get(this.rank);
        if (rank != null) {
            return rank;
        }
        rank = Objects.equals(this.id, kingdom.getKingId()) ? kingdom.getRanks().getHighestRank() : kingdom.getRanks().getLowestRank();
        this.rank = rank.getNode();
        return rank;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.id + " | " + this.getOfflinePlayer().getName() + ')';
    }

    @ApiStatus.Internal
    public void unsafeSetRank(@Nullable String rank) {
        this.rank = rank;
    }

    @ApiStatus.Internal
    public void unsafeSetNationalRank(@Nullable String nationalRank) {
        this.nationalRank = nationalRank;
    }

    public @NonNull PlayerRankChangeEvent changeRank(@NonNull PlayerRankChangeContext context) {
        Objects.requireNonNull(context, "Cannot change rank with null context");
        Group group = context.getGroup();
        Rank rank = group instanceof Kingdom ? this.getRank() : this.getNationRank();
        Rank newRank = context.getNewRank().identify(group, this);
        if (!context.getIgnoreChecks() && newRank.isKing()) {
            throw new IllegalStateException("Jumping from rank " + rank.getNode() + " (" + rank.getPriority() + ") to king rank " + newRank.getNode() + " (" + newRank.getPriority() + ") (hint: Use Kingdom#setKing() instead)");
        }
        PlayerRankChangeEvent event = new PlayerRankChangeEvent(rank, newRank, group, this, context.getByPlayer());
        if (context.getEventModifier() != null) {
            context.getEventModifier().accept(event);
        }
        if (!event.isCancelled()) {
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return event;
            }
        }
        boolean isDefaultRank = group.getRanks().isMemberRank(newRank);
        if (group instanceof Kingdom) {
            this.rank = isDefaultRank ? null : newRank.getNode();
        } else {
            this.nationalRank = isDefaultRank ? null : newRank.getNode();
        }
        return event;
    }

    public @Nullable String getRankNode() {
        return this.rank;
    }

    public KingdomLeaveEvent leaveKingdom(LeaveReason reason) {
        Objects.requireNonNull(reason, "Kingdom leave reason cannot be null");
        Objects.requireNonNull(this.kingdom, "Player is not a member of a kingdom to leave");
        KingdomLeaveEvent event = new KingdomLeaveEvent(this, reason);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        this.getKingdom().unsafeGetMembers().remove(this.id);
        if (this.jailCell != null) {
            Land land = this.jailCell.toSimpleChunkLocation().getLand();
            JailStructure jailCellStructure = (JailStructure)land.getStructures().get(this.jailCell.toBlockVector());
            jailCellStructure.release();
        }
        if (this.nationalRank != null) {
            Kingdom kingdom;
            Kingdom kingdom2 = kingdom = this.kingdom == null ? null : Kingdom.getKingdom(this.kingdom);
            if (kingdom != null) {
                KingdomPlayer nextKing;
                Rank nationalRankObj;
                Nation nation;
                Nation nation2 = nation = kingdom.hasNation() ? Nation.getNation(kingdom.getNationId()) : null;
                if (nation != null && (nationalRankObj = nation.getRanks().get(this.nationalRank)) != null && nationalRankObj.isKing() && (nextKing = Rank.determineNextKing(kingdom.unsafeGetMembers().stream().map(KingdomPlayer::getKingdomPlayer).collect(Collectors.toList()), false)) != null) {
                    nextKing.nationalRank = nation.getRanks().getHighestRank().getNode();
                }
            }
        }
        this.silentlyLeaveKingdom();
        return event;
    }

    @ApiStatus.Internal
    public void silentlyLeaveKingdom() {
        this.kingdom = null;
        this.rank = null;
        this.nationalRank = null;
        this.jailCell = null;
        this.flying = false;
        this.autoClaim = null;
        this.chatChannel = KingdomsChatChannel.getGlobalChannel().getDataId();
        this.joinedAt = System.currentTimeMillis();
        this.landHistoryPosition = -1;
        this.landHistory.clear();
        this.claims.clear();
        this.readMails.clear();
    }

    @NotNull
    public Language getLanguage() {
        return this.language.isInstalled() ? this.language : (this.language = Language.getDefault());
    }

    public void setLanguage(Language language) {
        this.language = Objects.requireNonNull(language, "Players language cannot be null");
    }

    public KingdomJoinEvent joinKingdom(@NonNull Kingdom kingdom) {
        return this.joinKingdom(kingdom, null);
    }

    public KingdomJoinEvent joinKingdom(@NonNull Kingdom kingdom, @Nullable Consumer<KingdomJoinEvent> modifier) {
        Objects.requireNonNull(kingdom, "Cannot join a null kingdom");
        Validate.isTrue(!kingdom.getId().equals(this.kingdom), "Player is already in this kingdom");
        KingdomJoinEvent event = new KingdomJoinEvent(kingdom, this);
        if (modifier != null) {
            modifier.accept(event);
        }
        if (!event.isCancelled()) {
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return event;
            }
        }
        this.joinedAt = System.currentTimeMillis();
        this.kingdom = kingdom.getId();
        this.totalDonations = 0.0;
        this.lastDonationAmount = 0.0;
        kingdom.unsafeGetMembers().add(this.id);
        return event;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KingdomPlayer)) {
            return false;
        }
        KingdomPlayer kp = (KingdomPlayer)obj;
        return FastUUID.equals(this.id, kp.id);
    }

    public @Nullable UUID getKingdomId() {
        return this.kingdom;
    }

    @Override
    public @NonNull UUID getKey() {
        return this.id;
    }

    public @NonNull KingdomsChatChannel getChatChannel() {
        KingdomsChatChannel channel;
        if (this.chatChannel == null) {
            KingdomsChatChannel.getGlobalChannel();
        }
        if ((channel = KingdomsChatChannel.fromId(this.chatChannel)) != null) {
            return channel;
        }
        this.chatChannel = null;
        return KingdomsChatChannel.getGlobalChannel();
    }

    public @Nullable String getChatChannelId() {
        return this.chatChannel;
    }

    public PlayerChangeChatChannelEvent setChatChannel(@NonNull KingdomsChatChannel newChannel) {
        PlayerChangeChatChannelEvent event = new PlayerChangeChatChannelEvent(this, newChannel);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.chatChannel = event.getNewChannel().getDataId();
        }
        return event;
    }

    public @NonNull GroupResourcePointConvertEvent donate(Kingdom kingdom, double amount) {
        return this.donate(kingdom, amount, null, null, null);
    }

    public @NonNull GroupResourcePointConvertEvent donate(Group group, @NotNull ConvertedResourcePoints rp) {
        Objects.requireNonNull(rp);
        return this.donate(group, rp.getTotalWorth(), rp.getOriginalItems(), rp.getConvertedItems(), rp.getLeftOvers());
    }

    public @NonNull GroupResourcePointConvertEvent donate(Group group, double amount, @Nullable Collection<ItemStack> originalItems, @Nullable Collection<ItemStack> convertedItems, @Nullable Collection<ItemStack> leftOvers) {
        GroupResourcePointConvertEvent donateEvent = new GroupResourcePointConvertEvent(group, amount, this, originalItems, convertedItems, leftOvers);
        Bukkit.getPluginManager().callEvent((Event)donateEvent);
        if (donateEvent.isCancelled()) {
            return donateEvent;
        }
        amount = donateEvent.getAmount();
        this.totalDonations += amount;
        long time = KingdomsConfig.ResourcePoints.LAST_DONATION_DURATION.getManager().getTimeMillis();
        long current = System.currentTimeMillis();
        long diff = current - this.lastDonationTime;
        if (diff >= time) {
            this.lastDonationTime = current;
            this.lastDonationAmount = (long)amount;
        } else {
            this.lastDonationAmount += amount;
        }
        return donateEvent;
    }

    public boolean hasPermission(@NonNull KingdomPermission permission) {
        return this.hasAnyPermission(permission);
    }

    public boolean hasAnyPermission(KingdomPermission ... permissions) {
        if (this.isAdmin()) {
            return true;
        }
        Objects.requireNonNull(permissions, "Cannot check null permission");
        if (!this.hasKingdom()) {
            throw new NullPointerException("Cannot check permission of a player that is not in a kingdom: " + this.id + " | " + this.getOfflinePlayer().getName());
        }
        Rank rank = this.getRank();
        for (KingdomPermission permission : permissions) {
            if (permission == null || !rank.hasPermission(permission)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNationPermission(@NonNull KingdomPermission permission) {
        if (this.isAdmin()) {
            return true;
        }
        Objects.requireNonNull(permission, "Cannot check null nation permission");
        if (!this.hasKingdom()) {
            throw new NullPointerException("Cannot check nation permission of a player that is not in a kingdom: " + this.id + " | " + this.getOfflinePlayer().getName());
        }
        return this.getNationRank().hasPermission(permission);
    }

    public void processClaims(@NonNull Set<SimpleChunkLocation> lands, boolean claimed, boolean history) {
        if (history && KingdomsConfig.Claims.HISTORY_ENABLED.getManager().getBoolean()) {
            int limit = KingdomsConfig.Claims.HISTORY_LIMIT.getManager().getInt();
            this.landHistoryPosition = this.landHistory.size();
            if (this.landHistory.size() >= limit) {
                this.landHistory.removeFirst();
            }
            this.landHistory.add(new ClaimingHistory(lands, claimed));
        }
        if (claimed) {
            this.claims.addAll(lands);
        } else {
            this.claims.removeAll(lands);
        }
    }

    public long getLastDonationTime() {
        return this.lastDonationTime;
    }

    public void setLastDonationTime(long lastDonationTime) {
        this.lastDonationTime = lastDonationTime;
    }

    public @Nullable ClaimingHistory claimingHistory(boolean undo) {
        if (this.landHistory.isEmpty()) {
            return null;
        }
        if (this.landHistoryPosition <= -1 || this.landHistoryPosition >= this.landHistory.size()) {
            if (undo) {
                if (this.landHistoryPosition - 1 <= -1) {
                    return null;
                }
                --this.landHistoryPosition;
            } else {
                if (this.landHistoryPosition + 1 >= this.landHistory.size()) {
                    return null;
                }
                ++this.landHistoryPosition;
            }
            return this.landHistory.get(this.landHistoryPosition);
        }
        ClaimingHistory land = this.landHistory.get(this.landHistoryPosition);
        this.landHistoryPosition = undo ? --this.landHistoryPosition : ++this.landHistoryPosition;
        return land;
    }

    @NotNull
    public List<ClaimingHistory> getClaimingHistory() {
        return this.landHistory;
    }

    public @NonNull UUID getId() {
        return this.id;
    }

    public Boolean getAutoClaim() {
        return this.autoClaim;
    }

    public void setAutoClaim(Boolean autoClaim) {
        this.autoClaim = autoClaim;
    }

    public boolean isInvading() {
        return this.invasion != null;
    }

    @Override
    public @Nullable Invasion getInvasion() {
        return this.invasion;
    }

    public void setInvasion(@Nullable Invasion invasion) {
        this.invasion = invasion;
    }

    public @NonNull Set<UUID> getReadMails() {
        this.readMails.removeIf(read -> !KingdomsDataCenter.get().getMTG().exists(read));
        return this.readMails;
    }

    public void setReadMails(@NonNull Set<UUID> readMails) {
        this.readMails = readMails;
    }

    public void readMail(Mail mail) {
        Objects.requireNonNull(mail, "Cannot read null mail");
        this.readMails.add(mail.getId());
    }

    public long getJoinedAt() {
        return this.joinedAt;
    }

    public @NonNull Map<UUID, KingdomInvite> getInvites() {
        return this.invites;
    }

    @ApiStatus.Internal
    public void setInvites(@NonNull Map<UUID, KingdomInvite> invites) {
        this.invites = invites;
    }

    public double getTotalDonations() {
        return this.totalDonations;
    }

    public void setTotalDonations(double totalDonations) {
        this.totalDonations = totalDonations;
    }

    public double getLastDonationAmount() {
        return this.lastDonationAmount;
    }

    public void setLastDonationAmount(long lastDonationAmount) {
        this.lastDonationAmount = lastDonationAmount;
    }

    public boolean isHigher(@NonNull KingdomPlayer kp) {
        return this.getRank().isHigherThan(kp.getRank());
    }

    public boolean isUsingMarkers() {
        return this.flags.get(DefaultDataFlags.Players.MARKERS);
    }

    public void setUsingMarkers(boolean markers) {
        this.flags.put(DefaultDataFlags.Players.MARKERS, Boolean.valueOf(markers));
    }

    public @NonNull Set<SimpleChunkLocation> getClaims() {
        return this.claims;
    }

    public void setClaims(@NonNull Set<SimpleChunkLocation> claims) {
        this.claims = claims;
    }

    public long getLastPowerCheckup() {
        return this.lastPowerCheckup;
    }

    public int getLandHistoryPosition() {
        return this.landHistoryPosition;
    }

    public void setLandHistoryPosition(int landHistoryPosition) {
        Validate.isTrue(landHistoryPosition < this.landHistory.size(), "Land history position cannot be bigger than the land history size.");
        this.landHistoryPosition = landHistoryPosition;
    }

    public boolean isAutoMap() {
        return this.autoMap;
    }

    public void setAutoMap(boolean autoMap) {
        this.autoMap = autoMap;
    }

    public @Nullable Pair<Integer, Integer> getMapSize() {
        return this.mapSize;
    }

    public void setMapSize(@Nullable Pair<Integer, Integer> mapSize) {
        this.mapSize = mapSize;
        if (KingdomsMap.SCOREBOARDS.containsKey(this.id) && this.getPlayer() != null) {
            this.buildMap().displayAsScoreboard();
        }
    }

    public boolean isAdmin() {
        return this.flags.get(DefaultDataFlags.Players.ADMIN);
    }

    public void setAdmin(boolean admin) {
        this.flags.put(DefaultDataFlags.Players.ADMIN, Boolean.valueOf(admin));
    }

    public boolean isPvp() {
        return this.flags.get(DefaultDataFlags.Players.PVP);
    }

    public void setPvp(boolean pvp) {
        this.flags.put(DefaultDataFlags.Players.PVP, Boolean.valueOf(pvp));
    }

    public @Nullable String getNationRankNode() {
        return this.nationalRank;
    }

    public @Nullable Rank getNationRank() {
        Kingdom kingdom = this.getKingdom();
        if (kingdom == null) {
            return null;
        }
        Nation nation = kingdom.getNation();
        if (nation == null) {
            return null;
        }
        if (this.nationalRank == null) {
            return nation.getRanks().getLowestRank();
        }
        Rank rank = nation.getRanks().get(this.nationalRank);
        if (rank != null) {
            return rank;
        }
        rank = Objects.equals(this.id, kingdom.getKingId()) ? nation.getRanks().getHighestRank() : nation.getRanks().getLowestRank();
        this.nationalRank = rank.getNode();
        return rank;
    }

    public boolean isFlying() {
        return this.flying;
    }

    public void setFlying(boolean flying, @Nullable Float speed) {
        KingdomFlightToggleEvent event = new KingdomFlightToggleEvent(this, flying);
        Server.get().getEventHandler().callEvent(event);
        if (event.isCancelled()) {
            return;
        }
        this.flying = flying;
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        if (flying) {
            player.setAllowFlight(true);
            player.setFlySpeed(speed != null ? speed.floatValue() : FlyManager.getDefaultSpeed(player));
        } else {
            player.setFlySpeed(speed != null ? speed.floatValue() : (float)KingdomsConfig.KINGDOM_FLY_NORMAL_FLIGHT_SPEED.getDouble());
            player.setFlying(false);
            player.setAllowFlight(false);
        }
    }

    public KingdomsMap buildMap() {
        Player player = Objects.requireNonNull(this.getPlayer(), "Cannot show map to offline player");
        return new KingdomsMap().forPlayer(player);
    }

    public boolean isSpy() {
        return this.flags.get(DefaultDataFlags.Players.SPY);
    }

    public void setSpy(boolean spy) {
        this.flags.put(DefaultDataFlags.Players.SPY, Boolean.valueOf(spy));
    }

    public @Nullable String getMarkersType() {
        return this.markersType;
    }

    public void setMarkersType(@Nullable String markersType) {
        this.markersType = markersType;
    }

    public double getPower() {
        this.updatePower(null);
        return this.power;
    }

    public double addPower(double power) {
        return this.setPower(this.power + power);
    }

    public double setPower(double power) {
        return this.setPower(power, false);
    }

    public double setPower(double power, boolean ignoreLimits) {
        this.lastPowerCheckup = System.currentTimeMillis();
        if (ignoreLimits) {
            this.power = power;
            return this.power;
        }
        OfflinePlayer player = this.getOfflinePlayer();
        double min = MathUtils.eval(KingdomsConfig.Powers.POWER_PLAYER_MIN.getManager().getString(), player, new Object[0]);
        double max = MathUtils.eval(KingdomsConfig.Powers.POWER_PLAYER_MAX.getManager().getString(), player, new Object[0]);
        this.power = Math.max(min, Math.min(max, power));
        return this.power;
    }

    public @NonNull Set<SimpleLocation> getProtectedBlocks() {
        return this.protectedBlocks;
    }

    @ApiStatus.Internal
    public void setProtectedBlocks(@NonNull Set<SimpleLocation> protectedBlocks) {
        this.protectedBlocks = Objects.requireNonNull(protectedBlocks, "Player's protected blocks cannot be null");
    }

    public boolean isInSneakMode() {
        return this.flags.get(DefaultDataFlags.Players.SNEAK_MODE);
    }

    public void setSneakMode(boolean sneakMode) {
        this.flags.put(DefaultDataFlags.Players.SNEAK_MODE, Boolean.valueOf(sneakMode));
    }

    public void updatePower(@Nullable Boolean online) {
        if (!KingdomsConfig.Powers.POWER_ENABLED.getManager().getBoolean()) {
            return;
        }
        OfflinePlayer player = this.getOfflinePlayer();
        long now = System.currentTimeMillis();
        long passed = now - this.lastPowerCheckup;
        this.lastPowerCheckup = now;
        if (online == null) {
            online = player.isOnline();
        }
        if (online.booleanValue()) {
            long every = KingdomsConfig.Powers.POWER_PLAYER_REGENERATION_EVERY.getManager().getTimeMillis(TimeUnit.MINUTES);
            double div = (double)passed / (double)every;
            if (div > 0.0) {
                double charge = MathUtils.eval(KingdomsConfig.Powers.POWER_PLAYER_REGENERATION_CHARGE.getManager().getString(), player, new Object[0]);
                double max = MathUtils.eval(KingdomsConfig.Powers.POWER_PLAYER_MAX.getManager().getString(), player, new Object[0]);
                this.power += charge * div;
                this.power = Math.min(max, this.power);
            }
        } else {
            long every;
            double div;
            double lose;
            double limit = MathUtils.eval(KingdomsConfig.Powers.POWER_PLAYER_LOSS_OFFLINE_MIN.getManager().getString(), player, new Object[0]);
            if (this.power > limit && (lose = MathUtils.eval(KingdomsConfig.Powers.POWER_PLAYER_LOSS_OFFLINE_LOSE.getManager().getString(), player, new Object[0])) != 0.0 && (div = (double)passed / (double)(every = KingdomsConfig.Powers.POWER_PLAYER_LOSS_OFFLINE_EVERY.getManager().getTimeMillis(TimeUnit.DAYS).longValue())) > 0.0) {
                this.power += -lose * div;
                this.power = Math.max(limit, this.power);
            }
        }
    }

    @Override
    public int compareTo(@NonNull KingdomPlayer other) {
        Rank otherRank;
        if (!Objects.equals(this.kingdom, other.kingdom)) {
            throw new IllegalArgumentException("Both players need to be in the same kingdom to be compared.");
        }
        if (!this.hasKingdom()) {
            return other.hasKingdom() ? -1 : 0;
        }
        if (!other.hasKingdom()) {
            return 1;
        }
        Rank rank = Objects.requireNonNull(this.getRank());
        int comparedRank = rank.compareTo(otherRank = Objects.requireNonNull(other.getRank()));
        if (comparedRank != 0) {
            return comparedRank;
        }
        return Long.compare(this.joinedAt, other.joinedAt);
    }

    public @NonNull Set<String> getMutedChannels() {
        return this.mutedChannels;
    }

    public void setMutedChannels(@NonNull Set<String> mutedChannels) {
        this.mutedChannels = mutedChannels;
    }

    @Override
    public void addMessageContextEdits(@NotNull MessagePlaceholderProvider context) {
        context.withContext(this.getOfflinePlayer());
    }

    @Override
    @NotNull
    public NamespacedFlags getFlags() {
        return this.flags;
    }

    @Override
    public void setFlags(@NotNull NamespacedFlags flags) {
        this.flags = Objects.requireNonNull(flags, "Flags cannot be null");
    }

    protected DataHandler<KingdomPlayer> getDataHandler() {
        return DataHandlerKingdomPlayer.INSTANCE;
    }

    @Override
    public boolean isDataEmpty() {
        return false;
    }
}

