/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.player;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.kingdoms.constants.namespace.Lockable;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.namespace.NamespacedRegistry;
import org.kingdoms.constants.player.KingdomPermission;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.main.Kingdoms;

public final class KingdomPermissionRegistry
extends NamespacedRegistry<KingdomPermission>
implements Lockable {
    private static boolean ACCEPT_REGISTERS = true;

    protected Map<Namespace, KingdomPermission> getRawRegistry() {
        return this.registry;
    }

    @Override
    public void register(KingdomPermission value) {
        if (value.getNamespace().getNamespace().equals("Kingdoms")) {
            throw new IllegalArgumentException("Cannot register custom permission as kingdoms namespace: " + value);
        }
        super.register(value);
    }

    public static @NonNull Set<KingdomPermission> parse(Collection<String> permissionList) {
        HashSet<KingdomPermission> permissions = new HashSet<KingdomPermission>();
        KingdomPermissionRegistry registry = Kingdoms.get().getPermissionRegistery();
        for (String permission : permissionList) {
            KingdomPermission perm = (KingdomPermission)((Object)registry.getRegistered(Namespace.fromString(permission)));
            if (perm == null) continue;
            permissions.add(perm);
        }
        return permissions;
    }

    @Override
    public void lock() {
        if (!ACCEPT_REGISTERS) {
            throw new IllegalAccessError("Registers are already closed");
        }
        ACCEPT_REGISTERS = false;
    }
}

