/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.namespace;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.namespace.Namespaced;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.utils.internal.nonnull.NonNullMap;
import org.kingdoms.utils.internal.string.ObjectPrettyStringFactory;

public class NamespacedMap<V>
implements Map<Namespace, V> {
    protected final Map<Namespace, V> map;

    public NamespacedMap() {
        this.map = new NonNullMap<Namespace, V>();
    }

    public NamespacedMap(Map<Namespace, V> map) {
        this.map = NonNullMap.of(map);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Nullable
    public V get(@NotNull Namespaced namespaced) {
        return this.get(namespaced.getNamespace());
    }

    @Override
    @Nullable
    public V put(Namespace key, V value) {
        return this.map.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(@NotNull Map<? extends Namespace, ? extends V> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    @NotNull
    public Set<Namespace> keySet() {
        return this.map.keySet();
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<Namespace, V>> entrySet() {
        return this.map.entrySet();
    }

    public String toString() {
        return ObjectPrettyStringFactory.toDefaultPrettyString(this);
    }
}

