/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.namespace;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.kingdoms.constants.DataStringRepresentation;
import org.kingdoms.constants.namespace.InvalidNamespaceException;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.dataflow.qual.Pure;
import org.kingdoms.libs.intellij.lang.annotations.Pattern;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;

public final class Namespace
implements DataStringRepresentation {
    private final @NonNull String namespace;
    private final @NonNull String key;
    private final int hashCode;
    private static final String ACCEPTED_KEYS = "[A-Z0-9_]{3,100}";
    private static final String ACCEPTED_NAMESPACES = "[A-Za-z]{3,20}";
    private static final java.util.regex.Pattern ACCEPTED_KEYS_PATTERN = java.util.regex.Pattern.compile("[A-Z0-9_]{3,100}");
    private static final java.util.regex.Pattern ACCEPTED_NAMESPACES_PATTERN = java.util.regex.Pattern.compile("[A-Za-z]{3,20}");
    public static final String KINGDOMS = "Kingdoms";
    public static final String MINECRAFT = "minecraft";
    private static final char SEPARATOR = ':';

    @Pure
    public Namespace(@Pattern(value="[A-Za-z]{3,20}") @NonNull String namespace, @Pattern(value="[A-Z0-9_]{3,100}") @NonNull String key) {
        if (namespace == null || !Namespace.isValidGroup(namespace)) {
            throw new InvalidNamespaceException(namespace + ':' + key, "Namespace string '" + namespace + "' doesn't match: " + ACCEPTED_NAMESPACES);
        }
        if (key == null || !Namespace.isValidKey(key)) {
            throw new InvalidNamespaceException(namespace + ':' + key, "Key string '" + key + "' doesn't match: " + ACCEPTED_KEYS);
        }
        this.namespace = namespace;
        this.key = key;
        this.hashCode = Namespace.hashCode0(namespace, key);
    }

    @Pure
    public static boolean isValidGroup(@Pattern(value="[A-Za-z]{3,20}") @NotNull String namespace) {
        return ACCEPTED_NAMESPACES_PATTERN.matcher(namespace).matches();
    }

    @Pure
    public static boolean isValidKey(@Pattern(value="[A-Z0-9_]{3,100}") @NotNull String key) {
        return ACCEPTED_KEYS_PATTERN.matcher(key).matches();
    }

    @Pure
    public @NonNull String getConfigOptionName() {
        String keyConfig = Namespace.configOption(this.key);
        if (this.isKingdoms()) {
            return keyConfig;
        }
        return this.namespace + ':' + keyConfig;
    }

    @Pure
    public @NonNull String asString() {
        return this.namespace + ':' + this.key;
    }

    @Pure
    public @NonNull String asNormalizedString() {
        if (this.isKingdoms()) {
            return this.key;
        }
        return this.asString();
    }

    @Pure
    @NotNull
    public static Namespace kingdoms(@Pattern(value="[A-Z0-9_]{3,100}") @NonNull String key) {
        return new Namespace(KINGDOMS, key);
    }

    @Pure
    public static @NonNull Namespace minecraft(@Pattern(value="[A-Z0-9_]{3,100}") @NonNull String key) {
        return new Namespace(MINECRAFT, key);
    }

    public boolean isKingdoms() {
        return KINGDOMS.equals(this.namespace);
    }

    @Pure
    public @NonNull String getNamespace() {
        return this.namespace;
    }

    @Pure
    public @NonNull String getKey() {
        return this.key;
    }

    public static @NonNull Namespace fromString(@NonNull String str) throws InvalidNamespaceException {
        if (str == null || str.isEmpty()) {
            throw new InvalidNamespaceException(str, "Cannot get namespace from null or empty string: '" + str + '\'');
        }
        int separator = str.indexOf(58);
        if (separator == -1) {
            return Namespace.kingdoms(str);
        }
        String namespace = str.substring(0, separator);
        String key = str.substring(separator + 1);
        return new Namespace(namespace, key);
    }

    public static Namespace fromConfigString(@NonNull String str) throws InvalidNamespaceException {
        if (str == null || str.isEmpty()) {
            throw new InvalidNamespaceException(str, "Cannot get namespace from null or empty string: '" + str + '\'');
        }
        int separator = str.indexOf(58);
        if (separator == -1) {
            return Namespace.kingdoms(Namespace.configOptionToEnum(str));
        }
        String namespace = str.substring(0, separator);
        String key = str.substring(separator + 1);
        return new Namespace(namespace, Namespace.configOptionToEnum(key));
    }

    @Pure
    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.asString() + ']';
    }

    @Pure
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Namespace)) {
            return false;
        }
        Namespace other = (Namespace)obj;
        return this.namespace.equals(other.namespace) && this.key.equals(other.key);
    }

    @Pure
    public int hashCode() {
        return this.hashCode;
    }

    private static int hashCode0(String namespace, String key) {
        int hash = 5;
        hash = 47 * hash + namespace.hashCode();
        hash = 47 * hash + key.hashCode();
        return hash;
    }

    private static String configOptionToEnum(String str) {
        char[] chars = str.toCharArray();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = chars[i];
            chars[i] = ch == '-' ? 95 : (char)(ch & 0x5F);
        }
        return new String(chars);
    }

    private static String configOption(String str) {
        char[] chars = str.toCharArray();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = chars[i];
            chars[i] = ch == '_' ? 45 : (char)(ch | 0x20);
        }
        return new String(chars);
    }

    public static List<Namespace> path(String ... keys) {
        return Arrays.stream(keys).map(Namespace::kingdoms).collect(Collectors.toList());
    }

    @Override
    @NotNull
    public String asDataString() {
        return this.asNormalizedString();
    }
}

