/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.metadata;

import java.util.Collection;
import org.kingdoms.constants.base.KeyedKingdomsObject;
import org.kingdoms.constants.metadata.KingdomMetadataHandler;
import org.kingdoms.constants.namespace.Lockable;
import org.kingdoms.constants.namespace.NamespacedRegistry;
import org.kingdoms.data.managers.base.KeyedDataManager;

public final class KingdomMetadataRegistry
extends NamespacedRegistry<KingdomMetadataHandler>
implements Lockable {
    private static boolean ACCEPT_REGISTERS = true;

    @Override
    public void register(KingdomMetadataHandler value) {
        if (value.getNamespace().getNamespace().equals("Kingdoms")) {
            throw new IllegalArgumentException("Cannot register metadata handlers as kingdoms namespace: " + value);
        }
        super.register(value);
    }

    @Override
    public void lock() {
        if (!ACCEPT_REGISTERS) {
            throw new IllegalAccessError("Registers are already closed");
        }
        ACCEPT_REGISTERS = false;
    }

    public static void removeMetadata(KeyedDataManager<?, ?> dataManager, Collection<KingdomMetadataHandler> metadataHandlers) {
        for (KeyedKingdomsObject data : dataManager.getLoadedData()) {
            metadataHandlers.forEach(x -> data.getMetadata().remove(x));
        }
    }
}

